/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.screwdriving.program.AllParameters;
import com.ur.polyscope.screwdriving.program.ScrewdriverProgramImpl;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.simpsons.installation.ProgramList;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverOperationType;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import java.util.Optional;

public class DynamicOperationParameters
implements AllParameters {
    private final ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution;

    public DynamicOperationParameters(ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution) {
        this.screwdrivingProgramNodeContribution = screwdrivingProgramNodeContribution;
    }

    public ScrewdriverProgram getScrewdriverProgram() {
        return this.getSelectedScrewdriverProgram();
    }

    public ScrewdriverOperationType getScrewdriverOperationType() {
        return this.screwdrivingProgramNodeContribution.isTightening() ? ScrewdriverOperationType.TIGHTEN : ScrewdriverOperationType.LOOSEN;
    }

    private ScrewdriverProgram getSelectedScrewdriverProgram() {
        String programid = this.getSelectedProgramText();
        ScrewdriverProgramImpl selectedProgram = null;
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.screwdrivingProgramNodeContribution.getCapabilitiesDefinition();
        if (capabilitiesDefinition.isPresent()) {
            if (!capabilitiesDefinition.get().getCapability(Capability.CapabilityType.PROGRAM_SELECTION).isPresent()) {
                throw new UnsupportedOperationException(this.screwdrivingProgramNodeContribution.getTextResource().programSelectionNotSupported());
            }
            if (this.screwdrivingProgramNodeContribution.isBitwiseSelection()) {
                ProgramList programs = capabilitiesDefinition.get().getProgramList();
                selectedProgram = programs.getPrograms().stream().filter(screwdriverProgram -> screwdriverProgram.getId().equals(programid)).findFirst().orElse(null);
            } else {
                selectedProgram = new ScrewdriverProgramImpl(programid, programid);
            }
        } else {
            selectedProgram = new ScrewdriverProgramImpl("NOT_A_KEY", this.screwdrivingProgramNodeContribution.getTextResource().selectProgram());
        }
        return selectedProgram;
    }

    private String getSelectedProgramText() {
        String result = this.screwdrivingProgramNodeContribution.isBitwiseSelection() ? this.screwdrivingProgramNodeContribution.getBitwiseProgramSelectionFromModel() : this.screwdrivingProgramNodeContribution.getTextProgramSelectionFromModel();
        return result;
    }
}

