/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class IOscriptGeneration {
    private IOscriptGeneration() {
    }

    private static String getIOPin(IO io) {
        String defaultName = io.getDefaultName();
        return defaultName.substring(defaultName.lastIndexOf(91) + 1, defaultName.lastIndexOf(93));
    }

    private static String generateBoolean(boolean b) {
        if (b) {
            return "True";
        }
        return "False";
    }

    private static void generateSetIntegerIO(ScriptWriter scriptWriter, IO io, Integer value) {
        if (io != null) {
            if (io.getInterfaceType() == IO.InterfaceType.UR_MODBUS) {
                scriptWriter.appendLine("modbus_set_output_register(\"" + io.getName() + "\"," + value + ")");
            } else {
                String pin = IOscriptGeneration.getIOPin(io);
                scriptWriter.appendLine("write_output_integer_register(" + pin + "," + value + ")");
            }
        }
    }

    public static void generateSetBinaryIO(ScriptWriter scriptWriter, IO io, boolean turnOn) {
        String bool = IOscriptGeneration.generateBoolean(turnOn);
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_MODBUS)) {
            scriptWriter.appendLine("modbus_set_output_signal(\"" + io.getName() + "\"," + bool + ")");
        } else if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_STANDARD)) {
            scriptWriter.appendLine("set_standard_digital_out(" + IOscriptGeneration.getIOPin(io) + "," + bool + ")");
        } else if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_TOOL)) {
            scriptWriter.appendLine("set_tool_digital_out(" + IOscriptGeneration.getIOPin(io) + "," + bool + ")");
        } else if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_CONFIGURABLE)) {
            scriptWriter.appendLine("set_configurable_digital_out(" + IOscriptGeneration.getIOPin(io) + "," + bool + ")");
        } else if (io.getType().equals((Object)IO.IOType.BOOLEAN)) {
            scriptWriter.appendLine("write_output_boolean_register(" + IOscriptGeneration.getIOPin(io) + "," + bool + ")");
        }
    }

    public static void generateProgramSelection(ScriptWriter scriptWriter, IO[] programSelectionOutputs, Integer programFromModel) {
        if (IOscriptGeneration.isUsingBitWiseProgramSelection(programSelectionOutputs)) {
            int i;
            List<Object> ios = Arrays.asList(programSelectionOutputs);
            ios = ios.stream().filter(Objects::nonNull).collect(Collectors.toList());
            String bin = Integer.toBinaryString(programFromModel);
            bin = new StringBuilder(bin).reverse().toString();
            for (i = 0; i < bin.length(); ++i) {
                if (bin.charAt(i) == '1') {
                    IOscriptGeneration.generateSetBinaryIO(scriptWriter, (IO)ios.get(i), true);
                    continue;
                }
                IOscriptGeneration.generateSetBinaryIO(scriptWriter, (IO)ios.get(i), false);
            }
            while (i < ios.size()) {
                IOscriptGeneration.generateSetBinaryIO(scriptWriter, (IO)ios.get(i), false);
                ++i;
            }
        } else {
            IOscriptGeneration.generateSetIntegerIO(scriptWriter, programSelectionOutputs[0], programFromModel);
        }
    }

    private static boolean isUsingBitWiseProgramSelection(IO[] programSelectionOutputs) {
        return Arrays.stream(programSelectionOutputs).anyMatch(io -> io != null && io.getType() != IO.IOType.INTEGER);
    }

    public static String generateIOCondition(IO okio, boolean b) {
        return IOscriptGeneration.generateGetBinaryIO(okio) + " == " + IOscriptGeneration.generateBoolean(b);
    }

    private static String generateGetBinaryIO(IO io) {
        return io.isInput() ? IOscriptGeneration.generateGetBinaryInputIO(io) : IOscriptGeneration.generateGetBinaryOutputIO(io);
    }

    private static String generateGetBinaryInputIO(IO io) {
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_MODBUS)) {
            return "modbus_get_signal_status(\"" + io.getName() + "\")";
        }
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_STANDARD)) {
            return "get_standard_digital_in(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_TOOL)) {
            return "get_tool_digital_in(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_CONFIGURABLE)) {
            return "get_configurable_digital_in(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        if (io.getType().equals((Object)IO.IOType.BOOLEAN)) {
            return "read_input_boolean_register(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        return "";
    }

    private static String generateGetBinaryOutputIO(IO io) {
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_MODBUS)) {
            return "modbus_get_signal_status(\"" + io.getName() + "\")";
        }
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_STANDARD)) {
            return "get_standard_digital_out(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_TOOL)) {
            return "get_tool_digital_out(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        if (io.getInterfaceType().equals((Object)IO.InterfaceType.UR_CONFIGURABLE)) {
            return "get_configurable_digital_out(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        if (io.getType().equals((Object)IO.IOType.BOOLEAN)) {
            return "read_output_boolean_register(" + IOscriptGeneration.getIOPin(io) + ")";
        }
        return "";
    }
}

