/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.screwdriving.handlers.MachineErrorHandlerType;
import com.ur.polyscope.screwdriving.handlers.MachineErrorProgramNodeService;
import com.ur.polyscope.screwdriving.program.ProgramViewService;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.screwdriving.util.AbstractCustomProgramNodeContribution;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import java.util.List;
import java.util.Optional;

public class MachineErrorHandlerService {
    private static final Logger LOG = LogFactory.createLogger(MachineErrorHandlerService.class);
    private final ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution;
    private final ProgramViewService programViewService;

    public MachineErrorHandlerService(ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution, ProgramViewService programViewService) {
        this.screwdrivingProgramNodeContribution = screwdrivingProgramNodeContribution;
        this.programViewService = programViewService;
    }

    public void addMachineErrorHandlerNode() {
        ProgramNodeFactory programNodeFactory = this.screwdrivingProgramNodeContribution.getProgramAPI().getProgramModel().getProgramNodeFactory();
        TreeNode rootTreeNode = this.screwdrivingProgramNodeContribution.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this.screwdrivingProgramNodeContribution);
        this.screwdrivingProgramNodeContribution.getUndoRedoManager().recordChanges(() -> {
            this.screwdrivingProgramNodeContribution.getDataModel().set(ScrewdrivingProgramNodeContribution.getKeyMachineErrorNodeSelected(), true);
            URCapProgramNode machineErrorHandlerNode = programNodeFactory.createURCapProgramNode(MachineErrorProgramNodeService.class);
            List children = rootTreeNode.getChildren();
            TreeNode firstChild = null;
            if (!children.isEmpty()) {
                firstChild = (TreeNode)children.get(0);
            }
            try {
                if (firstChild == null) {
                    rootTreeNode.addChild((ProgramNode)machineErrorHandlerNode);
                } else {
                    rootTreeNode.insertChildBefore(firstChild, (ProgramNode)machineErrorHandlerNode);
                }
                MachineErrorHandlerType machineErrorHandlerType = (MachineErrorHandlerType)machineErrorHandlerNode.getAs(MachineErrorHandlerType.class);
                ((AbstractCustomProgramNodeContribution)((Object)machineErrorHandlerType)).setParentContribution(this.screwdrivingProgramNodeContribution);
            }
            catch (TreeStructureException e) {
                LOG.error("Unable to insert Machine Handler node", (Throwable)e);
            }
        });
        this.programViewService.updateView();
    }

    public void removeMachineErrorHandlerNode() {
        this.screwdrivingProgramNodeContribution.getUndoRedoManager().recordChanges(() -> {
            this.screwdrivingProgramNodeContribution.getDataModel().set(ScrewdrivingProgramNodeContribution.getKeyMachineErrorNodeSelected(), false);
            Optional<TreeNode> machineErrorHandlerNode = this.getMachineErrorHandlerNode();
            if (machineErrorHandlerNode.isPresent()) {
                try {
                    TreeNode rootNode = this.screwdrivingProgramNodeContribution.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this.screwdrivingProgramNodeContribution);
                    rootNode.removeChild(machineErrorHandlerNode.get());
                }
                catch (TreeStructureException e) {
                    LOG.error("Unable to remove MachineErrorHandlerNode", (Throwable)e);
                }
            }
        });
        this.programViewService.updateView();
    }

    public Optional<TreeNode> getMachineErrorHandlerNode() {
        TreeNode rootNode = this.screwdrivingProgramNodeContribution.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this.screwdrivingProgramNodeContribution);
        for (TreeNode treeNode : rootNode.getChildren()) {
            ProgramNode programNode = treeNode.getProgramNode();
            if (!(programNode instanceof URCapProgramNode) || !((URCapProgramNode)programNode).canGetAs(MachineErrorHandlerType.class)) continue;
            return Optional.of(treeNode);
        }
        return Optional.empty();
    }
}

