/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.monitor.model.Pose6d;
import com.ur.util.logging.Log;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class Pose6dTransformUtils {
    private Pose6dTransformUtils() {
    }

    public static Pose6d getTransformed(Pose6d pose6d, Transform3D transformation) {
        Transform3D t3d = new Transform3D(transformation);
        t3d.mul(Pose6dTransformUtils.getTransform3D(pose6d));
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D(t3d);
    }

    public static Pose6d getInverseTransformed(Pose6d pose6d, Transform3D transformation) {
        Transform3D t3d = new Transform3D(transformation);
        Transform3D t3dCopy = new Transform3D(transformation);
        try {
            t3d.invert();
        }
        catch (Exception e) {
            Log.error((String)("Inversion of transform failed: " + t3dCopy), (Throwable)e);
            t3d.setIdentity();
        }
        t3d.mul(Pose6dTransformUtils.getTransform3D(pose6d));
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D(t3d);
    }

    public static Pose6d getPoseWithModifiedOffset(Pose6d pose6d, Pose6d oldOffset, Pose6d newOffset) {
        Pose6d temp = Pose6dTransformUtils.getInverseTransformed(newOffset, Pose6dTransformUtils.getTransform3D(oldOffset));
        return Pose6dTransformUtils.getTransformed(temp, Pose6dTransformUtils.getTransform3D(pose6d));
    }

    public static Transform3D getTransform3D(Pose6d pose6d) {
        Transform3D t3d = new Transform3D();
        double angle = pose6d.getRot().length();
        AxisAngle4d aa4d = new AxisAngle4d(pose6d.getRot(), angle);
        t3d.set(aa4d);
        t3d.setTranslation(pose6d.getPos());
        return t3d;
    }

    public static Pose6d getPose6dEquivalentOfTransform3D(Transform3D t3d) {
        return new Pose6d((Tuple3d)Pose6dTransformUtils.getPos(t3d), (Tuple3d)Pose6dTransformUtils.getRot(t3d));
    }

    private static Vector3d getRotationVector(Matrix3d rot) {
        double eps1 = 1.0E-6;
        double eps2 = 1.0E-14;
        double trace = rot.m00 + rot.m11 + rot.m22;
        double cosTheta = 0.5 * (trace - 1.0);
        if (cosTheta > 1.0) {
            cosTheta = 1.0;
        } else if (cosTheta < -1.0) {
            cosTheta = -1.0;
        }
        double angleLocal = Math.acos(cosTheta);
        Vector3d axisLocal = new Vector3d();
        axisLocal.x = rot.m21 - rot.m12;
        axisLocal.y = rot.m02 - rot.m20;
        axisLocal.z = rot.m10 - rot.m01;
        if (Math.abs(angleLocal) < eps1) {
            if (Math.abs(angleLocal) < eps2) {
                return new Vector3d(0.0, 0.0, 0.0);
            }
            axisLocal.scale(0.5);
            return axisLocal;
        }
        if (Math.abs(angleLocal - Math.PI) < eps1) {
            double z;
            double y;
            double x;
            double xx = (rot.m00 + 1.0) / 2.0;
            double yy = (rot.m11 + 1.0) / 2.0;
            double zz = (rot.m22 + 1.0) / 2.0;
            double xy = (rot.m01 + rot.m10) / 4.0;
            double xz = (rot.m02 + rot.m20) / 4.0;
            double yz = (rot.m12 + rot.m21) / 4.0;
            if (xx > yy && xx > zz) {
                if (xx < eps2) {
                    x = 0.0;
                    y = 1.5707963267948966;
                    z = 1.5707963267948966;
                } else {
                    x = Math.sqrt(xx);
                    y = xy / x;
                    z = xz / x;
                }
            } else if (yy > zz) {
                if (yy < eps2) {
                    x = 1.5707963267948966;
                    y = 0.0;
                    z = 1.5707963267948966;
                } else {
                    y = Math.sqrt(yy);
                    x = xy / y;
                    z = yz / y;
                }
            } else if (zz < eps2) {
                x = 1.5707963267948966;
                y = 1.5707963267948966;
                z = 0.0;
            } else {
                z = Math.sqrt(zz);
                x = xz / z;
                y = yz / z;
            }
            axisLocal.x = x;
            axisLocal.y = y;
            axisLocal.z = z;
        }
        axisLocal.normalize();
        axisLocal.scale(angleLocal);
        return axisLocal;
    }

    public static double aggregatedDistanceTo(Pose6d pose, Pose6d otherPose) {
        return Pose6dTransformUtils.aggregatedDistanceTo(pose, otherPose.getPos(), otherPose.getRot());
    }

    private static double aggregatedDistanceTo(Pose6d pose, Vector3d p, Vector3d r) {
        Vector3d dp = new Vector3d(p);
        dp.sub((Tuple3d)pose.getPos());
        Vector3d axis1 = new Vector3d(r);
        double angle1 = axis1.length();
        double epsilon = 1.0E-8;
        if (angle1 < -epsilon || angle1 > epsilon) {
            axis1.normalize();
        } else {
            axis1.set(0.0, 0.0, 1.0);
        }
        AxisAngle4d aa4d1 = new AxisAngle4d(axis1, angle1);
        Vector3d axis2 = new Vector3d(pose.getRot());
        double angle2 = axis2.length();
        if (angle1 < -epsilon || angle1 > epsilon) {
            axis2.normalize();
        } else {
            axis2.set(0.0, 0.0, 1.0);
        }
        AxisAngle4d aa4d2 = new AxisAngle4d(axis2, angle2);
        Quat4d q4d1 = new Quat4d();
        q4d1.set(aa4d1);
        Quat4d q4d2 = new Quat4d();
        q4d2.set(aa4d2);
        q4d1.mulInverse(q4d2);
        aa4d1.set(q4d1);
        return dp.length() + 0.1 * Math.abs(Pose6dTransformUtils.calculateAngleWithAbsoluteValueNoMoreThanPi(aa4d1.angle));
    }

    private static double calculateAngleWithAbsoluteValueNoMoreThanPi(double angle) {
        double result;
        for (result = angle; result > Math.PI; result -= Math.PI * 2) {
        }
        while (result < -Math.PI) {
            result += Math.PI * 2;
        }
        return result;
    }

    public static Vector3d getPos(Transform3D transform) {
        Vector3d pos = new Vector3d();
        transform.get(pos);
        return pos;
    }

    public static Vector3d getRot(Transform3D transform) {
        Matrix3d rotMatrix = new Matrix3d();
        transform.get(rotMatrix);
        return Pose6dTransformUtils.getRotationVector(rotMatrix);
    }
}

