/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.move.Positional;
import com.ur.polyscope.screwdriving.program.Pose6dTransformUtils;
import com.ur.polyscope.urcaps.programnodes.ProgramNodeProxy;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.builtin.CircleMoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.DirectionNode;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.PalletNode;
import com.ur.urcap.api.domain.program.nodes.builtin.ScrewdrivingNode;
import com.ur.urcap.api.domain.program.nodes.builtin.UntilNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveJMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveLMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MovePMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.TCPSelection;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class PositionalFinder
extends ProgramNodeVisitor {
    private static HMCInterface hmcInterface;
    private static final double TCP_EPSILON = 0.05;
    private Map<Integer, TCPSelection.SelectionType> TCPtypes = new HashMap<Integer, TCPSelection.SelectionType>();
    private Positional positional;
    private TCP tcp;

    public PositionalFinder(MoveNode programNode, TCP tcp) {
        this.tcp = tcp;
        this.visit(programNode, 0, 0);
    }

    public Positional getFirstPositional() {
        return this.positional;
    }

    @Inject
    public static void setHmcInterface(HMCInterface hmcInterface) {
        PositionalFinder.hmcInterface = hmcInterface;
    }

    public void visit(MoveNode programNode, int index, int depth) {
        MoveNodeConfig config = programNode.getConfig();
        MoveNodeConfig.ConfigType configType = config.getConfigType();
        TCPSelection tcpSelection = null;
        if (configType == MoveNodeConfig.ConfigType.MOVE_J) {
            MoveJMoveNodeConfig moveJMoveNodeConfig = (MoveJMoveNodeConfig)config;
            tcpSelection = moveJMoveNodeConfig.getTCPSelection();
        } else if (configType == MoveNodeConfig.ConfigType.MOVE_L) {
            MoveLMoveNodeConfig moveLMoveNodeConfig = (MoveLMoveNodeConfig)config;
            tcpSelection = moveLMoveNodeConfig.getTCPSelection();
        } else if (configType == MoveNodeConfig.ConfigType.MOVE_P) {
            MovePMoveNodeConfig movePMoveNodeConfig = (MovePMoveNodeConfig)config;
            tcpSelection = movePMoveNodeConfig.getTCPSelection();
        } else {
            return;
        }
        TCPSelection.SelectionType type = tcpSelection.getType();
        this.TCPtypes.put(depth, type);
    }

    public void visit(CircleMoveNode programNode, int index, int depth) {
        this.findPositional((ProgramNode)programNode);
    }

    public void visit(PalletNode programNode, int index, int depth) {
        this.findPositional((ProgramNode)programNode);
    }

    public void visit(UntilNode programNode, int index, int depth) {
        this.findPositional((ProgramNode)programNode);
    }

    public void visit(WaypointNode programNode, int index, int depth) {
        this.findPositionalWaypoint(programNode, depth);
    }

    public void visit(DirectionNode programNode, int index, int depth) {
        this.findPositional((ProgramNode)programNode);
    }

    public void visit(ScrewdrivingNode programNode, int index, int depth) {
        this.findPositional((ProgramNode)programNode);
    }

    public void visit(URCapProgramNode programNode, int index, int depth) {
        this.findPositional((ProgramNode)programNode);
    }

    private void findPositional(ProgramNode programNode) {
        ProgramNodeProxy programNodeProxy;
        Object realProgramNode;
        if (this.positional == null && (realProgramNode = (programNodeProxy = (ProgramNodeProxy)programNode).getRealProgramNode()) instanceof Positional && !((Positional)realProgramNode).isUndefined() && ((Positional)realProgramNode).getPositionNodeType() == PositionNodeType.FIXED) {
            this.positional = (Positional)realProgramNode;
        }
    }

    private void findPositionalWaypoint(WaypointNode programNode, int depth) {
        if (this.positional == null) {
            TCPSelection.SelectionType selectionType;
            this.findPositional((ProgramNode)programNode);
            if (this.positional != null && (selectionType = this.TCPtypes.get(depth - 1)) != null && selectionType == TCPSelection.SelectionType.USE_ACTIVE_TCP && this.tcp != null) {
                this.adjustPositionalToScrewdrivingTCP();
            }
        }
    }

    private void adjustPositionalToScrewdrivingTCP() {
        JointPositionVector inverseKinematics;
        Pose6d controllerTCPOffset = RobotState.getLatestRobotState().tcpOffset;
        Pose6d screwdrivingTCPOffset = this.getPolyScopePose(this.tcp.getOffset());
        if (controllerTCPOffset.epsilonEquals(screwdrivingTCPOffset, 0.05)) {
            return;
        }
        JointPositionVector actualJointPositionVector = this.positional.getActualJointPositionVector();
        Pose6d tcpPose = PositionalFinder.getTCPPose(actualJointPositionVector);
        Pose6d poseWithScrewdrivingTCP = Pose6dTransformUtils.getPoseWithModifiedOffset(tcpPose, screwdrivingTCPOffset, controllerTCPOffset);
        if (!PositionalFinder.poseIsUndefined(poseWithScrewdrivingTCP) && (inverseKinematics = PositionalFinder.getInverseKinematics(poseWithScrewdrivingTCP, actualJointPositionVector)) != null && !inverseKinematics.isUndefined()) {
            this.positional = new Positional(){

                public boolean isUndefined() {
                    return false;
                }

                public JointPositionVector getActualJointPositionVector() {
                    return inverseKinematics;
                }

                public PositionNodeType getPositionNodeType() {
                    return PositionNodeType.FIXED;
                }
            };
        }
    }

    private static boolean poseIsUndefined(Pose6d pose) {
        boolean posIsNaN = Double.isNaN(pose.getX()) || Double.isNaN(pose.getY()) || Double.isNaN(pose.getZ());
        boolean rotIsNaN = Double.isNaN(pose.getRX()) || Double.isNaN(pose.getRY()) || Double.isNaN(pose.getRZ());
        return posIsNaN || rotIsNaN;
    }

    private Pose6d getPolyScopePose(Pose pose) {
        double[] doubles = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        return new Pose6d(doubles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pose6d getTCPPose(JointPositionVector jpv) {
        if (jpv == null || jpv.isUndefined()) {
            return null;
        }
        HMCResponse hmcResponseMessage = hmcInterface.sendHMCMessageAndWait("get_tcp_pose(" + jpv + ")");
        if (hmcResponseMessage != null) {
            FilterInputStream dis = null;
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                dis = new DataInputStream(bais);
                Pose6d pose6d = new Pose6d(((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble());
                return pose6d;
            }
            catch (IOException e) {
                Log.error((String)("HMC.getJointPath: Parse error (or similar) " + e));
            }
            finally {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e) {
                    Log.error((String)"", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static JointPositionVector getInverseKinematics(Pose6d pose, JointPositionVector near_jpv) {
        Point3d p = new Point3d((Tuple3d)pose.getPos());
        Point3d r = new Point3d((Tuple3d)pose.getRot());
        return PositionalFinder.getInverseKinematics(p, r, near_jpv);
    }

    public static JointPositionVector getInverseKinematics(Point3d pos, Point3d axisangle, JointPositionVector near_jpv) {
        String s = "get_inverse_kinematics([" + pos.x + "," + pos.y + "," + pos.z + "," + axisangle.x + "," + axisangle.y + "," + axisangle.z + "]," + near_jpv + ")";
        return PositionalFinder.receiveJointPositionVector(hmcInterface.sendHMCMessageAndWait(s));
    }

    private static JointPositionVector receiveJointPositionVector(HMCResponse hmcResponseMessage) {
        if (hmcResponseMessage != null) {
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
                return null;
            }
            if (hmcResponseMessage.getResponseData().length == 0) {
                Log.error((String)"Inverse kinematics failed, no solution found.");
                return null;
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                DataInputStream dis = new DataInputStream(bais);
                JointPositionVector newjpv = new JointPositionVector();
                for (int i = 0; i < 6; ++i) {
                    newjpv.setJoint(i, dis.readDouble());
                }
                dis.close();
                return newjpv;
            }
            catch (IOException e) {
                Log.error((String)("HMC.getJointPath: Parse error (or similar) " + e));
            }
        }
        return null;
    }
}

