/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.screwdriving.internal.ProgramNodeContext;
import com.ur.polyscope.screwdriving.internal.ScrewdrivingProgramContext;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.screwdriving.program.SpeedMode;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.simpsons.installation.ProgramList;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.Optional;

public class ProgramValidationService {
    private final ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution;
    private final ScrewdrivingProgramContext screwdrivingProgramContext;

    public ProgramValidationService(ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution, ScrewdrivingProgramContext screwdrivingProgramContext) {
        this.screwdrivingProgramNodeContribution = screwdrivingProgramNodeContribution;
        this.screwdrivingProgramContext = screwdrivingProgramContext;
    }

    public boolean isProgramProperlyDefined() {
        boolean isInstallationWellDefined = this.screwdrivingProgramNodeContribution.getScrewdrivingInstallationNode().isDefined();
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.screwdrivingProgramNodeContribution.getCapabilitiesDefinition();
        if (capabilitiesDefinition.isPresent()) {
            ProgramList possiblePrograms;
            CapabilitiesDefinition definition = capabilitiesDefinition.get();
            if (!definition.getCapability(Capability.CapabilityType.START_DRIVE_SCREW).isPresent()) {
                isInstallationWellDefined = false;
            }
            if (this.screwdrivingProgramNodeContribution.tcpMissingAndRequired(definition)) {
                isInstallationWellDefined = false;
            }
            if (definition.getCapability(Capability.CapabilityType.PROGRAM_SELECTION).isPresent() && !(possiblePrograms = definition.getProgramList()).getPrograms().isEmpty()) {
                String selection = this.screwdrivingProgramNodeContribution.getBitwiseProgramSelectionFromModel();
                isInstallationWellDefined &= possiblePrograms.getPrograms().stream().anyMatch(screwdriverProgram -> screwdriverProgram.getId().equals(selection));
            }
        } else {
            isInstallationWellDefined = false;
        }
        if (isInstallationWellDefined && this.screwdrivingProgramNodeContribution.isFollowScrewEnabledValue()) {
            isInstallationWellDefined = this.isFollowTheScrewDefined();
        }
        this.registerOperationParametersIfNecessary();
        return isInstallationWellDefined;
    }

    private void registerOperationParametersIfNecessary() {
        ProgramNodeContext context;
        if (!this.screwdrivingProgramNodeContribution.getNodeName().isEmpty() && (context = this.screwdrivingProgramContext.getContextForProgramNode(this.screwdrivingProgramNodeContribution.getNodeName())) == null && this.screwdrivingProgramNodeContribution.isActive()) {
            this.screwdrivingProgramNodeContribution.registerDynamicOperationParameters();
        }
    }

    private boolean isFollowTheScrewDefined() {
        ScrewdrivingProgramNodeContribution.FollowScrewMode followScrewMode = this.screwdrivingProgramNodeContribution.getFollowScrewMode();
        switch (followScrewMode) {
            case FORCE: {
                Force forceValue = this.screwdrivingProgramNodeContribution.getForceValue();
                Speed speedValueForce = this.screwdrivingProgramNodeContribution.getSpeedValue(SpeedMode.FORCE_SPEED);
                return forceValue != null && forceValue.getAs(this.screwdrivingProgramNodeContribution.getForceUnit()) > 0.0 && speedValueForce != null;
            }
            case SPEED: {
                Acceleration accelerationValue = this.screwdrivingProgramNodeContribution.getAccelerationValue();
                Speed speedValueSpeed = this.screwdrivingProgramNodeContribution.getSpeedValue(SpeedMode.SPEED_SPEED);
                return accelerationValue != null && speedValueSpeed != null;
            }
            case EXPRESSION: {
                return this.isExpressionDefined();
            }
        }
        return true;
    }

    private boolean isExpressionDefined() {
        String untilExpression = this.screwdrivingProgramNodeContribution.getUntilExpression();
        Speed speedValueExpr = this.screwdrivingProgramNodeContribution.getSpeedValue(SpeedMode.EXPRESSION_SPEED);
        boolean defined = true;
        defined &= untilExpression != null && !untilExpression.isEmpty();
        return defined &= speedValueExpr != null;
    }
}

