/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeContribution;
import com.ur.polyscope.screwdriving.program.ScrewdriverProgramImpl;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeView;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.simpsons.installation.ProgramList;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import java.util.ArrayList;
import java.util.Optional;

public class ProgramViewService {
    private final ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution;

    public ProgramViewService(ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution) {
        this.screwdrivingProgramNodeContribution = screwdrivingProgramNodeContribution;
    }

    public void updateView() {
        ScrewdrivingProgramNodeView view = this.screwdrivingProgramNodeContribution.getView();
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.screwdrivingProgramNodeContribution.getCapabilitiesDefinition();
        boolean bitwiseSelection = this.screwdrivingProgramNodeContribution.isBitwiseSelection();
        if (bitwiseSelection) {
            String selectedProgramString = this.screwdrivingProgramNodeContribution.getBitwiseProgramSelectionFromModel();
            ScrewdriverProgram selectedProgram = null;
            ArrayList<ScrewdriverProgram> selectablePrograms = new ArrayList<ScrewdriverProgram>();
            if (capabilitiesDefinition.isPresent()) {
                ProgramList programList = capabilitiesDefinition.get().getProgramList();
                selectedProgram = programList.getPrograms().stream().filter(screwdriverProgram -> screwdriverProgram.getId().equals(selectedProgramString)).findFirst().orElse(null);
                selectablePrograms = new ArrayList<ScrewdriverProgram>(programList.getPrograms());
            }
            selectedProgram = this.handleMissingProgram(selectedProgramString, selectedProgram);
            view.updateBitwiseProgramSelection(selectablePrograms, selectedProgram);
        } else {
            String textProgramSelectionFromModel = this.screwdrivingProgramNodeContribution.getTextProgramSelectionFromModel();
            int program = Integer.parseInt(textProgramSelectionFromModel);
            view.updateIntegerProgramSelection(program);
        }
        view.updateMoveNodeSelection(this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyMoveNodeSelected(), false));
        view.updateMachineErrorHandlerSelection(this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyMachineErrorNodeSelected(), false), capabilitiesDefinition.isPresent() && capabilitiesDefinition.get().hasMachineErrorHandlerCapability());
        view.updateDirectionField(this.screwdrivingProgramNodeContribution.isTightening());
        boolean showWarning = false;
        String warningText = "";
        if (capabilitiesDefinition.isPresent()) {
            CapabilitiesDefinition definition = capabilitiesDefinition.get();
            if (!definition.getCapability(Capability.CapabilityType.START_DRIVE_SCREW).isPresent() || this.screwdrivingProgramNodeContribution.tcpMissingAndRequired(definition)) {
                showWarning = true;
                warningText = this.screwdrivingProgramNodeContribution.getTextResource().startIoTcpWarning();
            } else if (!this.isInstallationWelldefined()) {
                showWarning = true;
                warningText = this.screwdrivingProgramNodeContribution.getTextResource().missingSimpsonsWarning();
            }
        } else {
            showWarning = true;
            warningText = this.screwdrivingProgramNodeContribution.getTextResource().missingSimpsonsWarning();
        }
        view.setProgramSelectionEnabled(capabilitiesDefinition.isPresent() && capabilitiesDefinition.get().getCapability(Capability.CapabilityType.PROGRAM_SELECTION).isPresent());
        view.setDirectionEnabled(capabilitiesDefinition.isPresent() && capabilitiesDefinition.get().isSupportOperationType());
        view.updateProgramSelectionArea(bitwiseSelection);
        view.updateDirectionArea();
        ScrewdrivingInstallationNodeContribution installationNode = this.screwdrivingProgramNodeContribution.getScrewdrivingInstallationNode();
        view.updateTitleAndLogo(installationNode.getTitle(), installationNode.getLogo());
        view.updateWarning(showWarning, warningText);
        view.updateHandlerButton(this.screwdrivingProgramNodeContribution.allowMoreHandlers());
    }

    private ScrewdriverProgram handleMissingProgram(String selectedProgramString, ScrewdriverProgram selected) {
        ScrewdriverProgram selectedProgram = null;
        if (selected == null) {
            String savedProgramName = this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyProgramSelectionName(), (String)null);
            if (savedProgramName != null) {
                selectedProgram = new ScrewdriverProgramImpl(selectedProgramString, savedProgramName);
            }
        } else {
            selectedProgram = selected;
        }
        return selectedProgram;
    }

    private boolean isInstallationWelldefined() {
        return this.screwdrivingProgramNodeContribution.getScrewdrivingInstallationNode().isDefined();
    }
}

