/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.move.Positional;
import com.ur.polyscope.screwdriving.handlers.HandlerNodeType;
import com.ur.polyscope.screwdriving.handlers.HandlerType;
import com.ur.polyscope.screwdriving.handlers.MachineErrorHandlerType;
import com.ur.polyscope.screwdriving.handlers.ScrewdrivingHandlersNodeService;
import com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeContribution;
import com.ur.polyscope.screwdriving.internal.ProgramNodeContext;
import com.ur.polyscope.screwdriving.internal.ScrewdrivingProgramContext;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.program.DoubleValidator;
import com.ur.polyscope.screwdriving.program.DynamicOperationParameters;
import com.ur.polyscope.screwdriving.program.MachineErrorHandlerService;
import com.ur.polyscope.screwdriving.program.PositionalFinder;
import com.ur.polyscope.screwdriving.program.ProgramValidationService;
import com.ur.polyscope.screwdriving.program.ProgramViewService;
import com.ur.polyscope.screwdriving.program.Screwdriving;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeView;
import com.ur.polyscope.screwdriving.program.ScriptGenerationContext;
import com.ur.polyscope.screwdriving.program.ScriptGenerationContextImpl;
import com.ur.polyscope.screwdriving.program.ScriptGenerationService;
import com.ur.polyscope.screwdriving.program.SpeedMode;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.screwdriving.util.ExpressionKeyboard;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionLoadCompleteContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionRemovedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionRemovedListener;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.menu.ProgramMenuCategory;
import com.ur.polyscope.urcaps.userinteraction.keyboard.KeyboardExpressionInput;
import com.ur.swing.units.Units;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverParameters;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.variable.GlobalVariable;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.urcap.api.domain.variable.VariableFactory;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public class ScrewdrivingProgramNodeContribution
extends AbstractCustomProgramNodeContribution
implements Screwdriving,
ProgramMenuCategory,
Positional,
ContributionRemovedListener {
    private static final String KEY_BITWISE_PROGRAM_SELECTION = "bitwiseProgram";
    private static final String KEY_PROGRAM_SELECTION_NAME = "programName";
    private static final String KEY_TEXT_PROGRAM_SELECTION = "textProgram";
    private static final String KEY_MOVE_NODE_SELECTED = "selectedMoveNode";
    private static final String KEY_MACHINE_ERROR_NODE_SELECTED = "selectedMachineErrorNode";
    private static final String KEY_FORCE_VALUE = "forceValue";
    private static final String KEY_SPEED_VALUE_FORCE = "speedValueForce";
    private static final String KEY_SPEED_VALUE_SPEED = "speedValueSpeed";
    private static final String KEY_SPEED_VALUE_EXPRESSION = "speedValueExpression";
    private static final String KEY_ACCELERATION_VALUE = "accelerationValue";
    private static final String KEY_FOLLOW_SCREW_MODE = "followScrewmode";
    private static final String KEY_FOLLOW_SCREW_ENABLED = "followScrewEnabled";
    private static final String KEY_FORCE_EXPRESSION = "forceExpression";
    private static final String KEY_FORCE_EXPRESSION_STRING_VALUE = "forceExpressionStringValue";
    private static final String KEY_NAME = "name";
    private static final String SCREWDRIVING_NAME = "SD";
    private static final String KEY_CONTINUE_SCREWDRIVING_VARIABLE = "continueScrewDrivingVariable";
    private static final String KEY_MOVE_THREAD_VARIABLE = "moveThreadVariable";
    private static final String KEY_MOVE_THREAD_ID_VARIABLE = "moveThreadIDVariable";
    private static final String KEY_TIME_VARIABLE = "timeVariable";
    private static final String KEY_SCREW_POSITION_VARIABLE = "screwPositionVariable";
    private static final String KEY_SCREW_DISTANCE_VARIABLE = "screwDistanceVariable";
    protected static final String KEY_IS_TIGHTENING = "isTightening";
    private static final int MAXIMUM_NUMBER_OF_HANDLERS = 4;
    public static final Double MAX_FORCE = 125.0;
    public static final Double MAX_FORCE_IMPERIAL = 28.1;
    private static final Double MAX_ACCELERATION = 1200.0;
    private static final Double MAX_ACCELERATION_IMPERIAL = 47.24;
    private static final Double MAX_SPEED = 1500.0;
    private static final Double MAX_SPEED_IMPERIAL = 59.06;
    private static final Logger LOG = LogFactory.createLogger(ScrewdrivingProgramNodeContribution.class);
    private static ExpressionKeyboard expressionKeyboard;
    private final ProgramAPI programAPI;
    private final ScrewdrivingProgramNodeView view;
    private final DataModel dataModel;
    private final UndoRedoManager undoRedoManager;
    private final TextResource textResource;
    private final KeyboardInputFactory keyboardFactory;
    private ScriptGenerationContext scriptGenerationContext;
    private final Localization localization;
    private final ScrewdrivingProgramContext screwdrivingProgramContext;
    private boolean isActive;
    private final MachineErrorHandlerService machineErrorHandlerService;
    private final ProgramViewService programViewService;

    ScrewdrivingProgramNodeContribution(ProgramAPIProvider programAPIProvider, ScrewdrivingProgramNodeView screwdrivingProgramNodeView, DataModel dataModel, TextResource textResource, ScrewdrivingProgramContext screwdrivingProgramContext) {
        this.programAPI = programAPIProvider.getProgramAPI();
        this.view = screwdrivingProgramNodeView;
        this.dataModel = dataModel;
        this.undoRedoManager = this.programAPI.getUndoRedoManager();
        this.textResource = textResource;
        this.keyboardFactory = programAPIProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.localization = programAPIProvider.getSystemAPI().getSystemSettings().getLocalization();
        this.screwdrivingProgramContext = screwdrivingProgramContext;
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        root.setChildSequenceLocked(true);
        this.programViewService = new ProgramViewService(this);
        this.machineErrorHandlerService = new MachineErrorHandlerService(this, this.programViewService);
    }

    @Inject
    public static void setExpressionKeyboard(ExpressionKeyboard expressionKeyboard) {
        ScrewdrivingProgramNodeContribution.expressionKeyboard = expressionKeyboard;
    }

    public boolean isUndefined() {
        return !this.dataModel.get(KEY_MOVE_NODE_SELECTED, false);
    }

    public JointPositionVector getActualJointPositionVector() {
        Positional positional = this.getPositional();
        return positional == null ? null : positional.getActualJointPositionVector();
    }

    public PositionNodeType getPositionNodeType() {
        Positional positional = this.getPositional();
        return positional == null ? null : positional.getPositionNodeType();
    }

    private Positional getPositional() {
        Optional<TreeNode> moveNodeTreeNode;
        if (this.dataModel.get(KEY_MOVE_NODE_SELECTED, false) && (moveNodeTreeNode = this.getMoveNodeTreeNode()).isPresent()) {
            TreeNode treeNode = moveNodeTreeNode.get();
            TCP tcp = null;
            Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
            if (capabilitiesDefinition.isPresent()) {
                tcp = capabilitiesDefinition.get().getTcp();
            }
            PositionalFinder positionalFinder = new PositionalFinder((MoveNode)treeNode.getProgramNode(), tcp);
            treeNode.traverse((ProgramNodeVisitor)positionalFinder);
            return positionalFinder.getFirstPositional();
        }
        return null;
    }

    private void addSuccessHandler() {
        this.undoRedoManager.recordChanges(() -> {
            try {
                TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
                URCapProgramNode successHandler = this.programAPI.getProgramModel().getProgramNodeFactory().createURCapProgramNode(ScrewdrivingHandlersNodeService.class);
                root.addChild((ProgramNode)successHandler);
                HandlerNodeType asHandler = (HandlerNodeType)successHandler.getAs(HandlerNodeType.class);
                asHandler.setSuccessHandlerOnly();
                ((AbstractCustomProgramNodeContribution)((Object)asHandler)).setParentContribution(this);
            }
            catch (TreeStructureException e) {
                LOG.error("Unable to insert Success Handler", (Throwable)e);
            }
        });
    }

    private void initializeGlobalVariables() {
        this.undoRedoManager.recordChanges(() -> {
            try {
                VariableFactory variableFactory = this.programAPI.getVariableModel().getVariableFactory();
                GlobalVariable screwdriverNameVariable = variableFactory.createGlobalVariable("SD_1");
                this.dataModel.set(KEY_NAME, (Variable)screwdriverNameVariable);
                this.dataModel.set(KEY_MOVE_THREAD_VARIABLE, (Variable)variableFactory.createGlobalVariable(screwdriverNameVariable.getDisplayName() + "_td"));
                this.dataModel.set(KEY_MOVE_THREAD_ID_VARIABLE, this.createNonInstallationVariable(screwdriverNameVariable.getDisplayName() + "_tID", "-1"));
                this.dataModel.set(KEY_TIME_VARIABLE, (Variable)variableFactory.createGlobalVariable(screwdriverNameVariable.getDisplayName() + "_time"));
                this.dataModel.set(KEY_SCREW_POSITION_VARIABLE, (Variable)variableFactory.createGlobalVariable(screwdriverNameVariable.getDisplayName() + "_pos"));
                this.dataModel.set(KEY_SCREW_DISTANCE_VARIABLE, (Variable)variableFactory.createGlobalVariable(screwdriverNameVariable.getDisplayName() + "_dist"));
                this.dataModel.set(KEY_CONTINUE_SCREWDRIVING_VARIABLE, this.createNonInstallationVariable(screwdriverNameVariable.getDisplayName() + "_run", "1"));
            }
            catch (VariableException e) {
                Log.error((String)"Unable to create variables", (Throwable)e);
            }
        });
    }

    private Variable createNonInstallationVariable(String name, String value) {
        try {
            Expression expr = this.programAPI.getValueFactoryProvider().createExpressionBuilder().append(value).build();
            return this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(name, expr);
        }
        catch (VariableException e) {
            Log.error((String)"Unable to create non installation variable", (Throwable)e);
        }
        catch (InvalidExpressionException e) {
            Log.error((String)"Unable to create initial variable expression", (Throwable)e);
        }
        return null;
    }

    @Override
    protected List<AbstractCustomProgramNodeContribution> getProgramNodeContributionChildren() {
        ArrayList<AbstractCustomProgramNodeContribution> result = new ArrayList<AbstractCustomProgramNodeContribution>();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        for (TreeNode treeNode : rootTreeNode.getChildren()) {
            ProgramNode programNode = treeNode.getProgramNode();
            if (!(programNode instanceof URCapProgramNode)) continue;
            if (((URCapProgramNode)programNode).canGetAs(HandlerNodeType.class)) {
                HandlerNodeType hnt = (HandlerNodeType)((URCapProgramNode)programNode).getAs(HandlerNodeType.class);
                result.add((AbstractCustomProgramNodeContribution)((Object)hnt));
                continue;
            }
            if (!((URCapProgramNode)programNode).canGetAs(MachineErrorHandlerType.class)) continue;
            MachineErrorHandlerType meht = (MachineErrorHandlerType)((URCapProgramNode)programNode).getAs(MachineErrorHandlerType.class);
            result.add((AbstractCustomProgramNodeContribution)((Object)meht));
        }
        return result;
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        super.onInserted(contributionInsertedContext);
        this.initializeGlobalVariables();
        if (!contributionInsertedContext.isCloning() && !this.dataModel.isSet(KEY_IS_TIGHTENING)) {
            this.addSuccessHandler();
            this.dataModel.set(KEY_IS_TIGHTENING, true);
        }
        this.registerDynamicOperationParameters();
        this.isActive = true;
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        root.setChildSequenceLocked(true);
    }

    public String getNodeName() {
        Variable nameVariable = this.dataModel.get(KEY_NAME, (Variable)null);
        if (nameVariable != null) {
            return nameVariable.getDisplayName();
        }
        return "";
    }

    @Override
    public void loadComplete(ContributionLoadCompleteContext contributionLoadCompleteContext) {
        super.loadComplete(contributionLoadCompleteContext);
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        root.setChildSequenceLocked(true);
        this.registerDynamicOperationParameters();
        this.isActive = true;
    }

    public void openView() {
        this.programViewService.updateView();
        this.updateFollowScrewView();
    }

    public boolean tcpMissingAndRequired(CapabilitiesDefinition definition) {
        return definition.requireTCP() && definition.getTcp() == null;
    }

    public boolean isBitwiseSelection() {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        return capabilitiesDefinition.map(CapabilitiesDefinition::isBitwiseProgramSelection).orElse(true);
    }

    private void updateFollowScrewView() {
        boolean followScrewEnabled = this.isFollowScrewEnabledValue();
        this.view.updateForce(this.getForceValue(), this.getForceUnit(), followScrewEnabled);
        SpeedMode speedMode = SpeedMode.fromFollowTheScrewMode(this.getFollowScrewMode());
        this.view.updateSpeed(this.getSpeedValue(speedMode), this.getSpeedUnit(), followScrewEnabled);
        this.view.updateAccelerationValue(this.getAccelerationValue(), this.getAccelerationUnit(), followScrewEnabled);
        this.view.updateFollowScrewMode(this.getFollowScrewMode());
        this.view.updateExpressionValue(this.getUntilExpression(), followScrewEnabled);
        this.view.updateFollowScrewEnabled(followScrewEnabled);
    }

    @Override
    public ScriptGenerationContext getScriptGenerationContext() {
        return this.scriptGenerationContext;
    }

    void setBitWiseProgramSelection(ScrewdriverProgram screwdriverProgram) {
        this.undoRedoManager.recordChanges(() -> {
            this.dataModel.set(KEY_BITWISE_PROGRAM_SELECTION, screwdriverProgram.getId());
            this.dataModel.set(KEY_PROGRAM_SELECTION_NAME, screwdriverProgram.getDisplayName());
        });
        this.programViewService.updateView();
    }

    private void setTextProgramSelection(int program) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set(KEY_TEXT_PROGRAM_SELECTION, program));
        this.programViewService.updateView();
    }

    @Override
    public ScrewdriverParameters getScrewdriverOperationParameters() {
        ProgramNodeContext context = this.screwdrivingProgramContext.getContextForProgramNode(this.getNodeName());
        return context.getOperationParameters();
    }

    void toggleMoveNode(boolean selected) {
        this.undoRedoManager.recordChanges(() -> {
            if (selected) {
                this.addMoveNode();
            } else {
                this.removeMoveNode();
            }
        });
    }

    private void addMoveNode() {
        this.undoRedoManager.recordChanges(() -> {
            this.dataModel.set(KEY_MOVE_NODE_SELECTED, true);
            ProgramModel programModel = this.programAPI.getProgramModel();
            TreeNode rootNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
            MoveNode moveNode = programModel.getProgramNodeFactory().createMoveNode();
            moveNode.setConfig((MoveNodeConfig)moveNode.getConfigBuilders().createMoveLConfigBuilder().build());
            List children = rootNode.getChildren();
            TreeNode firstChild = null;
            if (!children.isEmpty()) {
                firstChild = (TreeNode)children.get(0);
            }
            try {
                if (firstChild == null) {
                    rootNode.addChild((ProgramNode)moveNode);
                } else {
                    ProgramNode firstChildProgramNode = firstChild.getProgramNode();
                    if (firstChildProgramNode instanceof URCapProgramNode && ((URCapProgramNode)firstChildProgramNode).canGetAs(MachineErrorHandlerType.class)) {
                        rootNode.insertChildAfter(firstChild, (ProgramNode)moveNode);
                    } else {
                        rootNode.insertChildBefore(firstChild, (ProgramNode)moveNode);
                    }
                }
            }
            catch (TreeStructureException e) {
                LOG.error("Unable to insert Move node", (Throwable)e);
            }
        });
    }

    private void removeMoveNode() {
        this.undoRedoManager.recordChanges(() -> {
            this.dataModel.remove(KEY_MOVE_NODE_SELECTED);
            Optional<TreeNode> moveNode = this.getMoveNodeTreeNode();
            if (moveNode.isPresent()) {
                try {
                    TreeNode rootNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
                    rootNode.removeChild(moveNode.get());
                }
                catch (TreeStructureException e) {
                    LOG.error("Unable to remove MoveNode", (Throwable)e);
                }
            }
        });
    }

    private Optional<TreeNode> getMoveNodeTreeNode() {
        TreeNode rootNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        return rootNode.getChildren().stream().filter(n -> n.getProgramNode() instanceof MoveNode).findFirst();
    }

    void toggleMachineErrorNode(boolean selected) {
        this.undoRedoManager.recordChanges(() -> {
            if (selected) {
                this.machineErrorHandlerService.addMachineErrorHandlerNode();
            } else {
                this.machineErrorHandlerService.removeMachineErrorHandlerNode();
            }
        });
    }

    public String getBitwiseProgramSelectionFromModel() {
        return this.dataModel.get(KEY_BITWISE_PROGRAM_SELECTION, "-1");
    }

    public String getTextProgramSelectionFromModel() {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        if (!(capabilitiesDefinition.isPresent() && capabilitiesDefinition.get().getCapability(Capability.CapabilityType.PROGRAM_SELECTION).isPresent() || this.dataModel.get(KEY_TEXT_PROGRAM_SELECTION, "").isEmpty())) {
            return "-1";
        }
        return this.dataModel.get(KEY_TEXT_PROGRAM_SELECTION, "-1");
    }

    private void setForceValue(double value) {
        Force.Unit unit = this.getForceUnit();
        SimpleValueFactory valueFactory = this.programAPI.getValueFactoryProvider().getSimpleValueFactory();
        this.undoRedoManager.recordChanges(() -> this.dataModel.set(KEY_FORCE_VALUE, valueFactory.createForce(value, unit)));
        this.updateFollowScrewView();
    }

    public Force.Unit getForceUnit() {
        UnitType unitType = this.localization.getUnitType();
        return unitType == UnitType.METRIC ? Force.Unit.N : Force.Unit.LBF;
    }

    private Speed.Unit getSpeedUnit() {
        UnitType unitType = this.localization.getUnitType();
        return unitType == UnitType.METRIC ? Speed.Unit.MM_S : Speed.Unit.IN_S;
    }

    private Acceleration.Unit getAccelerationUnit() {
        UnitType unitType = this.localization.getUnitType();
        return unitType == UnitType.METRIC ? Acceleration.Unit.MM_S2 : Acceleration.Unit.IN_S2;
    }

    private void setSpeedValue(double value, SpeedMode speedMode) {
        Speed.Unit speedUnit = this.getSpeedUnit();
        SimpleValueFactory valueFactory = this.programAPI.getValueFactoryProvider().getSimpleValueFactory();
        this.undoRedoManager.recordChanges(() -> this.dataModel.set(speedMode.getKeyValue(), valueFactory.createSpeed(value, speedUnit)));
        this.updateFollowScrewView();
    }

    private void setAccelerationValue(double value) {
        Acceleration.Unit accelerationUnit = this.getAccelerationUnit();
        SimpleValueFactory valueFactory = this.programAPI.getValueFactoryProvider().getSimpleValueFactory();
        this.undoRedoManager.recordChanges(() -> this.dataModel.set(KEY_ACCELERATION_VALUE, valueFactory.createAcceleration(value, accelerationUnit)));
        this.updateFollowScrewView();
    }

    void setFollowScrewMode(FollowScrewMode mode) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set(KEY_FOLLOW_SCREW_MODE, mode.name()));
        this.updateFollowScrewView();
    }

    private void setFollowScrewEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set(KEY_FOLLOW_SCREW_ENABLED, enabled));
        this.updateFollowScrewView();
    }

    public Force getForceValue() {
        return this.dataModel.get(KEY_FORCE_VALUE, (Force)null);
    }

    public Speed getSpeedValue(SpeedMode speedMode) {
        return this.dataModel.get(speedMode.getKeyValue(), (Speed)null);
    }

    public Acceleration getAccelerationValue() {
        return this.dataModel.get(KEY_ACCELERATION_VALUE, (Acceleration)null);
    }

    public FollowScrewMode getFollowScrewMode() {
        String s = this.dataModel.get(KEY_FOLLOW_SCREW_MODE, "FORCE");
        return FollowScrewMode.valueOf(s);
    }

    public boolean isFollowScrewEnabledValue() {
        return this.dataModel.get(KEY_FOLLOW_SCREW_ENABLED, false);
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.screwdriving();
    }

    public boolean isDefined() {
        ProgramValidationService programValidationService = new ProgramValidationService(this, this.screwdrivingProgramContext);
        return programValidationService.isProgramProperlyDefined();
    }

    @Override
    public boolean hasSuccessHandler() {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        for (TreeNode child : root.getChildren()) {
            if (!(child.getProgramNode() instanceof URCapProgramNode) || !((URCapProgramNode)child.getProgramNode()).canGetAs(HandlerNodeType.class)) continue;
            HandlerNodeType handler = (HandlerNodeType)((URCapProgramNode)child.getProgramNode()).getAs(HandlerNodeType.class);
            HandlerType handlerType = handler.getHandlerType();
            if (!handler.isSuccessHandlerOnly() && (handlerType == null || !handlerType.isSuccessState())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<HandlerType> getDefinedHandlerTypes() {
        ArrayList<HandlerType> result = new ArrayList<HandlerType>();
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        for (TreeNode child : root.getChildren()) {
            HandlerNodeType handler;
            if (!(child.getProgramNode() instanceof URCapProgramNode) || !((URCapProgramNode)child.getProgramNode()).canGetAs(HandlerNodeType.class) || (handler = (HandlerNodeType)((URCapProgramNode)child.getProgramNode()).getAs(HandlerNodeType.class)).getHandlerType() == null) continue;
            result.add(handler.getHandlerType());
        }
        return result;
    }

    private int getTotalNumberOfHandlers() {
        int result = 0;
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        for (TreeNode child : root.getChildren()) {
            if (!(child.getProgramNode() instanceof URCapProgramNode) || !((URCapProgramNode)child.getProgramNode()).canGetAs(HandlerNodeType.class)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean allowMoreHandlers() {
        return this.getTotalNumberOfHandlers() < 4;
    }

    @Override
    public void removeHandler(TreeNode handlerNode) {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        boolean isMachineErrorHandler = ((URCapProgramNode)handlerNode.getProgramNode()).canGetAs(MachineErrorHandlerType.class);
        if (isMachineErrorHandler) {
            this.machineErrorHandlerService.removeMachineErrorHandlerNode();
        } else {
            this.undoRedoManager.recordChanges(() -> {
                try {
                    root.removeChild(handlerNode);
                }
                catch (TreeStructureException e) {
                    LOG.error("Unable to remove handler", (Throwable)e);
                }
            });
        }
    }

    public void generateScript(ScriptWriter scriptWriter) {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        if (capabilitiesDefinition.isPresent()) {
            ScrewdriverParameters screwdriverOperationParameters = this.getScrewdriverOperationParameters();
            CapabilitiesDefinition definition = capabilitiesDefinition.get();
            this.scriptGenerationContext = new ScriptGenerationContextImpl(definition, screwdriverOperationParameters, this);
            ScriptGenerationService scriptGenerationService = new ScriptGenerationService(this.scriptGenerationContext, this, this.screwdrivingProgramContext, this.machineErrorHandlerService);
            scriptGenerationService.generateScript(scriptWriter);
            this.scriptGenerationContext = null;
        }
    }

    @Override
    public String getFunctionName(Capability.CapabilityType capabilityType) {
        return this.getScrewdrivingInstallationNode().getFunctionNameForCapability(this.getNodeName(), capabilityType);
    }

    public ProgramMenuCategory.ProgramMenu getProgramMenu() {
        return ProgramMenuCategory.ProgramMenu.TEMPLATES;
    }

    @Override
    public void addHandler() {
        ProgramNodeFactory programNodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.undoRedoManager.recordChanges(() -> {
            URCapProgramNode nodeToAdd = programNodeFactory.createURCapProgramNode(ScrewdrivingHandlersNodeService.class);
            try {
                rootTreeNode.addChild((ProgramNode)nodeToAdd);
                HandlerNodeType handlerNodeType = (HandlerNodeType)nodeToAdd.getAs(HandlerNodeType.class);
                ((AbstractCustomProgramNodeContribution)((Object)handlerNodeType)).setParentContribution(this);
            }
            catch (TreeStructureException e) {
                Log.error((String)"Unable to insert Action After node", (Throwable)e);
            }
        });
        this.programViewService.updateView();
    }

    @Override
    public boolean isFollowScrewEnabled() {
        return this.isFollowScrewEnabledValue();
    }

    void setIsTightening(boolean tightening) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set(KEY_IS_TIGHTENING, tightening));
        this.programViewService.updateView();
    }

    public void registerDynamicOperationParameters() {
        this.screwdrivingProgramContext.setContextForProgramNode(this.getNodeName(), new DynamicOperationParameters(this));
    }

    public Optional<CapabilitiesDefinition> getCapabilitiesDefinition() {
        return this.getScrewdrivingInstallationNode().getCapabilitiesDefinition();
    }

    public boolean isTightening() {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        if (!(this.dataModel.get(KEY_IS_TIGHTENING, true) || capabilitiesDefinition.isPresent() && capabilitiesDefinition.get().isSupportOperationType())) {
            return true;
        }
        return this.dataModel.get(KEY_IS_TIGHTENING, true);
    }

    public ScrewdrivingInstallationNodeContribution getScrewdrivingInstallationNode() {
        return (ScrewdrivingInstallationNodeContribution)this.programAPI.getInstallationNode(ScrewdrivingInstallationNodeContribution.class);
    }

    KeyboardNumberInput<Integer> getProgramSelectionKeyboard() {
        KeyboardNumberInput keyboard = this.keyboardFactory.createPositiveIntegerKeypadInput();
        String textProgramSelectionFromModel = this.getTextProgramSelectionFromModel();
        int program = Integer.parseInt(textProgramSelectionFromModel);
        if (program > 0) {
            keyboard.setInitialValue((Object)program);
        }
        keyboard.setErrorValidator((InputValidator)new InputValidator<Integer>(){

            public boolean isValid(Integer integer) {
                return integer != null && integer < Integer.MAX_VALUE;
            }

            public String getMessage(Integer integer) {
                return null;
            }
        });
        return keyboard;
    }

    KeyboardInputCallback<Integer> getProgramEnteredCallback() {
        return new KeyboardInputCallback<Integer>(){

            public void onOk(Integer integer) {
                ScrewdrivingProgramNodeContribution.this.setTextProgramSelection(integer);
            }
        };
    }

    private KeyboardNumberInput<Double> getDoubleKeyboard(double initialVal) {
        KeyboardNumberInput keyboard = this.keyboardFactory.createPositiveDoubleKeypadInput();
        if (initialVal > 0.0) {
            keyboard.setInitialValue((Object)initialVal);
        }
        return keyboard;
    }

    KeyboardNumberInput<Double> getForceSelectionKeyboard() {
        Force forceValue = this.getForceValue();
        KeyboardNumberInput<Double> keyboard = this.getDoubleKeyboard(forceValue != null ? forceValue.getAs(this.getForceUnit()) : 0.0);
        keyboard.setErrorValidator((InputValidator)new DoubleValidator(Units.getText().unitN(), MAX_FORCE, MAX_FORCE_IMPERIAL, this));
        return keyboard;
    }

    KeyboardInputCallback<Double> getForceEnteredCallback() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double d) {
                ScrewdrivingProgramNodeContribution.this.setForceValue(d);
            }
        };
    }

    KeyboardNumberInput<Double> getSpeedSelectionKeyboard() {
        Speed speed = this.getSpeedValue(SpeedMode.fromFollowTheScrewMode(this.getFollowScrewMode()));
        KeyboardNumberInput<Double> keyboard = this.getDoubleKeyboard(speed != null ? speed.getAs(this.getSpeedUnit()) : 0.0);
        keyboard.setErrorValidator((InputValidator)new DoubleValidator(Units.getText().unitMmS(), MAX_SPEED, MAX_SPEED_IMPERIAL, this));
        return keyboard;
    }

    KeyboardInputCallback<Double> getSpeedEnteredCallback() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double d) {
                ScrewdrivingProgramNodeContribution.this.setSpeedValue(d, SpeedMode.fromFollowTheScrewMode(ScrewdrivingProgramNodeContribution.this.getFollowScrewMode()));
            }
        };
    }

    KeyboardNumberInput<Double> getAccelerationSelectionKeyboard() {
        Acceleration acceleration = this.getAccelerationValue();
        KeyboardNumberInput<Double> keyboard = this.getDoubleKeyboard(acceleration != null ? acceleration.getAs(this.getAccelerationUnit()) : 0.0);
        keyboard.setErrorValidator((InputValidator)new DoubleValidator(Units.getText().unitMmS2(), MAX_ACCELERATION, MAX_ACCELERATION_IMPERIAL, this));
        return keyboard;
    }

    KeyboardInputCallback<Double> getAccelerationEnteredCallback() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double d) {
                ScrewdrivingProgramNodeContribution.this.setAccelerationValue(d);
            }
        };
    }

    KeyboardExpressionInput getUntilExpressionKeyboard() {
        String initialValue = this.getUntilExpression();
        return expressionKeyboard.getExpressionKeyboard(initialValue);
    }

    public String getUntilExpression() {
        String expression = this.getForceExpressionString();
        if (expression.isEmpty()) {
            expression = this.getForceExpressionScript();
        }
        return expression;
    }

    private String getForceExpressionScript() {
        return this.dataModel.get(KEY_FORCE_EXPRESSION, "");
    }

    private String getForceExpressionString() {
        return this.dataModel.get(KEY_FORCE_EXPRESSION_STRING_VALUE, "");
    }

    KeyboardInputCallback<Expression> getExpressionCallback() {
        return expressionKeyboard.getExpressionCallback(this.dataModel, KEY_FORCE_EXPRESSION, KEY_FORCE_EXPRESSION_STRING_VALUE, this.undoRedoManager);
    }

    void toggleFollowScrew(boolean selected) {
        this.setFollowScrewEnabled(selected);
    }

    public void onRemoved(ContributionRemovedContext contributionRemovedContext) {
        this.screwdrivingProgramContext.removeContextForProgramNode(this.getNodeName());
        this.isActive = false;
    }

    public static String getKeySpeedValueForce() {
        return KEY_SPEED_VALUE_FORCE;
    }

    public static String getKeySpeedValueSpeed() {
        return KEY_SPEED_VALUE_SPEED;
    }

    public static String getKeySpeedValueExpression() {
        return KEY_SPEED_VALUE_EXPRESSION;
    }

    public static String getKeyContinueScrewdrivingVariable() {
        return KEY_CONTINUE_SCREWDRIVING_VARIABLE;
    }

    public static String getKeyMoveThreadVariable() {
        return KEY_MOVE_THREAD_VARIABLE;
    }

    public static String getKeyMoveThreadIdVariable() {
        return KEY_MOVE_THREAD_ID_VARIABLE;
    }

    public static String getKeyMoveTimeVariable() {
        return KEY_TIME_VARIABLE;
    }

    public static String getKeyScrewPositionVariable() {
        return KEY_SCREW_POSITION_VARIABLE;
    }

    public static String getKeyScrewDistanceVariable() {
        return KEY_SCREW_DISTANCE_VARIABLE;
    }

    public static String getKeyMachineErrorNodeSelected() {
        return KEY_MACHINE_ERROR_NODE_SELECTED;
    }

    public static String getKeyProgramSelectionName() {
        return KEY_PROGRAM_SELECTION_NAME;
    }

    public static String getKeyMoveNodeSelected() {
        return KEY_MOVE_NODE_SELECTED;
    }

    public TextResource getTextResource() {
        return this.textResource;
    }

    public ProgramAPI getProgramAPI() {
        return this.programAPI;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public Localization getLocalization() {
        return this.localization;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public UndoRedoManager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    public ScrewdrivingProgramNodeView getView() {
        return this.view;
    }

    public static enum FollowScrewMode {
        FORCE,
        SPEED,
        EXPRESSION;

    }
}

