/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.screwdriving.internal.ImageResource;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.urcaps.userinteraction.keyboard.KeyboardExpressionInput;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.units.Units;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ScrewdrivingProgramNodeView
implements SwingProgramNodeView<ScrewdrivingProgramNodeContribution> {
    private static final String PROGRAM_DROPDOWN = ScrewdrivingProgramNodeView.class.getSimpleName() + ".programSelect";
    private static final String ADD_HANDLER = ScrewdrivingProgramNodeView.class.getSimpleName() + ".addHandler";
    private static final String FOLLOW_SCREW = ScrewdrivingProgramNodeView.class.getSimpleName() + ".followScrew";
    private static final String ADD_MACHINE_ERROR_HANDLER = ScrewdrivingProgramNodeView.class.getSimpleName() + ".addMachineErrorHandler";
    private static final String FORCE = "FORCE";
    private static final String SPEED = "SPEED";
    private static final String ACCELERATION = "ACCELERATION";
    private static final String EXPRESSION = "EXPRESSION";
    private static final int LEFT_ADJUSTMENT = 20;
    private static final int ROW_WIDTH = 680;
    private static final int ROW_HEIGHT = 40;
    private static final int COMBO_HEIGHT = 30;
    private JLabel selectedScrewdriverLabel;
    private JLabel selectedScrewdriverLogo;
    private JRadioButton tightenButton;
    private JRadioButton loosenButton;
    private JComboBox<ScrewdriverProgram> programSelectionDropDown;
    private JComboBox<FollowScrewItem> followScrewSelectionDropDown;
    private JTextField programSelectionTextField;
    private ProgramSelectionRenderingStrategy programSelectionRenderingStrategy;
    private final Dimension comboDimensions = new Dimension(170, 30);
    private final Dimension standardBoxDimensions = new Dimension(350, 105);
    private final Dimension handlersLinePanelDimensions = new Dimension(680, 40);
    private final TextResource textResource;
    private JCheckBox moveNodeSelection;
    private JCheckBox machineErrorHandlerSelection;
    private JCheckBox followScrewSelection;
    private JPanel handlerLineOneCards;
    private JPanel handlerLineTwoCards;
    private JTextField speedTextField;
    private JTextField forceSpeedTextField;
    private JTextField expressionSpeedTextField;
    private JTextField forceTextField;
    private JTextField accelerationTextField;
    private JTextField expressionTextField;
    private JLabel warningLabel;
    private JButton addHandlerButton;
    private JLabel addUntilLabel;
    private JLabel programSelectionLabel;
    private JLabel directionLabel;
    private boolean programSelectionEnabled;
    private boolean directionEnabled;

    ScrewdrivingProgramNodeView(TextResource textResource) {
        this.textResource = textResource;
    }

    private static JPanel createBoxLayoutPanel(Dimension dimension, int axis) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        ScrewdrivingProgramNodeView.setDimension(panel, dimension);
        return panel;
    }

    public void buildUI(JPanel jPanel, ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider) {
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setAlignmentX(0.0f);
        JPanel topSection = this.createTopPanel(contributionProvider);
        JPanel processPanel = this.createProcessPanel(contributionProvider);
        JPanel addHandlerPanel = this.createAddHandlerPanel(contributionProvider);
        jPanel.add(topSection);
        jPanel.add(this.createHorizontalSeparator());
        jPanel.add(processPanel);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(addHandlerPanel);
    }

    private Box createHorizontalSeparator() {
        Box lineDivider = Box.createHorizontalBox();
        lineDivider.setBorder(new LineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR));
        lineDivider.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(lineDivider, new Dimension(680, 2));
        return lineDivider;
    }

    private JPanel createTopPanel(ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setAlignmentX(0.0f);
        int height = 300;
        ScrewdrivingProgramNodeView.setDimension(wrapper, new Dimension(705, height));
        JPanel right = this.createTopRightPanel(height);
        int leftWidth = 575;
        JPanel left = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(leftWidth, height), 1);
        left.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.selectedScrewdriverLabel = new JLabel();
        Dimension textRowDimension = new Dimension(leftWidth - 20, 30);
        ScrewdrivingProgramNodeView.setDimension(this.selectedScrewdriverLabel, textRowDimension);
        this.warningLabel = new JLabel(HTML.html((String)HTML.p((String)this.textResource.startIoTcpWarning())), ImageResource.warning(), 10);
        ScrewdrivingProgramNodeView.setDimension(this.warningLabel, textRowDimension);
        this.warningLabel.setVisible(false);
        JPanel directionPanel = this.createDirectionPanel(contributionProvider);
        JPanel programSelectionArea = this.createProgramSelectionPanel(contributionProvider);
        JPanel checkBoxPanel = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(leftWidth - 20, 70), 1);
        this.moveNodeSelection = new JCheckBox(this.textResource.enableStartingPoint());
        this.moveNodeSelection.addActionListener(e -> ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).toggleMoveNode(this.moveNodeSelection.isSelected()));
        this.machineErrorHandlerSelection = new JCheckBox(this.textResource.enableMachineErrorHandler());
        this.machineErrorHandlerSelection.setName(ADD_MACHINE_ERROR_HANDLER);
        this.machineErrorHandlerSelection.addActionListener(e -> ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).toggleMachineErrorNode(this.machineErrorHandlerSelection.isSelected()));
        checkBoxPanel.add(this.moveNodeSelection);
        checkBoxPanel.add(this.machineErrorHandlerSelection);
        left.add(this.selectedScrewdriverLabel);
        left.add(this.warningLabel);
        left.add(directionPanel);
        left.add(programSelectionArea);
        left.add(checkBoxPanel);
        wrapper.add((Component)left, "West");
        wrapper.add((Component)right, "East");
        return wrapper;
    }

    private JPanel createTopRightPanel(int height) {
        JPanel right = new JPanel(new BorderLayout());
        ScrewdrivingProgramNodeView.setDimension(right, new Dimension(100, height));
        this.selectedScrewdriverLogo = new JLabel();
        ScrewdrivingProgramNodeView.setDimension(this.selectedScrewdriverLogo, new Dimension(100, 100));
        right.add((Component)this.selectedScrewdriverLogo, "North");
        return right;
    }

    private JPanel createDirectionPanel(ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider) {
        this.setDirectionEnabled(false);
        JPanel directionPanel = ScrewdrivingProgramNodeView.createBoxLayoutPanel(this.standardBoxDimensions, 3);
        this.directionLabel = new JLabel(HTML.html((String)HTML.h3((String)this.textResource.direction())));
        ScrewdrivingProgramNodeView.setDimension(this.directionLabel, new Dimension(350, 30));
        this.tightenButton = new JRadioButton(this.textResource.tighten());
        this.tightenButton.addActionListener(e -> ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).setIsTightening(true));
        this.loosenButton = new JRadioButton(this.textResource.loosen());
        this.loosenButton.addActionListener(e -> ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).setIsTightening(false));
        ButtonGroup directionButtonGroup = new ButtonGroup();
        directionButtonGroup.add(this.tightenButton);
        directionButtonGroup.add(this.loosenButton);
        directionPanel.add(this.directionLabel);
        directionPanel.add(this.tightenButton);
        directionPanel.add(this.loosenButton);
        return directionPanel;
    }

    private JPanel createProgramSelectionPanel(final ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider) {
        this.setProgramSelectionEnabled(false);
        int width = 500;
        JPanel programSelectionArea = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(width, 70), 3);
        this.programSelectionLabel = new JLabel(HTML.html((String)HTML.h3((String)this.textResource.programSelectionText())));
        ScrewdrivingProgramNodeView.setDimension(this.programSelectionLabel, new Dimension(width, 30));
        this.programSelectionLabel.setAlignmentX(0.0f);
        programSelectionArea.add(this.programSelectionLabel);
        programSelectionArea.add(Box.createRigidArea(new Dimension(0, 7)));
        this.programSelectionDropDown = new JComboBox();
        ScrewdrivingProgramNodeView.setDimension(this.programSelectionDropDown, new Dimension(250, 30));
        this.programSelectionDropDown.setName(PROGRAM_DROPDOWN);
        this.programSelectionDropDown.addActionListener(actionEvent -> ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).setBitWiseProgramSelection((ScrewdriverProgram)this.programSelectionDropDown.getSelectedItem()));
        this.programSelectionRenderingStrategy = new ProgramSelectionRenderingStrategy();
        ComboBoxRenderer.bindRenderer(this.programSelectionDropDown, (RenderingStrategy)this.programSelectionRenderingStrategy);
        this.programSelectionDropDown.setAlignmentX(0.0f);
        programSelectionArea.add(this.programSelectionDropDown);
        this.programSelectionTextField = new JTextField();
        this.programSelectionTextField.setFocusable(false);
        this.programSelectionTextField.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(this.programSelectionTextField, new Dimension(width, 30));
        this.programSelectionTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ScrewdrivingProgramNodeView.this.isProgramSelectionEnabled()) {
                    KeyboardNumberInput<Integer> keyboard = ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getProgramSelectionKeyboard();
                    keyboard.show(ScrewdrivingProgramNodeView.this.programSelectionTextField, ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getProgramEnteredCallback());
                }
            }
        });
        this.programSelectionTextField.setVisible(false);
        programSelectionArea.add(this.programSelectionTextField);
        return programSelectionArea;
    }

    private JPanel createProcessPanel(ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider) {
        JPanel processPanel = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(680, 185), 3);
        processPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        JLabel processLabel = new JLabel(HTML.html((String)HTML.h2((String)this.textResource.handlersProcess())));
        processLabel.setAlignmentX(0.0f);
        processPanel.add(processLabel);
        this.followScrewSelection = new JCheckBox(this.textResource.followScrew());
        this.followScrewSelection.setName(FOLLOW_SCREW);
        this.followScrewSelection.addActionListener(actionEvent -> {
            boolean selected = this.followScrewSelection.isSelected();
            ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).toggleFollowScrew(selected);
        });
        this.followScrewSelectionDropDown = new JComboBox();
        this.followScrewSelectionDropDown.addActionListener(actionEvent -> {
            if (this.followScrewSelectionDropDown.isEnabled()) {
                ScrewdrivingProgramNodeContribution.FollowScrewMode followScrewMode = ((FollowScrewItem)this.followScrewSelectionDropDown.getSelectedItem()).getFollowScrewMode();
                ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).setFollowScrewMode(followScrewMode);
            }
        });
        FollowScrewItem[] modes = new FollowScrewItem[]{new FollowScrewItem(ScrewdrivingProgramNodeContribution.FollowScrewMode.FORCE, this.textResource.force()), new FollowScrewItem(ScrewdrivingProgramNodeContribution.FollowScrewMode.SPEED, this.textResource.speed()), new FollowScrewItem(ScrewdrivingProgramNodeContribution.FollowScrewMode.EXPRESSION, this.textResource.expression())};
        DefaultComboBoxModel<FollowScrewItem> model = new DefaultComboBoxModel<FollowScrewItem>(modes);
        this.followScrewSelectionDropDown.setModel(model);
        this.followScrewSelectionDropDown.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(this.followScrewSelectionDropDown, this.comboDimensions);
        JPanel handlerModeSelection = this.createHandlerLeftRightPanel(0, this.followScrewSelection, this.followScrewSelectionDropDown);
        JPanel handlerLineZeroCards = new JPanel(new CardLayout());
        handlerLineZeroCards.add((Component)handlerModeSelection, "");
        handlerLineZeroCards.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(handlerLineZeroCards, this.handlersLinePanelDimensions);
        this.forceSpeedTextField = new JTextField();
        this.forceSpeedTextField.setFocusable(false);
        this.speedTextField = new JTextField();
        this.speedTextField.setFocusable(false);
        this.expressionSpeedTextField = new JTextField();
        this.expressionSpeedTextField.setFocusable(false);
        this.forceTextField = new JTextField();
        this.forceTextField.setFocusable(false);
        this.accelerationTextField = new JTextField();
        this.accelerationTextField.setFocusable(false);
        this.expressionTextField = new JTextField();
        this.expressionTextField.setFocusable(false);
        this.handlerLineOneCards = new JPanel(new CardLayout());
        this.handlerLineOneCards.add((Component)this.createSpeedLine(contributionProvider, this.speedTextField, this.textResource.toolSpeed()), SPEED);
        this.handlerLineOneCards.add((Component)this.createForceLine(contributionProvider, this.forceTextField), FORCE);
        this.handlerLineOneCards.add((Component)this.createExpressionLine(contributionProvider, this.expressionTextField), EXPRESSION);
        this.handlerLineOneCards.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(this.handlerLineOneCards, this.handlersLinePanelDimensions);
        this.handlerLineTwoCards = new JPanel(new CardLayout());
        this.handlerLineTwoCards.add((Component)this.createSpeedLine(contributionProvider, this.forceSpeedTextField, this.textResource.speedLimit()), SPEED);
        this.handlerLineTwoCards.add((Component)this.createAccelerationLine(contributionProvider, this.accelerationTextField), ACCELERATION);
        this.handlerLineTwoCards.add((Component)this.createSpeedLine(contributionProvider, this.expressionSpeedTextField, this.textResource.speedLimit()), EXPRESSION);
        this.handlerLineTwoCards.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(this.handlerLineTwoCards, this.handlersLinePanelDimensions);
        processPanel.add(handlerLineZeroCards);
        processPanel.add(this.handlerLineOneCards);
        processPanel.add(this.handlerLineTwoCards);
        processPanel.add(Box.createVerticalGlue());
        return processPanel;
    }

    private JPanel createAddHandlerPanel(ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider) {
        JPanel addHandlerPanel = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(200, 40), 0);
        addHandlerPanel.setBorder(new EmptyBorder(0, 13, 3, 0));
        this.addHandlerButton = new JButton(ImageResource.plusIcon());
        this.addHandlerButton.setName(ADD_HANDLER);
        this.addHandlerButton.addActionListener(e -> ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).addHandler());
        addHandlerPanel.add(this.addHandlerButton);
        this.addUntilLabel = new JLabel(HTML.html((String)HTML.fontBold((String)this.textResource.addUntil())));
        this.addUntilLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        addHandlerPanel.add(this.addUntilLabel);
        return addHandlerPanel;
    }

    void updateFollowScrewMode(ScrewdrivingProgramNodeContribution.FollowScrewMode followScrewMode) {
        int selection = 0;
        for (int i = 0; i < this.followScrewSelectionDropDown.getItemCount(); ++i) {
            if (this.followScrewSelectionDropDown.getItemAt(i).followScrewMode != followScrewMode) continue;
            selection = i;
            break;
        }
        this.followScrewSelectionDropDown.setSelectedIndex(selection);
        switch (followScrewMode) {
            case FORCE: {
                ((CardLayout)this.handlerLineOneCards.getLayout()).show(this.handlerLineOneCards, FORCE);
                ((CardLayout)this.handlerLineTwoCards.getLayout()).show(this.handlerLineTwoCards, SPEED);
                break;
            }
            case SPEED: {
                ((CardLayout)this.handlerLineOneCards.getLayout()).show(this.handlerLineOneCards, SPEED);
                ((CardLayout)this.handlerLineTwoCards.getLayout()).show(this.handlerLineTwoCards, ACCELERATION);
                break;
            }
            case EXPRESSION: {
                ((CardLayout)this.handlerLineOneCards.getLayout()).show(this.handlerLineOneCards, EXPRESSION);
                ((CardLayout)this.handlerLineTwoCards.getLayout()).show(this.handlerLineTwoCards, EXPRESSION);
                break;
            }
        }
    }

    void updateFollowScrewEnabled(boolean enabled) {
        ScrewdrivingProgramNodeView.enable(this.handlerLineOneCards, enabled);
        ScrewdrivingProgramNodeView.enable(this.handlerLineTwoCards, enabled);
        this.followScrewSelectionDropDown.setEnabled(enabled);
        this.followScrewSelection.setSelected(enabled);
    }

    private static void enable(Container c, boolean enabled) {
        for (Component comp : c.getComponents()) {
            comp.setEnabled(enabled);
            if (!(comp instanceof Container)) continue;
            ScrewdrivingProgramNodeView.enable((Container)comp, enabled);
        }
    }

    private JPanel createForceLine(final ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider, final JTextField forceTextField) {
        JLabel fLabel = new JLabel(this.textResource.force());
        forceTextField.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(forceTextField, new Dimension(85, 30));
        forceTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (forceTextField.isEnabled()) {
                    KeyboardNumberInput<Double> keyboard = ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getForceSelectionKeyboard();
                    keyboard.show(forceTextField, ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getForceEnteredCallback());
                }
            }
        });
        JLabel forceUnit = new JLabel(Units.getText().unitN());
        JPanel withUnit = this.createComponentWithUnit(forceTextField, forceUnit);
        return this.createHandlerLeftRightPanel(32, fLabel, withUnit);
    }

    private JPanel createSpeedLine(final ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider, final JTextField speedTextField, String speedLabelText) {
        JLabel sLabel = new JLabel(speedLabelText);
        speedTextField.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(speedTextField, new Dimension(85, 30));
        speedTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (speedTextField.isEnabled()) {
                    KeyboardNumberInput<Double> keyboard = ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getSpeedSelectionKeyboard();
                    keyboard.show(speedTextField, ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getSpeedEnteredCallback());
                }
            }
        });
        JPanel withSUnit = this.createComponentWithUnit(speedTextField, new JLabel(Units.getText().unitMmS()));
        return this.createHandlerLeftRightPanel(32, sLabel, withSUnit);
    }

    private JPanel createAccelerationLine(final ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider, final JTextField accelerationTextField) {
        JLabel aLabel = new JLabel(this.textResource.acceleration());
        accelerationTextField.setAlignmentX(0.0f);
        ScrewdrivingProgramNodeView.setDimension(accelerationTextField, new Dimension(85, 30));
        accelerationTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (accelerationTextField.isEnabled()) {
                    KeyboardNumberInput<Double> keyboard = ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getAccelerationSelectionKeyboard();
                    keyboard.show(accelerationTextField, ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getAccelerationEnteredCallback());
                }
            }
        });
        JLabel accelerationUnitLabel = new JLabel(Units.getText().unitMmS2());
        JPanel withAUnit = this.createComponentWithUnit(accelerationTextField, accelerationUnitLabel);
        return this.createHandlerLeftRightPanel(32, aLabel, withAUnit);
    }

    private JPanel createExpressionLine(final ContributionProvider<ScrewdrivingProgramNodeContribution> contributionProvider, final JTextField expressionTextField) {
        expressionTextField.setAlignmentX(0.0f);
        expressionTextField.setHorizontalAlignment(0);
        expressionTextField.setText("f(x)");
        ScrewdrivingProgramNodeView.setDimension(expressionTextField, new Dimension(403, 30));
        expressionTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardExpressionInput keyboard = ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getUntilExpressionKeyboard();
                keyboard.show(expressionTextField, ((ScrewdrivingProgramNodeContribution)contributionProvider.get()).getExpressionCallback());
            }
        });
        JPanel linePanel = ScrewdrivingProgramNodeView.createBoxLayoutPanel(this.handlersLinePanelDimensions, 0);
        JPanel left = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(450, 40), 0);
        left.add(Box.createRigidArea(new Dimension(32, 40)));
        left.add(expressionTextField);
        linePanel.add(left);
        linePanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        return linePanel;
    }

    private JPanel createComponentWithUnit(JComponent component, JComponent unit) {
        JPanel linePanel = ScrewdrivingProgramNodeView.createBoxLayoutPanel(this.handlersLinePanelDimensions, 0);
        linePanel.add(component);
        linePanel.add(Box.createRigidArea(new Dimension(10, 40)));
        linePanel.add(unit);
        return linePanel;
    }

    private JPanel createHandlerLeftRightPanel(int indent, JComponent leftc, JComponent rightc) {
        JPanel linePanel = ScrewdrivingProgramNodeView.createBoxLayoutPanel(this.handlersLinePanelDimensions, 0);
        JPanel left = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(350, 40), 0);
        left.add(Box.createRigidArea(new Dimension(indent, 40)));
        left.add(leftc);
        linePanel.add(left);
        if (rightc != null) {
            JPanel right = ScrewdrivingProgramNodeView.createBoxLayoutPanel(new Dimension(250, 40), 0);
            right.add(rightc);
            linePanel.add(right);
        }
        linePanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        return linePanel;
    }

    private static void setDimension(JComponent component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }

    void updateWarning(boolean showWarning, String text) {
        this.warningLabel.setText(text);
        this.warningLabel.setVisible(showWarning);
    }

    void updateBitwiseProgramSelection(Collection<ScrewdriverProgram> programs, ScrewdriverProgram selectedProgram) {
        this.programSelectionRenderingStrategy.setPrograms(programs);
        DefaultComboBoxModel<ScrewdriverProgram> model = new DefaultComboBoxModel<ScrewdriverProgram>(programs.toArray(new ScrewdriverProgram[0]));
        model.setSelectedItem(selectedProgram);
        this.programSelectionDropDown.setModel(model);
        this.programSelectionDropDown.setVisible(true);
        this.programSelectionTextField.setVisible(false);
    }

    void updateIntegerProgramSelection(int selectedProgram) {
        this.programSelectionDropDown.setVisible(false);
        this.programSelectionTextField.setVisible(true);
        if (selectedProgram >= 0) {
            this.programSelectionTextField.setText(Integer.toString(selectedProgram));
        } else {
            this.programSelectionTextField.setText("");
        }
    }

    void updateMoveNodeSelection(boolean selected) {
        if (this.moveNodeSelection.isSelected() != selected) {
            this.moveNodeSelection.setSelected(selected);
        }
    }

    void updateMachineErrorHandlerSelection(boolean selected, boolean hasErrorHandlerCapability) {
        if (this.machineErrorHandlerSelection.isSelected() != selected) {
            this.machineErrorHandlerSelection.setSelected(selected);
        }
        this.machineErrorHandlerSelection.setVisible(hasErrorHandlerCapability);
    }

    void updateDirectionField(boolean tightening) {
        if (tightening) {
            this.tightenButton.setSelected(true);
        } else {
            this.loosenButton.setSelected(true);
        }
    }

    void updateForce(Force forceValue, Force.Unit unit, boolean enabled) {
        if (forceValue != null && enabled) {
            String value = String.format("%.2f", forceValue.getAs(unit));
            this.forceTextField.setText(value);
        } else {
            this.forceTextField.setText("");
        }
    }

    void updateSpeed(Speed speedValue, Speed.Unit unit, boolean enabled) {
        if (speedValue != null && enabled) {
            String value = String.format("%.2f", speedValue.getAs(unit));
            this.speedTextField.setText(value);
            this.forceSpeedTextField.setText(value);
            this.expressionSpeedTextField.setText(value);
        } else {
            this.speedTextField.setText("");
            this.forceSpeedTextField.setText("");
            this.expressionSpeedTextField.setText("");
        }
    }

    void updateAccelerationValue(Acceleration accelerationValue, Acceleration.Unit unit, boolean enabled) {
        if (accelerationValue != null && enabled) {
            String value = String.format("%.2f", accelerationValue.getAs(unit));
            this.accelerationTextField.setText(value);
        } else {
            this.accelerationTextField.setText("");
        }
    }

    void updateExpressionValue(String expression, boolean enabled) {
        if (expression != null && !expression.isEmpty() && enabled) {
            this.expressionTextField.setText(expression);
        } else {
            this.expressionTextField.setText("f(x)");
        }
    }

    void updateHandlerButton(boolean enabled) {
        this.addHandlerButton.setEnabled(enabled);
        this.addUntilLabel.setEnabled(enabled);
    }

    void updateProgramSelectionArea(boolean bitwiseSelection) {
        this.programSelectionLabel.setVisible(this.isProgramSelectionEnabled());
        this.programSelectionDropDown.setVisible(this.isProgramSelectionEnabled() && bitwiseSelection);
        this.programSelectionTextField.setVisible(this.isProgramSelectionEnabled() && !bitwiseSelection);
    }

    void updateDirectionArea() {
        this.directionLabel.setVisible(this.isDirectionEnabled());
        this.tightenButton.setVisible(this.isDirectionEnabled());
        this.loosenButton.setVisible(this.isDirectionEnabled());
    }

    void updateTitleAndLogo(String title, Icon logo) {
        this.selectedScrewdriverLabel.setText(HTML.html((String)(this.textResource.selectedScrewdriver() + ": " + HTML.fontBold((String)title))));
        if (logo != null) {
            this.selectedScrewdriverLogo.setVisible(true);
            this.selectedScrewdriverLogo.setIcon(logo);
        } else {
            this.selectedScrewdriverLogo.setVisible(false);
        }
    }

    public void setProgramSelectionEnabled(boolean enabled) {
        this.programSelectionEnabled = enabled;
    }

    public boolean isProgramSelectionEnabled() {
        return this.programSelectionEnabled;
    }

    public boolean isDirectionEnabled() {
        return this.directionEnabled;
    }

    public void setDirectionEnabled(boolean directionEnabled) {
        this.directionEnabled = directionEnabled;
    }

    private static class FollowScrewItem {
        private ScrewdrivingProgramNodeContribution.FollowScrewMode followScrewMode;
        private String text;

        FollowScrewItem(ScrewdrivingProgramNodeContribution.FollowScrewMode followScrewMode, String text) {
            this.followScrewMode = followScrewMode;
            this.text = text;
        }

        ScrewdrivingProgramNodeContribution.FollowScrewMode getFollowScrewMode() {
            return this.followScrewMode;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class ProgramSelectionRenderingStrategy
    implements RenderingStrategy {
        private Collection<ScrewdriverProgram> programs = new ArrayList<ScrewdriverProgram>();

        ProgramSelectionRenderingStrategy() {
        }

        void setPrograms(Collection<ScrewdriverProgram> programs) {
            this.programs = new ArrayList<ScrewdriverProgram>(programs);
        }

        public String getText(Object o) {
            return o == null ? "" : ((ScrewdriverProgram)o).getDisplayName();
        }

        public Icon getIcon(Object o) {
            return null;
        }

        public boolean hasError(Object o) {
            return !this.programs.contains(o);
        }
    }
}

