/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.screwdriving.program.ScriptGenerationContext;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Speed;

public final class ScriptGeneration {
    public static final double DEFAULT_ACCELERATION = 1.2;

    private ScriptGeneration() {
    }

    static void generateFollowScrewThread(ScriptWriter scriptWriter, ScriptGenerationContext scriptGenerationContext) {
        double fss = ScriptGeneration.getFollowScrewSpeed(scriptGenerationContext);
        double acceleration = ScriptGeneration.getAcceleration(scriptGenerationContext);
        String moveThreadName = scriptWriter.getResolvedVariableName(scriptGenerationContext.getMoveThreadVariable());
        scriptWriter.defineThread(moveThreadName);
        ScriptGeneration.addMoveScript(scriptWriter, fss, acceleration);
        scriptWriter.end();
    }

    static void generateFollowScrewExpressionHandling(ScriptWriter scriptWriter, ScriptGenerationContext scriptGenerationContext) {
        String moveThreadId = scriptWriter.getResolvedVariableName(scriptGenerationContext.getMoveThreadIDVariable());
        String moveThreadName = scriptWriter.getResolvedVariableName(scriptGenerationContext.getMoveThreadVariable());
        String continueScrewDrivingVariableName = scriptWriter.getResolvedVariableName(scriptGenerationContext.getContinueScrewDrivingVariable());
        scriptWriter.elseIfCondition(continueScrewDrivingVariableName + " > 0");
        ScriptGenerationContext.FollowScrew followScrew = scriptGenerationContext.getFollowScrew();
        scriptWriter.ifCondition(followScrew.getExpression());
        scriptWriter.ifCondition(moveThreadId + " < 0");
        scriptWriter.assign(moveThreadId, "run " + moveThreadName + "()");
        scriptWriter.end();
        scriptWriter.elseCondition();
        scriptWriter.appendLine("kill " + moveThreadId);
        scriptWriter.assign(moveThreadId, "-1");
        scriptWriter.appendLine("stopl(1.2)");
        scriptWriter.end();
    }

    private static double getFollowScrewSpeed(ScriptGenerationContext scriptGenerationContext) {
        double fss = 0.001 * scriptGenerationContext.getFollowScrew().getSpeed().getAs(Speed.Unit.MM_S);
        if (!scriptGenerationContext.getFollowScrew().screwIn()) {
            fss *= -1.0;
        }
        return fss;
    }

    private static double getAcceleration(ScriptGenerationContext scriptGenerationContext) {
        ScriptGenerationContext.FollowScrew followScrew = scriptGenerationContext.getFollowScrew();
        double acceleration = followScrew.getFollowScrewMode() == ScrewdrivingProgramNodeContribution.FollowScrewMode.SPEED ? 0.001 * followScrew.getAcceleration().getAs(Acceleration.Unit.MM_S2) : 1.2;
        if (!followScrew.screwIn()) {
            acceleration *= -1.0;
        }
        return acceleration;
    }

    private static void addMoveScript(ScriptWriter scriptWriter, double fss, double acceleration) {
        String moveTime = "2147483647";
        scriptWriter.assign("local actualTCPPose", "get_actual_tcp_pose()");
        String ori = "p[0,0,0,actualTCPPose[3],actualTCPPose[4],actualTCPPose[5]]";
        String z = "p[0,0,1,0,0,0]";
        scriptWriter.assign("local poseTrans", "pose_trans(" + ori + "," + z + ")");
        String pos = "poseTrans[0],poseTrans[1],poseTrans[2],0,0,0";
        scriptWriter.assign("local normal", "normalize([" + pos + "])");
        String speed = "[normal[0]*" + fss + ",normal[1]*" + fss + ",normal[2]*" + fss + ",0,0,0]";
        scriptWriter.appendLine("speedl(" + speed + "," + acceleration + "," + moveTime + ")");
    }
}

