/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.screwdriving.handlers.HandlerNodeType;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.screwdriving.program.ScriptGenerationContext;
import com.ur.polyscope.screwdriving.program.SpeedMode;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverParameters;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ScriptGenerationContextImpl
implements ScriptGenerationContext {
    private boolean isUsingTime;
    private boolean isUsingDistance;
    private Capability stopCapability;
    private ScrewdriverParameters operationParameters;
    private TCP tcp;
    private final ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution;
    private final CapabilitiesDefinition capabilitiesDefinition;
    private final ScrewdriverParameters screwdriverOperationParameters;

    ScriptGenerationContextImpl(CapabilitiesDefinition capabilitiesDefinition, ScrewdriverParameters operationParameters, ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution) {
        this.screwdrivingProgramNodeContribution = screwdrivingProgramNodeContribution;
        this.capabilitiesDefinition = capabilitiesDefinition;
        this.screwdriverOperationParameters = operationParameters;
        for (HandlerNodeType handlerNodeType : this.getHandlerNodes()) {
            switch (handlerNodeType.getHandlerType()) {
                case HANDLER_ERROR_DISTANCE: 
                case HANDLER_UNTIL_DISTANCE: {
                    this.isUsingDistance = true;
                    break;
                }
                case HANDLER_UNTIL_TIME: 
                case HANDLER_ERROR_TIMEOUT: {
                    this.isUsingTime = true;
                    break;
                }
            }
        }
        Optional<Capability> stopCap = capabilitiesDefinition.getCapability(Capability.CapabilityType.STOP_DRIVE_SCREW);
        if (!stopCap.isPresent()) {
            throw new IllegalStateException("No Stop Capability Registered");
        }
        this.stopCapability = stopCap.get();
        this.operationParameters = operationParameters;
        this.tcp = capabilitiesDefinition.getTcp();
    }

    @Override
    public boolean isFollowingScrew() {
        return this.screwdrivingProgramNodeContribution.isFollowScrewEnabledValue();
    }

    @Override
    public ScriptGenerationContext.FollowScrew getFollowScrew() {
        return new ScriptGenerationContext.FollowScrew(){
            SpeedMode speedMode = SpeedMode.fromFollowTheScrewMode(this.getFollowScrewMode());

            @Override
            public Force getForce() {
                return ScriptGenerationContextImpl.this.screwdrivingProgramNodeContribution.getForceValue();
            }

            @Override
            public Speed getSpeed() {
                return ScriptGenerationContextImpl.this.screwdrivingProgramNodeContribution.getSpeedValue(this.speedMode);
            }

            @Override
            public Acceleration getAcceleration() {
                return ScriptGenerationContextImpl.this.screwdrivingProgramNodeContribution.getAccelerationValue();
            }

            @Override
            public String getExpression() {
                return ScriptGenerationContextImpl.this.screwdrivingProgramNodeContribution.getUntilExpression();
            }

            @Override
            public ScrewdrivingProgramNodeContribution.FollowScrewMode getFollowScrewMode() {
                return ScriptGenerationContextImpl.this.screwdrivingProgramNodeContribution.getFollowScrewMode();
            }

            @Override
            public boolean screwIn() {
                return ScriptGenerationContextImpl.this.screwdrivingProgramNodeContribution.isTightening();
            }
        };
    }

    @Override
    public boolean isUsingTime() {
        return this.isUsingTime;
    }

    @Override
    public boolean isUsingDistance() {
        return this.isUsingDistance;
    }

    @Override
    public Variable getContinueScrewDrivingVariable() {
        return this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyContinueScrewdrivingVariable(), (Variable)null);
    }

    @Override
    public Variable getMoveThreadVariable() {
        return this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyMoveThreadVariable(), (Variable)null);
    }

    @Override
    public Variable getMoveThreadIDVariable() {
        return this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyMoveThreadIdVariable(), (Variable)null);
    }

    @Override
    public Variable getTimeVariable() {
        return this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyMoveTimeVariable(), (Variable)null);
    }

    @Override
    public Variable getScrewPositionVariable() {
        return this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyScrewPositionVariable(), (Variable)null);
    }

    @Override
    public Variable getScrewDistanceVariable() {
        return this.screwdrivingProgramNodeContribution.getDataModel().get(ScrewdrivingProgramNodeContribution.getKeyScrewDistanceVariable(), (Variable)null);
    }

    @Override
    public TCP getTCP() {
        return this.tcp;
    }

    @Override
    public Capability getStopCapability() {
        return this.stopCapability;
    }

    @Override
    public ScrewdriverParameters getOperationParameters() {
        return this.operationParameters;
    }

    @Override
    public CapabilitiesDefinition getCapabilitiesDefinition() {
        return this.capabilitiesDefinition;
    }

    @Override
    public ScrewdriverParameters getScrewdriverParameters() {
        return this.screwdriverOperationParameters;
    }

    private List<HandlerNodeType> getHandlerNodes() {
        ArrayList<HandlerNodeType> list = new ArrayList<HandlerNodeType>();
        TreeNode rootTreeNode = this.screwdrivingProgramNodeContribution.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this.screwdrivingProgramNodeContribution);
        for (TreeNode treeNode : rootTreeNode.getChildren()) {
            ProgramNode programNode = treeNode.getProgramNode();
            if (!(programNode instanceof URCapProgramNode) || !((URCapProgramNode)programNode).canGetAs(HandlerNodeType.class)) continue;
            HandlerNodeType handlerNodeTypeInstance = (HandlerNodeType)((URCapProgramNode)programNode).getAs(HandlerNodeType.class);
            list.add(handlerNodeTypeInstance);
        }
        return list;
    }
}

