/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.program;

import com.ur.polyscope.screwdriving.internal.ProgramNodeContext;
import com.ur.polyscope.screwdriving.internal.ScrewdrivingProgramContext;
import com.ur.polyscope.screwdriving.program.MachineErrorHandlerService;
import com.ur.polyscope.screwdriving.program.ScrewdrivingProgramNodeContribution;
import com.ur.polyscope.screwdriving.program.ScriptGeneration;
import com.ur.polyscope.screwdriving.program.ScriptGenerationContext;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverParameters;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.ArrayList;
import java.util.Optional;

public class ScriptGenerationService {
    private final ScriptGenerationContext scriptGenerationContext;
    private final ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution;
    private final ScrewdrivingProgramContext screwdrivingProgramContext;
    private final MachineErrorHandlerService machineErrorHandlerService;

    public ScriptGenerationService(ScriptGenerationContext scriptGenerationContext, ScrewdrivingProgramNodeContribution screwdrivingProgramNodeContribution, ScrewdrivingProgramContext screwdrivingProgramContext, MachineErrorHandlerService machineErrorHandlerService) {
        this.scriptGenerationContext = scriptGenerationContext;
        this.screwdrivingProgramNodeContribution = screwdrivingProgramNodeContribution;
        this.screwdrivingProgramContext = screwdrivingProgramContext;
        this.machineErrorHandlerService = machineErrorHandlerService;
    }

    public void generateScript(ScriptWriter scriptWriter) {
        CapabilitiesDefinition definition = this.scriptGenerationContext.getCapabilitiesDefinition();
        boolean hasMachineErrorHandler = this.machineErrorHandlerService.getMachineErrorHandlerNode().isPresent();
        if (!hasMachineErrorHandler) {
            ArrayList capabilities = new ArrayList();
            definition.getCapability(Capability.CapabilityType.MACHINE_READY).ifPresent(capabilities::add);
            definition.getCapability(Capability.CapabilityType.PROGRAM_SELECTION).ifPresent(capabilities::add);
            definition.getCapability(Capability.CapabilityType.FEED_SCREW).ifPresent(capabilities::add);
            definition.getCapability(Capability.CapabilityType.PREPARE).ifPresent(capabilities::add);
            for (Capability cap : capabilities) {
                scriptWriter.appendLine(this.screwdrivingProgramNodeContribution.getFunctionName(cap.getCapabilityType()) + "()");
            }
            Optional<Capability> startCap = definition.getCapability(Capability.CapabilityType.START_DRIVE_SCREW);
            startCap.ifPresent(capability -> capability.generateScript(scriptWriter, this.scriptGenerationContext.getScrewdriverParameters()));
            this.generateWaitForOKNOKLow(scriptWriter, definition);
        }
        ScrewdrivingProgramNodeContribution.FollowScrewMode followScrewMode = this.scriptGenerationContext.getFollowScrew().getFollowScrewMode();
        if (this.scriptGenerationContext.isFollowingScrew() && (followScrewMode == ScrewdrivingProgramNodeContribution.FollowScrewMode.SPEED || followScrewMode == ScrewdrivingProgramNodeContribution.FollowScrewMode.EXPRESSION)) {
            ScriptGeneration.generateFollowScrewThread(scriptWriter, this.scriptGenerationContext);
        }
        scriptWriter.writeChildren();
        if (this.scriptGenerationContext.isFollowingScrew() && followScrewMode == ScrewdrivingProgramNodeContribution.FollowScrewMode.EXPRESSION) {
            ScriptGeneration.generateFollowScrewExpressionHandling(scriptWriter, this.scriptGenerationContext);
        }
        scriptWriter.end();
        this.generateRestartScrewdriverIfPaused(scriptWriter, definition);
        scriptWriter.sync();
        scriptWriter.end();
        scriptWriter.assign(scriptWriter.getResolvedVariableName(this.scriptGenerationContext.getContinueScrewDrivingVariable()), "1");
        if (hasMachineErrorHandler) {
            scriptWriter.end();
        }
    }

    private void generateRestartScrewdriverIfPaused(ScriptWriter scriptWriter, CapabilitiesDefinition capabilitiesDefinition) {
        Optional<String> startActiveCondition = capabilitiesDefinition.getStartActiveCondition();
        if (startActiveCondition.isPresent()) {
            String continueVariable = scriptWriter.getResolvedVariableName(this.scriptGenerationContext.getContinueScrewDrivingVariable());
            String condition = continueVariable + "> 0";
            condition = condition + " and " + startActiveCondition.get();
            scriptWriter.ifCondition(condition);
            Optional<Capability> startCap = capabilitiesDefinition.getCapability(Capability.CapabilityType.START_DRIVE_SCREW);
            startCap.ifPresent(capability -> capability.generateScript(scriptWriter, this.getScrewdriverOperationParameters()));
            scriptWriter.end();
        }
    }

    private ScrewdriverParameters getScrewdriverOperationParameters() {
        ProgramNodeContext context = this.screwdrivingProgramContext.getContextForProgramNode(this.screwdrivingProgramNodeContribution.getNodeName());
        return context.getOperationParameters();
    }

    private void generateWaitForOKNOKLow(ScriptWriter scriptWriter, CapabilitiesDefinition capabilitiesDefinition) {
        if (capabilitiesDefinition.isNative()) {
            Optional<Capability> okCap = capabilitiesDefinition.getCapability(Capability.CapabilityType.OK);
            Optional<Capability> nokCap = capabilitiesDefinition.getCapability(Capability.CapabilityType.NOTOK);
            if (!okCap.isPresent() && !nokCap.isPresent()) {
                return;
            }
            String condition = "";
            if (okCap.isPresent()) {
                condition = this.screwdrivingProgramNodeContribution.getFunctionName(Capability.CapabilityType.OK) + "()";
            }
            if (nokCap.isPresent()) {
                if (!condition.isEmpty()) {
                    condition = condition + " or ";
                }
                condition = condition + this.screwdrivingProgramNodeContribution.getFunctionName(Capability.CapabilityType.NOTOK) + "()";
            }
            this.generateWait(scriptWriter, condition);
        }
    }

    private void generateWait(ScriptWriter scriptWriter, String condition) {
        scriptWriter.whileCondition(condition);
        scriptWriter.sleep(0.01);
        scriptWriter.end();
    }
}

