/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.simpsons;

import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.simpsons.installation.ProgramList;
import com.ur.polyscope.screwdriving.simpsons.installation.ProgramListImpl;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.CapabilityAlreadyRegistered;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgramList;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgramListProvider;
import com.ur.urcap.api.domain.tcp.TCP;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class CapabilitiesDefinition {
    private static final Predicate<Capability> machineReadyPredicate = c -> c.getCapabilityType().equals((Object)Capability.CapabilityType.MACHINE_READY);
    private static final Predicate<Capability> programSelectionPredicate = c -> c.getCapabilityType().equals((Object)Capability.CapabilityType.PROGRAM_SELECTION);
    private static final Predicate<Capability> feedScrewPredicate = c -> c.getCapabilityType().equals((Object)Capability.CapabilityType.FEED_SCREW);
    private static final Predicate<Capability> preparePredicate = c -> c.getCapabilityType().equals((Object)Capability.CapabilityType.PREPARE);
    private static final Predicate<Capability> hasMachineErrorHandlerCapabilityPredicate = machineReadyPredicate.or(programSelectionPredicate).or(feedScrewPredicate).or(preparePredicate);
    private boolean isNative;
    private TCP tcp;
    private boolean supportOperationType;
    private Set<Capability> capabilitySet = new HashSet<Capability>();
    private ProgramList programList;
    private String startActiveCondition;
    private boolean requireTCP;
    private boolean isBitwiseProgramSelection = true;

    public void setSupportOperationType(boolean supportOperationType) {
        this.supportOperationType = supportOperationType;
    }

    public void setProgramListProvider(ScrewdriverProgramListProvider programListProvider) {
        this.programList = new ProgramListImpl();
        programListProvider.populateList((ScrewdriverProgramList)this.programList);
    }

    public void addCapability(Capability capability) {
        if (this.capabilitySet.stream().anyMatch(c -> c.getCapabilityType() == capability.getCapabilityType())) {
            throw new CapabilityAlreadyRegistered("CapabilityType " + capability.getCapabilityType().name() + " was already registered");
        }
        this.capabilitySet.add(capability);
    }

    public Optional<Capability> getCapability(Capability.CapabilityType capability) {
        return this.capabilitySet.stream().filter(cap -> cap.getCapabilityType().equals((Object)capability)).findAny();
    }

    public boolean isSupportOperationType() {
        return this.supportOperationType;
    }

    public ProgramList getProgramList() {
        return this.programList != null ? this.programList : new ProgramList(){

            public void add(ScrewdriverProgram screwdriverProgram) {
            }

            public void addAll(List<ScrewdriverProgram> screwdriverProgramList) {
            }

            @Override
            public List<ScrewdriverProgram> getPrograms() {
                return new ArrayList<ScrewdriverProgram>();
            }
        };
    }

    public boolean hasMachineErrorHandlerCapability() {
        return this.capabilitySet.stream().anyMatch(hasMachineErrorHandlerCapabilityPredicate);
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean aNative) {
        this.isNative = aNative;
    }

    public TCP getTcp() {
        return this.tcp;
    }

    public void setTcp(TCP tcp) {
        this.tcp = tcp;
    }

    public void registerStartActiveCondition(String condition) {
        this.startActiveCondition = condition;
    }

    public Optional<String> getStartActiveCondition() {
        return Optional.ofNullable(this.startActiveCondition);
    }

    public boolean requireTCP() {
        return this.requireTCP;
    }

    public void setRequireTCP(boolean requireTCP) {
        this.requireTCP = requireTCP;
    }

    public boolean isBitwiseProgramSelection() {
        return this.isBitwiseProgramSelection;
    }

    public void setBitwiseProgramSelection(boolean bitwiseProgramSelection) {
        this.isBitwiseProgramSelection = bitwiseProgramSelection;
    }
}

