/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.simpsons;

import com.ur.polyscope.screwdriving.simpsons.installation.ProxyScrewdriverInstallationNodeService;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.api.contribution.driver.general.script.ScriptCodeGenerator;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.Locale;
import java.util.Objects;

public class Capability<P> {
    private final CapabilityType capabilityType;
    private final ScriptCodeGenerator<P> scriptCodeGenerator;
    private final ProxyScrewdriverInstallationNodeService proxy;
    private final Locale locale;

    public Capability(CapabilityType capability, ScriptCodeGenerator<P> scriptCodeGenerator, ProxyScrewdriverInstallationNodeService proxy, Locale locale) {
        this.capabilityType = capability;
        this.scriptCodeGenerator = scriptCodeGenerator;
        this.proxy = proxy;
        this.locale = locale;
    }

    public void generateScript(ScriptWriter scriptWriter, P parameters) {
        this.addURCapInformation(scriptWriter);
        try {
            this.scriptCodeGenerator.generateScript(scriptWriter, parameters);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.proxy.getScrewdriverContribution().getClass(), "com.ur.polyscope.screwdriving.simpsons.Capability", "generateScript");
        }
        this.endURCapInformation(scriptWriter);
    }

    public CapabilityType getCapabilityType() {
        return this.capabilityType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capability that = (Capability)o;
        return this.capabilityType == that.capabilityType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilityType});
    }

    private void addURCapInformation(ScriptWriter scriptWriter) {
        if (this.proxy != null) {
            scriptWriter.appendLine("# begin: Capability " + this.capabilityType.name());
            scriptWriter.appendLine("#  Source: " + this.proxy.getSymbolicName());
            scriptWriter.appendLine("#  Type: " + this.proxy.getTitle(this.locale));
        }
    }

    private void endURCapInformation(ScriptWriter scriptWriter) {
        if (this.proxy != null) {
            scriptWriter.appendLine("# end: Capability " + this.capabilityType.name());
        }
    }

    public static enum CapabilityType {
        MACHINE_READY,
        PROGRAM_SELECTION,
        FEED_SCREW,
        PREPARE,
        OK,
        NOTOK,
        START_DRIVE_SCREW,
        STOP_DRIVE_SCREW;

    }
}

