/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.simpsons;

import com.ur.polyscope.screwdriving.simpsons.AllCapabilities;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.simpsons.ScrewdriverContext;
import com.ur.polyscope.screwdriving.simpsons.installation.ProxyScrewdriverInstallationNodeService;
import com.ur.urcap.api.contribution.driver.general.script.ScriptCodeGenerator;
import com.ur.urcap.api.contribution.driver.screwdriver.CalledOutsideScrewdriverConfigurationPhase;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgramListProvider;
import java.util.Locale;

public class CapabilityServiceImpl
implements AllCapabilities {
    private final CapabilitiesDefinition capabilitiesDefinition;
    private final ProxyScrewdriverInstallationNodeService creator;
    private final Locale locale;
    private final ScrewdriverContext context;

    public CapabilityServiceImpl(CapabilitiesDefinition capabilitiesDefinition, ProxyScrewdriverInstallationNodeService creator, Locale locale, ScrewdriverContext context) {
        this.capabilitiesDefinition = capabilitiesDefinition;
        this.creator = creator;
        this.locale = locale;
        this.context = context;
    }

    public void registerPrepareToStartScrewdriverCapability(ScriptCodeGenerator scriptCodeGenerator) {
        this.checkIfRegistrationAllowed();
        this.capabilitiesDefinition.addCapability(new Capability(Capability.CapabilityType.PREPARE, scriptCodeGenerator, this.creator, this.locale));
    }

    public void registerProgramSelectionCapability(ScrewdriverProgramListProvider programListProvider, ScriptCodeGenerator scriptCodeGenerator) {
        this.checkIfRegistrationAllowed();
        this.capabilitiesDefinition.setProgramListProvider(programListProvider);
        this.capabilitiesDefinition.addCapability(new Capability(Capability.CapabilityType.PROGRAM_SELECTION, scriptCodeGenerator, this.creator, this.locale));
    }

    public void registerOperationTypeCapability() {
        this.checkIfRegistrationAllowed();
        this.capabilitiesDefinition.setSupportOperationType(true);
    }

    public void registerFeedScrewCapability(ScriptCodeGenerator scriptCodeGenerator) {
        this.checkIfRegistrationAllowed();
        this.capabilitiesDefinition.addCapability(new Capability(Capability.CapabilityType.FEED_SCREW, scriptCodeGenerator, this.creator, this.locale));
    }

    public void registerDriveScrewOKCapability(ScriptCodeGenerator scriptCodeGenerator) {
        this.checkIfRegistrationAllowed();
        this.capabilitiesDefinition.addCapability(new Capability(Capability.CapabilityType.OK, scriptCodeGenerator, this.creator, this.locale));
    }

    public void registerDriveScrewNotOKCapability(ScriptCodeGenerator scriptCodeGenerator) {
        this.checkIfRegistrationAllowed();
        this.capabilitiesDefinition.addCapability(new Capability(Capability.CapabilityType.NOTOK, scriptCodeGenerator, this.creator, this.locale));
    }

    public void registerScrewdriverReadyCapability(ScriptCodeGenerator scriptCodeGenerator) {
        this.checkIfRegistrationAllowed();
        this.capabilitiesDefinition.addCapability(new Capability(Capability.CapabilityType.MACHINE_READY, scriptCodeGenerator, this.creator, this.locale));
    }

    private void checkIfRegistrationAllowed() {
        if (!this.context.isCapabilityRegistrationAllowed()) {
            throw new CalledOutsideScrewdriverConfigurationPhase("Cannot register capability outside the scope of ScrewdriverContribution.configureScrewdriver()");
        }
    }
}

