/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.simpsons;

import com.google.common.collect.ImmutableList;
import com.ur.polyscope.installation.urcap.proxy.DriverNodeFactory;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.screwdriving.simpsons.ContributionConfigurationImpl;
import com.ur.polyscope.screwdriving.simpsons.installation.ProxyScrewdriverInstallationNodeService;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.api.contribution.driver.screwdriver.ContributionConfiguration;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverContribution;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ProxyScrewdriver {
    private static final Logger LOG = LogFactory.createLogger(ProxyScrewdriver.class);
    private CompositeContributionConfiguration compositeContributionConfiguration = new CompositeContributionConfiguration();

    public ProxyScrewdriver(BundleContext bundleContext) {
        try {
            this.registerAlreadyAddedScrewdriver(bundleContext);
            this.addScrewdriverListener(bundleContext);
        }
        catch (InvalidSyntaxException e) {
            LOG.error("ScrewdrivingContribution filter has wrong syntax", (Throwable)e);
        }
    }

    private String getCompositeScrewdriverFilter() {
        return "( | (COMPOSITE =SCREWDRIVER))";
    }

    private void registerAlreadyAddedScrewdriver(BundleContext context) throws InvalidSyntaxException {
        for (ServiceReference serviceReference : context.getServiceReferences(SwingInstallationNodeService.class, this.getCompositeScrewdriverFilter())) {
            this.handleNativeSD(context, (ServiceReference<SwingInstallationNodeService>)serviceReference);
        }
        for (ServiceReference serviceReference : context.getServiceReferences(ScrewdriverContribution.class, null)) {
            this.setupProxy(context, (ServiceReference<ScrewdriverContribution>)serviceReference);
        }
    }

    private void addScrewdriverListener(BundleContext context) throws InvalidSyntaxException {
        context.addServiceListener(event -> {
            if (event.getType() == 1) {
                this.handleNativeSD(context, (ServiceReference<SwingInstallationNodeService>)event.getServiceReference());
            }
        }, this.getCompositeScrewdriverFilter());
        context.addServiceListener(event -> {
            if (event.getType() == 1) {
                this.setupProxy(context, (ServiceReference<ScrewdriverContribution>)event.getServiceReference());
            }
        }, "( | (objectClass=" + ScrewdriverContribution.class.getName() + "))");
    }

    private void handleNativeSD(BundleContext context, ServiceReference<SwingInstallationNodeService> swingInstallationNodeServiceServiceReference) {
        SwingInstallationNodeService service = (SwingInstallationNodeService)context.getService(swingInstallationNodeServiceServiceReference);
        service.configureContribution((com.ur.urcap.api.contribution.installation.ContributionConfiguration)this.compositeContributionConfiguration);
    }

    private void setupProxy(BundleContext context, ServiceReference<ScrewdriverContribution> screwdriverContributionReference) {
        ScrewdriverContribution screwdriverContribution = (ScrewdriverContribution)context.getService(screwdriverContributionReference);
        ContributionConfigurationImpl contributionConfiguration = new ContributionConfigurationImpl();
        ProxiedException exception = null;
        try {
            screwdriverContribution.configureContribution((ContributionConfiguration)contributionConfiguration);
        }
        catch (RuntimeException e) {
            exception = new ProxiedException(e, screwdriverContribution.getClass(), "com.ur.polyscope.screwdriving.simpsons.ProxyScrewdriver", "setupProxy");
        }
        this.registerServices(context, screwdriverContribution, contributionConfiguration, (RuntimeException)exception);
    }

    private void registerServices(BundleContext context, ScrewdriverContribution screwdriverContribution, ContributionConfigurationImpl contributionConfiguration, RuntimeException exception) {
        ProxyScrewdriverInstallationNodeService service = new ProxyScrewdriverInstallationNodeService(screwdriverContribution, contributionConfiguration, exception, DriverNodeFactory.createBuilder());
        this.compositeContributionConfiguration.addService(service);
        context.registerService(SwingInstallationNodeService.class, (Object)service, null);
    }

    public static class CompositeContributionConfiguration
    implements com.ur.urcap.api.contribution.installation.ContributionConfiguration {
        List<ProxyScrewdriverInstallationNodeService> list = new ArrayList<ProxyScrewdriverInstallationNodeService>();

        private void addService(ProxyScrewdriverInstallationNodeService service) {
            this.list.add(service);
        }

        public List<ProxyScrewdriverInstallationNodeService> getServices() {
            return ImmutableList.copyOf(this.list);
        }
    }
}

