/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.simpsons.installation;

import com.ur.lang.StringUtils;
import com.ur.polyscope.screwdriving.simpsons.installation.ProgramList;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.DuplicateScrewdriverProgramID;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.NameOfScrewdriverProgramCannotBeNullOrEmpty;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import java.util.ArrayList;
import java.util.List;

public final class ProgramListImpl
implements ProgramList {
    private List<ScrewdriverProgram> programs = new ArrayList<ScrewdriverProgram>();

    public void add(ScrewdriverProgram screwdriverProgram) {
        this.assertProgramOK(screwdriverProgram);
        this.programs.add(screwdriverProgram);
    }

    public void addAll(List<ScrewdriverProgram> screwdriverProgramList) {
        this.assertProgramListOK(screwdriverProgramList);
        screwdriverProgramList.forEach(screwdriverProgram -> {
            this.assertProgramOK((ScrewdriverProgram)screwdriverProgram);
            this.programs.add((ScrewdriverProgram)screwdriverProgram);
        });
    }

    private void assertProgramOK(ScrewdriverProgram screwdriverProgram) {
        if (screwdriverProgram == null) {
            throw new IllegalArgumentException("Program cannot be null");
        }
        if (StringUtils.isNullOrEmpty((String)screwdriverProgram.getDisplayName().trim())) {
            throw new NameOfScrewdriverProgramCannotBeNullOrEmpty("Program display name cannot be null or empty");
        }
        if (this.programs.stream().anyMatch(program -> screwdriverProgram != program && screwdriverProgram.getId().equals(program.getId()))) {
            throw new DuplicateScrewdriverProgramID("Program ID must be unique");
        }
    }

    private void assertProgramListOK(List<ScrewdriverProgram> screwdriverProgramList) {
        if (screwdriverProgramList == null) {
            throw new IllegalArgumentException("Program list cannot be null");
        }
    }

    @Override
    public List<ScrewdriverProgram> getPrograms() {
        return new ArrayList<ScrewdriverProgram>(this.programs);
    }
}

