/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.simpsons.installation;

import com.ur.polyscope.installation.urcap.proxy.DataModelResetable;
import com.ur.polyscope.installation.urcap.proxy.Defined;
import com.ur.polyscope.installation.urcap.proxy.DriverNodeBuilder;
import com.ur.polyscope.screwdriving.simpsons.AbstractProxiedService;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.simpsons.CapabilityServiceImpl;
import com.ur.polyscope.screwdriving.simpsons.ContributionConfigurationImpl;
import com.ur.polyscope.screwdriving.simpsons.ScrewdriverConfigurationImpl;
import com.ur.polyscope.screwdriving.simpsons.ScrewdriverContext;
import com.ur.polyscope.screwdriving.simpsons.SystemConfigurationImpl;
import com.ur.polyscope.screwdriving.simpsons.installation.BasicScrewdriverInstallationNodeView;
import com.ur.polyscope.screwdriving.simpsons.installation.ScrewdriverAPIProviderImpl;
import com.ur.polyscope.screwdriving.simpsons.installation.SelectableScrewdriver;
import com.ur.polyscope.tcp.urcap.TcpConfigurationFactory;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.driver.general.script.ScriptCodeGenerator;
import com.ur.urcap.api.contribution.driver.general.tcp.TCPConfiguration;
import com.ur.urcap.api.contribution.driver.general.userinput.CustomUserInputConfiguration;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverAPIProvider;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverConfiguration;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverContribution;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverParameters;
import com.ur.urcap.api.contribution.driver.screwdriver.SystemConfiguration;
import com.ur.urcap.api.contribution.installation.ContributionConfiguration;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import java.util.Locale;
import javax.inject.Inject;
import javax.swing.ImageIcon;

public class ProxyScrewdriverInstallationNodeService
extends AbstractProxiedService
implements SwingInstallationNodeService<InstallationNodeContribution, BasicScrewdriverInstallationNodeView>,
SelectableScrewdriver,
DataModelResetable {
    private static final String INSTALLATION_NODE_SERVICE = "com.ur.polyscope.screwdriving.simpsons.installation.ProxyScrewdriverInstallationNodeService";
    private static TcpConfigurationFactory tcpConfigurationFactory;
    private final ScrewdriverContribution service;
    private final ContributionConfigurationImpl contributionConfiguration;
    private ScrewdriverContext screwdriverContext;
    private RuntimeException exceptionThrownDuringCreate;
    private String title;
    private BasicScrewdriverInstallationNodeView view;
    private DriverNodeBuilder driverNodeBuilder;
    private InstallationNodeContribution wrappedContribution;
    private CustomUserInputConfiguration customConfiguration;
    private Locale locale;
    private boolean configuredCorrectly;

    public ProxyScrewdriverInstallationNodeService(ScrewdriverContribution service, ContributionConfigurationImpl contributionConfiguration, RuntimeException exceptionThrownDuringCreate, DriverNodeBuilder driverNodeBuilder) {
        super(service.getClass());
        this.service = service;
        this.contributionConfiguration = contributionConfiguration;
        this.driverNodeBuilder = driverNodeBuilder;
        this.exceptionThrownDuringCreate = exceptionThrownDuringCreate;
    }

    @Inject
    public static void setTcpConfigurationFactory(TcpConfigurationFactory tcpConfigurationFactory) {
        ProxyScrewdriverInstallationNodeService.tcpConfigurationFactory = tcpConfigurationFactory;
    }

    public void configureContribution(ContributionConfiguration contributionConfiguration) {
        if (this.exceptionThrownDuringCreate != null) {
            throw this.exceptionThrownDuringCreate;
        }
    }

    @Override
    public String getTitle(Locale locale) {
        if (this.title == null) {
            try {
                this.title = this.service.getTitle(locale);
            }
            catch (RuntimeException e) {
                throw new ProxiedException(e, this.service.getClass(), INSTALLATION_NODE_SERVICE, "getTitle");
            }
        }
        return this.title;
    }

    public BasicScrewdriverInstallationNodeView createView(ViewAPIProvider viewAPIProvider) {
        SwingInstallationNodeView wrappedView = this.driverNodeBuilder.createView(viewAPIProvider, this.contributionConfiguration.getLogo());
        this.view = new BasicScrewdriverInstallationNodeView(wrappedView);
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstallationNodeContribution createInstallationNode(InstallationAPIProvider installationAPIProvider, BasicScrewdriverInstallationNodeView basicScrewdriverInstallationNodeView, DataModel dataModel, CreationContext creationContext) {
        this.locale = installationAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
        try {
            this.getTitle(this.locale);
        }
        catch (RuntimeException e) {
            this.exceptionThrownDuringCreate = e;
        }
        this.screwdriverContext = new ScrewdriverContext();
        this.customConfiguration = this.driverNodeBuilder.createCustomConfiguration(dataModel);
        ValueFactoryProvider valueFactoryProvider = installationAPIProvider.getInstallationAPI().getValueFactoryProvider();
        PoseFactory poseFactory = valueFactoryProvider.getPoseFactory();
        ScrewdriverAPIProviderImpl screwdriverAPIProvider = new ScrewdriverAPIProviderImpl(poseFactory, installationAPIProvider.getSystemAPI(), installationAPIProvider.getInstallationAPI().getIOModel());
        this.screwdriverContext.setCapabilityRegistrationAllowed(true);
        try {
            this.service.configureScrewdriver((ScrewdriverConfiguration)new ScrewdriverConfigurationImpl(new CapabilityServiceImpl(this.screwdriverContext.getCapabilitiesDefinition(), this, this.locale, this.screwdriverContext)), (ScrewdriverAPIProvider)screwdriverAPIProvider);
        }
        catch (RuntimeException e) {
            this.exceptionThrownDuringCreate = new ProxiedException(e, this.service.getClass(), INSTALLATION_NODE_SERVICE, "createInstallationNode");
        }
        finally {
            this.screwdriverContext.setCapabilityRegistrationAllowed(false);
        }
        TCPConfiguration tcpConfiguration = tcpConfigurationFactory.createTCPConfiguration(this.service.getClass(), "");
        try {
            this.service.configureInstallation(this.customConfiguration, (SystemConfiguration)new SystemConfigurationImpl(installationAPIProvider), tcpConfiguration, (ScrewdriverAPIProvider)screwdriverAPIProvider);
            this.addMandatoryCapabilities(this.service, this.screwdriverContext);
        }
        catch (RuntimeException e) {
            this.exceptionThrownDuringCreate = new ProxiedException(e, this.service.getClass(), INSTALLATION_NODE_SERVICE, "createInstallationNode");
        }
        this.wrappedContribution = this.driverNodeBuilder.createNodeContribution(scriptWriter -> {}, basicScrewdriverInstallationNodeView.getWrappedView());
        if (this.exceptionThrownDuringCreate != null) {
            throw this.exceptionThrownDuringCreate;
        }
        this.configuredCorrectly = true;
        return this.wrappedContribution;
    }

    private void addMandatoryCapabilities(ScrewdriverContribution screwdriverContribution, ScrewdriverContext screwdriverContext) {
        screwdriverContext.getCapabilitiesDefinition().addCapability(new Capability<ScrewdriverParameters>(Capability.CapabilityType.START_DRIVE_SCREW, this.getGenerateStartScrewdriverScript(screwdriverContribution), this, this.locale));
        screwdriverContext.getCapabilitiesDefinition().addCapability(new Capability<ScrewdriverParameters>(Capability.CapabilityType.STOP_DRIVE_SCREW, this.getGenerateStopScrewdriverScript(screwdriverContribution), this, this.locale));
    }

    private ScriptCodeGenerator<ScrewdriverParameters> getGenerateStartScrewdriverScript(ScrewdriverContribution screwdriverContribution) {
        try {
            return (arg_0, arg_1) -> ((ScrewdriverContribution)screwdriverContribution).generateStartScrewdriverScript(arg_0, arg_1);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, screwdriverContribution.getClass(), INSTALLATION_NODE_SERVICE, "getGenerateStartScrewdriverScript");
        }
    }

    private ScriptCodeGenerator<ScrewdriverParameters> getGenerateStopScrewdriverScript(ScrewdriverContribution screwdriverContribution) {
        try {
            return (arg_0, arg_1) -> ((ScrewdriverContribution)screwdriverContribution).generateStopScrewdriverScript(arg_0, arg_1);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, screwdriverContribution.getClass(), INSTALLATION_NODE_SERVICE, "getGenerateStopScrewdriverScript");
        }
    }

    public String toString() {
        return this.service.getClass().getName();
    }

    @Override
    public BasicScrewdriverInstallationNodeView getView() {
        return this.view;
    }

    @Override
    public void updateWrappedView() {
        if (this.wrappedContribution != null) {
            this.wrappedContribution.openView();
        }
    }

    @Override
    public ImageIcon getLogo() {
        return this.contributionConfiguration.getLogo();
    }

    public ScrewdriverContext getScrewdriverContext() {
        return this.screwdriverContext;
    }

    public boolean isDefined() {
        if (!this.configuredCorrectly) {
            return false;
        }
        if (this.customConfiguration instanceof Defined) {
            return ((Defined)this.customConfiguration).isDefined();
        }
        return true;
    }

    @Override
    public boolean isConfiguredCorrectly() {
        return this.configuredCorrectly;
    }

    public ScrewdriverContribution getScrewdriverContribution() {
        return this.service;
    }

    public void finalizeDataModelReset() {
        if (this.customConfiguration instanceof DataModelResetable) {
            ((DataModelResetable)this.customConfiguration).finalizeDataModelReset();
        }
    }

    public boolean isFinalizeRequired() {
        if (this.customConfiguration instanceof DataModelResetable) {
            return ((DataModelResetable)this.customConfiguration).isFinalizeRequired();
        }
        return false;
    }

    public RuntimeException getExceptionThrownDuringCreate() {
        return this.exceptionThrownDuringCreate;
    }
}

