/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.util;

import com.ur.polyscope.screwdriving.util.ExpressionKeyboard;
import com.ur.polyscope.urcaps.userinteraction.keyboard.ExpressionInput;
import com.ur.polyscope.urcaps.userinteraction.keyboard.KeyboardExpressionInput;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.value.expression.Expression;
import java.util.Objects;
import javax.inject.Inject;

public class ExpressionKeyboardService
implements ExpressionKeyboard {
    private final KeyboardExpressionInput keyboardExpressionInput;
    private final ExpressionInput expressionInput;

    @Inject
    public ExpressionKeyboardService(KeyboardExpressionInput keyboardExpressionInput, ExpressionInput expressionInput) {
        this.keyboardExpressionInput = keyboardExpressionInput;
        this.expressionInput = expressionInput;
    }

    @Override
    public KeyboardExpressionInput getExpressionKeyboard(String initialExpression) {
        if (Objects.nonNull(initialExpression)) {
            this.keyboardExpressionInput.setInitialValue(initialExpression);
        }
        return this.keyboardExpressionInput;
    }

    @Override
    public KeyboardInputCallback<Expression> getExpressionCallback(final DataModel dataModel, final String expressionKey, final String expressionStringValueKey, final UndoRedoManager undoRedoManager) {
        return new KeyboardInputCallback<Expression>(){

            public void onOk(Expression s) {
                ExpressionBranchNode expressionBranchNode = ExpressionKeyboardService.this.expressionInput.getExpressionBranchNode(s);
                undoRedoManager.recordChanges(() -> {
                    dataModel.set(expressionKey, expressionBranchNode.generateScriptCode());
                    String expressionString = expressionBranchNode.toString();
                    if (expressionString.contains("Exp: ")) {
                        String expressionValue = expressionString.substring(5);
                        dataModel.set(expressionStringValueKey, expressionValue);
                    }
                });
            }
        };
    }
}

