/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class SwingLayout {
    private SwingLayout() {
    }

    public static JPanel createBoxLayoutPanel(Dimension dimension, int axis) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        SwingLayout.setDimension(panel, dimension);
        return panel;
    }

    public static void setDimension(JComponent component, int width, int height) {
        SwingLayout.setDimension(component, new Dimension(width, height));
    }

    public static void setDimension(JComponent component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }

    public static void enable(Container c, boolean enabled) {
        for (Component comp : c.getComponents()) {
            comp.setEnabled(enabled);
            if (!(comp instanceof Container)) continue;
            SwingLayout.enable((Container)comp, enabled);
        }
    }
}

