/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.images;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ButtonImageResource {
    private static boolean isG5 = true;

    private ButtonImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/buttons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="red_led.png")
    public static Icon redLed() {
        return ButtonImageResource.tryGetImage("red_led.png");
    }

    @Key(value="yellow_led.png")
    public static Icon yellowLed() {
        return ButtonImageResource.tryGetImage("yellow_led.png");
    }

    @Key(value="green_led.png")
    public static Icon greenLed() {
        return ButtonImageResource.tryGetImage("green_led.png");
    }

    @Key(value="blue_led.png")
    public static Icon blueLed() {
        return ButtonImageResource.tryGetImage("blue_led.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ButtonImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            ButtonImageResource.tryGetImage("red_led.png");
            ButtonImageResource.tryGetImage("yellow_led.png");
            ButtonImageResource.tryGetImage("green_led.png");
            ButtonImageResource.tryGetImage("blue_led.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

