/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.images;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="initStateRed.png")
    public static Icon initStateRed() {
        return ImageResource.tryGetImage("initStateRed.png");
    }

    @Key(value="form-warning.png")
    public static Icon formWarning() {
        return ImageResource.tryGetImage("form-warning.png");
    }

    @Key(value="check_off.png")
    public static Icon checkOff() {
        return ImageResource.tryGetImage("check_off.png");
    }

    @Key(value="initStateGreen.png")
    public static Icon initStateGreen() {
        return ImageResource.tryGetImage("initStateGreen.png");
    }

    @Key(value="loading_sprite.png")
    public static Icon loadingSprite() {
        return ImageResource.tryGetImage("loading_sprite.png");
    }

    @Key(value="emergency_stop_symbol.png")
    public static Icon emergencyStopSymbol() {
        return ImageResource.tryGetImage("emergency_stop_symbol.png");
    }

    @Key(value="initGray.png")
    public static Icon initGray() {
        return ImageResource.tryGetImage("initGray.png");
    }

    @Key(value="initStateBlue.png")
    public static Icon initStateBlue() {
        return ImageResource.tryGetImage("initStateBlue.png");
    }

    @Key(value="check_ok.png")
    public static Icon checkOk() {
        return ImageResource.tryGetImage("check_ok.png");
    }

    @Key(value="information_icon.png")
    public static Icon informationIcon() {
        return ImageResource.tryGetImage("information_icon.png");
    }

    @Key(value="brakePinFailure.png")
    public static Icon brakePinFailure() {
        return ImageResource.tryGetImage("brakePinFailure.png");
    }

    @Key(value="check_pending.png")
    public static Icon checkPending() {
        return ImageResource.tryGetImage("check_pending.png");
    }

    @Key(value="check_idle.png")
    public static Icon checkIdle() {
        return ImageResource.tryGetImage("check_idle.png");
    }

    @Key(value="initWhite.png")
    public static Icon initWhite() {
        return ImageResource.tryGetImage("initWhite.png");
    }

    @Key(value="initStateYellow.png")
    public static Icon initStateYellow() {
        return ImageResource.tryGetImage("initStateYellow.png");
    }

    @Key(value="form-information.png")
    public static Icon formInformation() {
        return ImageResource.tryGetImage("form-information.png");
    }

    @Key(value="form-error.png")
    public static Icon formError() {
        return ImageResource.tryGetImage("form-error.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            ImageResource.tryGetImage("initStateRed.png");
            ImageResource.tryGetImage("form-warning.png");
            ImageResource.tryGetImage("check_off.png");
            ImageResource.tryGetImage("initStateGreen.png");
            ImageResource.tryGetImage("loading_sprite.png");
            ImageResource.tryGetImage("emergency_stop_symbol.png");
            ImageResource.tryGetImage("initGray.png");
            ImageResource.tryGetImage("initStateBlue.png");
            ImageResource.tryGetImage("check_ok.png");
            ImageResource.tryGetImage("information_icon.png");
            ImageResource.tryGetImage("brakePinFailure.png");
            ImageResource.tryGetImage("check_pending.png");
            ImageResource.tryGetImage("check_idle.png");
            ImageResource.tryGetImage("initWhite.png");
            ImageResource.tryGetImage("initStateYellow.png");
            ImageResource.tryGetImage("form-information.png");
            ImageResource.tryGetImage("form-error.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

