/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.ur.polyscope.initializerobot.impl.internal.Animation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class AnimatedImagePanel
extends JPanel
implements Animation {
    private int animationDelay = 60;
    private final List<BufferedImage> animation = new ArrayList<BufferedImage>();
    private BufferedImage icon;
    private boolean isRunning;

    public AnimatedImagePanel(Icon image, int iconWidth, int iconHeight) {
        this((BufferedImage)((ImageIcon)image).getImage(), iconWidth, iconHeight);
    }

    private AnimatedImagePanel(BufferedImage image, int iconWidth, int iconHeight) {
        for (int y = 0; y < image.getHeight(); y += iconHeight) {
            for (int x = 0; x < image.getWidth(); x += iconWidth) {
                BufferedImage chunk = new BufferedImage(iconWidth, iconHeight, image.getType());
                Graphics2D g2d = chunk.createGraphics();
                g2d.drawImage(image, 0, 0, iconWidth, iconHeight, x, y, x + iconWidth, y + iconHeight, null);
                g2d.dispose();
                this.animation.add(chunk);
            }
        }
        this.icon = this.animation.get(0);
        this.setPreferredSize(new Dimension(iconWidth, iconHeight));
        this.setVisible(true);
    }

    @Override
    public void start() {
        this.isRunning = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                int sequence = 1;
                while (AnimatedImagePanel.this.isRunning) {
                    try {
                        Thread.sleep(AnimatedImagePanel.this.animationDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AnimatedImagePanel.this.icon = (BufferedImage)AnimatedImagePanel.this.animation.get(sequence);
                    AnimatedImagePanel.this.repaint();
                    if ((sequence = (sequence + 1) % AnimatedImagePanel.this.animation.size()) != 0) continue;
                    ++sequence;
                }
                AnimatedImagePanel.this.icon = (BufferedImage)AnimatedImagePanel.this.animation.get(0);
                AnimatedImagePanel.this.repaint();
            }
        }).start();
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.icon, 0, 0, null);
    }
}

