/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.google.inject.Inject;
import com.ur.polyscope.initializerobot.impl.InitializeRobotPresenter;
import com.ur.polyscope.initializerobot.impl.internal.controller.SystemControl;
import com.ur.swing.FlipManager;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.view.constants.dev.SafetyMode;
import java.awt.event.ActionEvent;
import javax.inject.Singleton;
import javax.swing.Action;

@ExtensionPoint(value="InitializeRobot")
@Singleton
public class ProtectiveStopAndRecoveryInitRobotPresenter
implements InitializeRobotPresenter,
Menu {
    private FlipManager flipManager;
    private final SystemControl systemControl;
    private Action recoveryContribution;
    private Action validateJointIDs;

    @Inject
    public ProtectiveStopAndRecoveryInitRobotPresenter(SystemControl systemControl) {
        this.systemControl = systemControl;
    }

    public void setFlipManager(FlipManager flipManager) {
        this.flipManager = flipManager;
    }

    @Override
    public void doAction(InitializeRobotPresenter.UserAction userAction) {
        if (userAction == InitializeRobotPresenter.UserAction.ACTION_UNLOCK_PROTECTIVE_STOP) {
            this.systemControl.sendUnlockProtectiveStop();
        }
        if (userAction == InitializeRobotPresenter.UserAction.ACTION_JUMP_TO_RECOVERY_TAB) {
            this.recoveryContribution.actionPerformed(new ActionEvent(this.flipManager, (int)System.currentTimeMillis(), SafetyMode.RECOVERY.name()));
        }
        if (userAction == InitializeRobotPresenter.UserAction.ACTION_JUMP_TO_VALIDATE_JOINTS_TAB) {
            this.validateJointIDs.actionPerformed(new ActionEvent(this.flipManager, (int)System.currentTimeMillis(), SafetyMode.VALIDATE_JOINT_ID.name()));
        }
    }

    public void addMenuItem(MenuExtension.MenuContribution menuContribution) {
        if (SafetyMode.RECOVERY.name().equalsIgnoreCase(menuContribution.getCategory())) {
            this.recoveryContribution = menuContribution.contribution;
        }
        if (SafetyMode.VALIDATE_JOINT_ID.name().equalsIgnoreCase(menuContribution.getCategory())) {
            this.validateJointIDs = menuContribution.contribution;
        }
    }
}

