/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.ur.log.logentry.robotmessage.InitializationMode;
import com.ur.polyscope.initializerobot.impl.InitializeRobotPresenter;
import com.ur.polyscope.initializerobot.impl.i18n.TextResource;
import com.ur.polyscope.initializerobot.impl.images.ImageResource;
import com.ur.polyscope.initializerobot.impl.internal.LedIcon;
import com.ur.polyscope.initializerobot.impl.internal.RobotInitializationLedIcon;
import com.ur.polyscope.initializerobot.impl.internal.RobotInitializationPanelDelegate;
import com.ur.polyscope.initializerobot.impl.internal.RobotInitializationPresenter;
import com.ur.polyscope.initializerobot.impl.internal.RobotStatusPanel;
import com.ur.polyscope.initializerobot.impl.internal.SetOfPresenters;
import com.ur.polyscope.initializerobot.impl.safebrake.BrakePinFailureScreen;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.safety.SafetySetupErrorListener;
import com.ur.polyscope.security.KickToScreen;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.ComponentView;
import com.ur.swing.FlipManager;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.card.EnterExitCard;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.InformationMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.g5.DialogBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

@ExtensionPoint(value="InitializeRobot")
@Singleton
public class RobotInitializationPanelDelegateImpl
extends CardPanel
implements RobotInitializationPanelDelegate,
RobotStatusPanel.RobotStatusButton,
ComponentView {
    private static final Map<InitializeRobotPresenter.UserAction, String> ACTION_STRINGS = new EnumMap<InitializeRobotPresenter.UserAction, String>(InitializeRobotPresenter.UserAction.class);
    private static final Icon INFO_LABEL_ICON = ImageResource.formInformation();
    private static final Icon WARNING_LABEL_ICON = ImageResource.formWarning();
    private static final Icon ERROR_LABEL_ICON = ImageResource.formError();
    private static final Dimension ROBOT_STATE_LABEL_SIZE = new Dimension(400, 24);
    private static final Dimension ON_BUTTON_SIZE = new Dimension(450, 40);
    private static final Dimension OFF_BUTTON_SIZE = new Dimension(210, 40);
    private static final Dimension OK_OR_EXIT_BUTTON_SIZE = new Dimension(230, 40);
    private static final int DEFAULT_ICON_TEXT_GAP = 17;
    private boolean jointsIdVerificationDialogShow = true;
    private final Font valueLabelFont;
    private final Font largeButtonFont;
    private final ArrayList<EnterExitCard> enterExitContributions = new ArrayList();
    private final ViewContext context;
    private final SetOfPresenters presenters;
    private final TextResource textResource;
    private final JComponent[] footerContributions = new JComponent[5];
    private final MessageDialogCreator dialogCreator;
    private final LedIcon ledIcon;
    private final KickToScreen kickToScreen;
    private final BrakePinFailureScreen brakePinFailureScreen;
    private InitializeRobotPresenter.UserAction currentOnButtonAction = InitializeRobotPresenter.UserAction.NO_ACTION;
    private JLabel robotStateLabel;
    private JButton onButton;
    private JButton offButton;
    private JButton brakeFailureOffButton;
    private JButton brakeFailureInfoButton;
    private JButton okOrExitButton;
    private JPanel footer;
    private RobotStatusPanel robotStatusPanel;

    @Inject
    public RobotInitializationPanelDelegateImpl(RobotInitializationPresenter presenter, Set<InitializeRobotPresenter> presenters, ViewContext context, KickToScreen kickToScreen, BrakePinFailureScreen brakePinFailureScreen) {
        this.brakePinFailureScreen = brakePinFailureScreen;
        this.presenters = new SetOfPresenters(presenter, presenters);
        this.context = context;
        this.textResource = (TextResource)context.getTextResource(TextResource.class);
        this.enterExitContributions.add(presenter);
        this.dialogCreator = context.getDialogCreator();
        this.kickToScreen = kickToScreen;
        this.ledIcon = new RobotInitializationLedIcon();
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_START_CONTROLLER, this.textResource.startController());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_RESTART_CONTROLLER, this.textResource.restartController());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_POWER_ON, this.textResource.ON());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF, this.textResource.OFF());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_START, this.textResource.START());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_UNLOCK_PROTECTIVE_STOP, this.textResource.unlockProtectiveStop());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_JUMP_TO_RECOVERY_TAB, this.textResource.goToRecoveryMode());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_JUMP_TO_VALIDATE_JOINTS_TAB, this.textResource.TestJoints());
        ACTION_STRINGS.put(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF_BRAKE_FAILURE, this.textResource.OFF());
        presenter.setView(this);
        URFontFactory fontFactory = context.getFontFactory();
        this.valueLabelFont = fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE);
        this.largeButtonFont = fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE);
        this.initGUI();
    }

    @Override
    public void setFlipManager(FlipManager flipManager) {
        super.setFlipManager(flipManager);
        this.presenters.setFlipManager(flipManager);
    }

    public void enter(Object o) {
        super.enter(o);
        EventNotificationService.notify(VetoListener.class, listener -> listener.veto(RobotInitializationPanelDelegateImpl.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        this.robotStatusPanel.enter(o);
        for (EnterExitCard each : this.enterExitContributions) {
            each.enter(o);
        }
    }

    public Object exit() {
        for (EnterExitCard each : this.enterExitContributions) {
            each.exit();
        }
        super.exit();
        this.robotStatusPanel.exit();
        EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(RobotInitializationPanelDelegateImpl.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        return null;
    }

    @Override
    public void updateState(RobotInitializationPresenter.PresentationState state) {
        SwingUtil.invokeLater(() -> {
            this.robotStatusPanel.updateState(state);
            this.getRobotStateLabel().setText(state.getRobotStateString());
            this.getOnButton().setText(ACTION_STRINGS.get((Object)state.getOnAction()));
            boolean hasErrorInSafetySetup = this.hasErrorInSafetySetup();
            this.getOnButton().setEnabled(!hasErrorInSafetySetup && state.isEnabled(state.getOnAction()));
            this.currentOnButtonAction = state.getOnAction();
            this.getOffButton().setEnabled(state.isEnabled(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF));
            this.getBrakeFailureOffButton().setEnabled(state.isEnabled(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF_BRAKE_FAILURE));
            this.updateMessageDisplay(state, this.robotStatusPanel.getMessageDisplay(), hasErrorInSafetySetup);
            this.updateMessageDisplay(state, this.robotStatusPanel.getBrakePinMessageDisplay(), hasErrorInSafetySetup);
            this.robotStatusPanel.repaint();
        });
    }

    private void updateMessageDisplay(RobotInitializationPresenter.PresentationState state, JLabel messageDisplay, boolean hasErrorInSafetySetup) {
        if (hasErrorInSafetySetup) {
            messageDisplay.setText(this.textResource.errorInSafetySettings());
            messageDisplay.setIcon(ERROR_LABEL_ICON);
        } else if (state.getInitializationMode().equals((Object)InitializationMode.BRAKE_FAILURE)) {
            messageDisplay.setText(this.textResource.warningBrakeFailure());
            messageDisplay.setIcon(WARNING_LABEL_ICON);
        } else if (state.getMessage() == RobotInitializationPresenter.PresentationStateMessage.MOUNTING_ERROR) {
            messageDisplay.setText(this.textResource.errorMountingDoesNotMatchAccelerometerData());
            messageDisplay.setIcon(ERROR_LABEL_ICON);
        } else if (state.getMessage() == RobotInitializationPresenter.PresentationStateMessage.RELEASE_BRAKES_WARNING) {
            messageDisplay.setText(this.textResource.warningStayClearOfRobotWhenStarting());
            messageDisplay.setIcon(WARNING_LABEL_ICON);
        } else if (state.isEnabled(InitializeRobotPresenter.UserAction.ACTION_POWER_ON)) {
            messageDisplay.setText(this.textResource.verifyInstallationAndPayload());
            messageDisplay.setIcon(null);
        } else {
            messageDisplay.setText("");
            messageDisplay.setIcon(null);
        }
        messageDisplay.setName("");
    }

    private boolean hasErrorInSafetySetup() {
        AtomicBoolean hasErrorsInSafetySetup = new AtomicBoolean(false);
        EventNotificationService.notify(SafetySetupErrorListener.class, safetySetupErrorListener -> hasErrorsInSafetySetup.set(safetySetupErrorListener.hasErrorsInSafetySetup()));
        return hasErrorsInSafetySetup.get();
    }

    @Override
    public void modifyForJointsVerification(RobotMode robotMode, SafetyMode safetyMode) {
        if (robotMode == RobotMode.RUNNING && safetyMode == SafetyMode.VALIDATE_JOINT_ID) {
            if (this.jointsIdVerificationDialogShow) {
                this.dialogCreator.showMessageDialog((DialogMessage)new InformationMessage(this.textResource.jointsVerification(), this.textResource.jointsVerificationMessage(), this.textResource.jointsVerificationAction()), MessageDialogType.MESSAGE, null);
                this.jointsIdVerificationDialogShow = false;
            }
        } else if (robotMode == RobotMode.POWER_OFF) {
            this.jointsIdVerificationDialogShow = true;
        }
    }

    public void setHeader(JComponent jComponent) {
    }

    public void setFooter(JComponent footContribution) {
        Integer index;
        if (footContribution instanceof EnterExitCard) {
            this.enterExitContributions.add((EnterExitCard)footContribution);
        }
        if ((index = (Integer)footContribution.getClientProperty("placement")) != null) {
            this.footerContributions[index.intValue()] = footContribution;
        } else {
            this.footerContributions[3] = footContribution;
        }
        this.footer.removeAll();
        for (JComponent each : this.footerContributions) {
            if (each == null) continue;
            this.footer.add(each);
        }
    }

    private void initGUI() {
        this.setName("RobotInitializationPanel");
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder((Border)new DialogBorder(this.textResource.initializationTitle(), G5LookAndFeel.SELECTED_HEADER_BACKGROUND));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.robotStatusPanel = new RobotStatusPanel(this.context, this);
        this.footer = new JPanel(new GridLayout(1, 0, 5, 0));
        this.footer.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        panel.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        panel.add((Component)this.robotStatusPanel, "North");
        panel.add((Component)this.footer, "Center");
        JPanel exitButtonPanel = new JPanel(new FlowLayout(0));
        exitButtonPanel.add(this.getOkOrExitButton());
        panel.add((Component)exitButtonPanel, "South");
        this.add(panel, "Center");
    }

    private JLabel getRobotStateLabel() {
        if (this.robotStateLabel == null) {
            this.robotStateLabel = new JLabel("");
            this.robotStateLabel.setMinimumSize(ROBOT_STATE_LABEL_SIZE);
            this.robotStateLabel.setMaximumSize(ROBOT_STATE_LABEL_SIZE);
            this.robotStateLabel.setPreferredSize(ROBOT_STATE_LABEL_SIZE);
            this.robotStateLabel.setFont(this.valueLabelFont);
            this.robotStateLabel.setName("status.RobotInitializationPanel");
        }
        return this.robotStateLabel;
    }

    @Override
    public JButton getOnButton() {
        if (this.onButton == null) {
            String text = ACTION_STRINGS.get((Object)InitializeRobotPresenter.UserAction.ACTION_POWER_ON);
            ActionListener actionListener = e -> this.presenters.doAction(this.currentOnButtonAction);
            Icon icon = this.ledIcon.getIndicatorOK();
            this.onButton = this.createPositiveButton(text, actionListener, icon, "onButton.RobotInitializationPanel");
        }
        return this.onButton;
    }

    @Override
    public JButton getOffButton() {
        if (this.offButton == null) {
            String text = ACTION_STRINGS.get((Object)InitializeRobotPresenter.UserAction.ACTION_POWER_OFF);
            ActionListener actionListener = e -> this.presenters.doAction(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF);
            Icon icon = this.ledIcon.getIndicatorError();
            this.offButton = this.createNegativeButton(text, actionListener, icon, "offButton.RobotInitializationPanel");
        }
        return this.offButton;
    }

    @Override
    public JButton getBrakeFailureInfoButton() {
        if (this.brakeFailureInfoButton == null) {
            String text = this.textResource.brakeFailureInfo();
            ActionListener actionListener = e -> this.brakePinFailureScreen.showSplash(true);
            this.brakeFailureInfoButton = this.createPositiveButton(text, actionListener, INFO_LABEL_ICON, "brakeFailureInfoButton.RobotInitializationPanel");
        }
        return this.brakeFailureInfoButton;
    }

    @Override
    public JButton getBrakeFailureOffButton() {
        if (this.brakeFailureOffButton == null) {
            String text = ACTION_STRINGS.get((Object)InitializeRobotPresenter.UserAction.ACTION_POWER_OFF_BRAKE_FAILURE);
            ActionListener actionListener = e -> this.presenters.doAction(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF_BRAKE_FAILURE);
            this.brakeFailureOffButton = this.createNegativeButton(text, actionListener, WARNING_LABEL_ICON, "brakeFailureOffButton.RobotInitializationPanel");
        }
        return this.brakeFailureOffButton;
    }

    private JButton createPositiveButton(String text, ActionListener actionListener, Icon icon, String buttonName) {
        return this.createButton(text, actionListener, icon, buttonName, ON_BUTTON_SIZE);
    }

    private JButton createNegativeButton(String text, ActionListener actionListener, Icon icon, String buttonName) {
        return this.createButton(text, actionListener, icon, buttonName, OFF_BUTTON_SIZE);
    }

    private JButton createButton(String text, ActionListener actionListener, Icon icon, String buttonName, Dimension buttonDimension) {
        JButton positiveButton = new JButton(text);
        positiveButton.addActionListener(actionListener);
        positiveButton.setFont(this.largeButtonFont);
        positiveButton.setIconTextGap(17);
        positiveButton.setIcon(icon);
        positiveButton.setMinimumSize(buttonDimension);
        positiveButton.setMaximumSize(buttonDimension);
        positiveButton.setPreferredSize(buttonDimension);
        positiveButton.setName(buttonName);
        positiveButton.setFocusPainted(false);
        return positiveButton;
    }

    private JButton getOkOrExitButton() {
        if (this.okOrExitButton == null) {
            this.okOrExitButton = this.context.createWidgetFactory().createButton((Action)((Object)new ExitAction(this.textResource, this.kickToScreen)));
            this.okOrExitButton.setMinimumSize(OK_OR_EXIT_BUTTON_SIZE);
            this.okOrExitButton.setMaximumSize(OK_OR_EXIT_BUTTON_SIZE);
            this.okOrExitButton.setPreferredSize(OK_OR_EXIT_BUTTON_SIZE);
        }
        return this.okOrExitButton;
    }

    public String toString() {
        return RobotInitializationPanelDelegateImpl.class.getName();
    }

    private class ExitAction
    extends AbstractActionDefinition {
        private final KickToScreen kickToScreen;

        ExitAction(TextResource textResource, KickToScreen kickToScreen) {
            this.kickToScreen = kickToScreen;
            this.putValue("Name", textResource.Exit());
            this.putValue("Function", ActionDefinition.Function.PRIMARY);
            this.putValue("InternalName", "okOrExitButton.RobotInitializationPanel");
        }

        public void actionPerformed(ActionEvent e) {
            if (RobotInitializationPanelDelegateImpl.this.flipManager.isCardStackEmpty()) {
                SwingUtil.invokeAndWait(() -> ((KickToScreen)this.kickToScreen).kickToRunScreen());
            }
            RobotInitializationPanelDelegateImpl.this.navigateBack();
        }
    }
}

