/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.InitializationMode;
import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.initializerobot.impl.InitializeRobotPresenter;
import com.ur.polyscope.initializerobot.impl.RobotInitializationView;
import com.ur.polyscope.initializerobot.impl.internal.controller.ControllerRPC;
import com.ur.polyscope.initializerobot.impl.internal.controller.SystemControl;
import com.ur.swing.FlipManager;
import com.ur.swing.card.EnterExitCard;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;

public class RobotInitializationPresenter
implements RobotStateListener,
InitializeRobotPresenter,
EnterExitCard {
    public static final byte HMC_CALL_WAIT = 4;
    private final EventManager eventManager;
    private final SystemControl systemControl;
    private final ControllerRPC controllerRPC;
    protected RobotInitializationView view;
    protected FlipManager flipManager;
    private RobotMode oldRobotMode;
    private boolean payloadUpdatePending;
    private int payloadUpdateWaitSteps;
    private double lastActivePayload;
    private boolean mountingCorrect;
    private boolean mountingCorrectUpdatePending;
    private int mountingCorrectUpdateWaitSteps;
    private Thread fetchingPayloadThread;
    private Subscription robotStateSubscription = Subscription.NULL;

    @Inject
    public RobotInitializationPresenter(EventManager eventManager, SystemControl systemControl, ControllerRPC controllerRPC) {
        this.eventManager = eventManager;
        this.systemControl = systemControl;
        this.controllerRPC = controllerRPC;
    }

    public void setView(RobotInitializationView view) {
        this.view = view;
    }

    public void setFlipManager(FlipManager flipManager) {
        this.flipManager = flipManager;
    }

    public void enter(Object object) {
        this.payloadUpdatePending = true;
        this.payloadUpdateWaitSteps = 4;
        this.mountingCorrectUpdatePending = true;
        this.mountingCorrectUpdateWaitSteps = 4;
        this.robotStateSubscription = this.eventManager.addStrongListener(RobotStateListener.class, (Object)this);
        this.updateRobotState(RobotState.getLatestRobotState());
        this.systemControl.cancelArmSimulation();
    }

    public synchronized Object exit() {
        this.robotStateSubscription.dispose();
        this.robotStateSubscription = Subscription.NULL;
        this.view.updateState(new PresentationStateBuilder().build());
        return null;
    }

    public void updateRobotState(RobotState rs) {
        boolean breakRelease = RobotModes.isInBreakRelease((int[])rs.jointMode);
        this.updatePayloadValue(rs.robotMode);
        this.updateMountingCorrect(rs.robotMode);
        PresentationStateBuilder stateBuilder = new PresentationStateBuilder();
        this.updateRobotStateString(stateBuilder, rs.robotMode, rs.masterSafetyState, rs.jointMode);
        this.updateUserInputs(stateBuilder, rs.robotMode, rs.masterSafetyState, breakRelease);
        this.updateIsInitialized(stateBuilder, rs.robotMode, rs.masterSafetyState);
        this.updateView(stateBuilder.build());
        this.oldRobotMode = rs.robotMode;
    }

    private synchronized void updateView(PresentationState state) {
        if (this.robotStateSubscription != Subscription.NULL) {
            this.view.updateState(state);
        }
    }

    @Override
    public void doAction(InitializeRobotPresenter.UserAction action) {
        switch (action) {
            case ACTION_START_CONTROLLER: {
                this.systemControl.powerOnController();
                break;
            }
            case ACTION_RESTART_CONTROLLER: {
                this.systemControl.restartSCB();
                break;
            }
            case ACTION_POWER_OFF: {
                this.systemControl.powerOffArm();
                break;
            }
            case ACTION_POWER_ON: {
                this.systemControl.powerOnArm();
                break;
            }
            case ACTION_START: {
                this.systemControl.releaseBrakes();
                break;
            }
            case ACTION_POWER_OFF_BRAKE_FAILURE: {
                this.systemControl.powerOffArmBrakePin();
                break;
            }
        }
    }

    private void updatePayloadValue(RobotMode robotMode) {
        this.payloadUpdatePending |= robotMode != this.oldRobotMode;
        this.payloadUpdatePending |= this.lastActivePayload < 0.0;
        if (this.payloadUpdatePending && this.hasController(robotMode)) {
            if (this.payloadUpdateWaitSteps > 0) {
                --this.payloadUpdateWaitSteps;
            } else if (this.fetchingPayloadThread == null) {
                this.fetchingPayloadThread = new Thread(new FetchPayloadRunner());
                this.fetchingPayloadThread.start();
            }
        }
    }

    private boolean hasController(RobotMode robotMode) {
        return robotMode != RobotMode.NO_CONTROLLER;
    }

    private void updateMountingCorrect(RobotMode robotMode) {
        if (robotMode != this.oldRobotMode) {
            this.mountingCorrectUpdatePending = true;
            this.mountingCorrectUpdateWaitSteps = 4;
        }
        if (robotMode == RobotMode.IDLE) {
            if (this.mountingCorrectUpdateWaitSteps > 0) {
                --this.mountingCorrectUpdateWaitSteps;
            } else {
                this.mountingCorrect = this.controllerRPC.isRobotMountingCorrect();
                this.mountingCorrectUpdatePending = false;
                this.mountingCorrectUpdateWaitSteps = 4;
            }
        }
    }

    private void updateRobotStateString(PresentationStateBuilder stateBuilder, RobotMode robotMode, SafetyMode masterSafetyState, int[] jointMode) {
        stateBuilder.robotStateString(RobotModes.getRobotStateString((RobotMode)robotMode, (SafetyMode)masterSafetyState, (int[])jointMode), InitializationMode.transformToInitializationMode((RobotMode)robotMode, (SafetyMode)masterSafetyState, (int[])jointMode));
    }

    private void updateUserInputs(PresentationStateBuilder stateBuilder, RobotMode robotMode, SafetyMode masterSafetyState, boolean breakRelease) {
        if (robotMode == RobotMode.IDLE && !this.mountingCorrectUpdatePending) {
            if (this.mountingCorrect || breakRelease) {
                stateBuilder.message(PresentationStateMessage.RELEASE_BRAKES_WARNING);
            } else {
                stateBuilder.message(PresentationStateMessage.MOUNTING_ERROR);
            }
        }
        if (this.canPowerOff(robotMode)) {
            this.handleCanPowerOff(stateBuilder);
        }
        this.view.modifyForJointsVerification(robotMode, masterSafetyState);
        this.handleRobotMode(stateBuilder, robotMode, masterSafetyState, breakRelease);
    }

    private boolean canPowerOff(RobotMode robotMode) {
        return EqualsUtil.notEqualsOneOf((Object)robotMode, (Object[])new RobotMode[]{RobotMode.NO_CONTROLLER, RobotMode.DISCONNECTED, RobotMode.BOOTING, RobotMode.POWER_OFF});
    }

    private void handleCanPowerOff(PresentationStateBuilder stateBuilder) {
        stateBuilder.enableAction(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF);
        if (stateBuilder.initializationMode.equals((Object)InitializationMode.BRAKE_FAILURE)) {
            stateBuilder.enableAction(InitializeRobotPresenter.UserAction.ACTION_POWER_OFF_BRAKE_FAILURE);
        }
    }

    private void handleRobotMode(PresentationStateBuilder stateBuilder, RobotMode robotMode, SafetyMode masterSafetyState, boolean breakRelease) {
        SafetyModeCategory safetyModeCategory = SafetyModes.getSafetyModeCategory((SafetyMode)masterSafetyState);
        switch (robotMode) {
            case NO_CONTROLLER: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_START_CONTROLLER).enableNextOnAction();
                break;
            }
            case BACKDRIVE: 
            case CONFIRM_SAFETY: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.NO_ACTION);
                break;
            }
            case DISCONNECTED: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_RESTART_CONTROLLER).enableNextOnAction();
                break;
            }
            case BOOTING: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_POWER_ON);
                break;
            }
            case POWER_OFF: {
                this.handleRobotModepowerOff(stateBuilder, safetyModeCategory);
                break;
            }
            case POWER_ON: 
            case UPDATING: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_START);
                break;
            }
            case IDLE: {
                this.handleRobotModeIdle(stateBuilder, safetyModeCategory, breakRelease);
                break;
            }
            case RUNNING: {
                this.handleRobotModeRunning(stateBuilder, safetyModeCategory);
                break;
            }
            default: {
                Log.warning((String)("Unexpected robot mode: " + RobotModes.getString((RobotMode)robotMode)));
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_POWER_ON);
            }
        }
    }

    private void handleRobotModeRunning(PresentationStateBuilder stateBuilder, SafetyModeCategory masterSafetyState) {
        switch (masterSafetyState) {
            case PROTECTIVE_STOP: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_UNLOCK_PROTECTIVE_STOP).enableNextOnAction();
                break;
            }
            case RECOVERY: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_JUMP_TO_RECOVERY_TAB).enableNextOnAction();
                break;
            }
            case VALIDATE_JOINT_ID: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_JUMP_TO_VALIDATE_JOINTS_TAB).enableNextOnAction();
                break;
            }
            case NORMAL: 
            case REDUCED: 
            case SAFEGUARD_STOP: 
            case THREE_POSITION_ENABLING_STOP: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_START);
                break;
            }
            default: {
                Log.warning((String)("Unexpected combination of robot mode (" + RobotModes.getString((RobotMode)RobotMode.RUNNING) + ") and safety state (" + masterSafetyState.toString() + ")"));
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_POWER_ON);
            }
        }
    }

    private void handleRobotModeIdle(PresentationStateBuilder stateBuilder, SafetyModeCategory masterSafetyState, boolean breakRelease) {
        switch (masterSafetyState) {
            case SAFEGUARD_STOP: 
            case THREE_POSITION_ENABLING_STOP: 
            case EMERGENCY_STOP: 
            case WAITING_FOR_PARAMETERS: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_START);
                break;
            }
            default: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_START);
                if (!this.isMountingCorrectAndNoUpdatePendingAndNotBreakReleased(breakRelease)) break;
                stateBuilder.enableNextOnAction();
            }
        }
    }

    private boolean isMountingCorrectAndNoUpdatePendingAndNotBreakReleased(boolean breakRelease) {
        return this.mountingCorrect && !this.mountingCorrectUpdatePending && !this.payloadUpdatePending && !breakRelease;
    }

    private void handleRobotModepowerOff(PresentationStateBuilder stateBuilder, SafetyModeCategory masterSafetyState) {
        switch (masterSafetyState) {
            case FAULT: 
            case VIOLATION: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_RESTART_CONTROLLER).enableNextOnAction();
                break;
            }
            case EMERGENCY_STOP: 
            case BRAKE_FAILURE: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_POWER_ON);
                break;
            }
            default: {
                stateBuilder.onAction(InitializeRobotPresenter.UserAction.ACTION_POWER_ON).enableNextOnAction();
            }
        }
    }

    private void updateIsInitialized(PresentationStateBuilder stateBuilder, RobotMode robotMode, SafetyMode masterSafetyState) {
        stateBuilder.initialized(robotMode == RobotMode.RUNNING && EqualsUtil.equalsOneOf((Object)masterSafetyState, (Object[])new SafetyMode[]{SafetyMode.NORMAL, SafetyMode.REDUCED}));
    }

    private final class FetchPayloadRunner
    implements Runnable {
        private FetchPayloadRunner() {
        }

        @Override
        public void run() {
            try {
                RobotInitializationPresenter.this.lastActivePayload = RobotInitializationPresenter.this.controllerRPC.getPayloadMass();
                if (RobotInitializationPresenter.this.lastActivePayload >= 0.0) {
                    RobotInitializationPresenter.this.payloadUpdatePending = false;
                    RobotInitializationPresenter.this.payloadUpdateWaitSteps = 4;
                }
            }
            finally {
                RobotInitializationPresenter.this.fetchingPayloadThread = null;
            }
        }
    }

    public static class PresentationStateBuilder {
        private String robotStateString = "";
        private InitializationMode initializationMode;
        private PresentationStateMessage message = PresentationStateMessage.NONE;
        private InitializeRobotPresenter.UserAction onAction = InitializeRobotPresenter.UserAction.NO_ACTION;
        private Set<InitializeRobotPresenter.UserAction> enabledActions = EnumSet.noneOf(InitializeRobotPresenter.UserAction.class);
        private boolean initialized = false;

        public PresentationStateBuilder robotStateString(String robotStateString, InitializationMode initializationMode) {
            this.robotStateString = robotStateString;
            this.initializationMode = initializationMode;
            return this;
        }

        public PresentationStateBuilder message(PresentationStateMessage message) {
            this.message = message;
            return this;
        }

        public PresentationStateBuilder onAction(InitializeRobotPresenter.UserAction onAction) {
            this.onAction = onAction;
            return this;
        }

        public PresentationStateBuilder enableAction(InitializeRobotPresenter.UserAction action) {
            this.enabledActions.add(action);
            return this;
        }

        public PresentationStateBuilder initialized(boolean initialized) {
            this.initialized = initialized;
            return this;
        }

        public PresentationState build() {
            return new PresentationState(this.robotStateString, this.message, this.onAction, this.enabledActions, this.initialized, this.initializationMode);
        }

        public void enableNextOnAction() {
            this.enableAction(this.onAction);
        }
    }

    public static class PresentationState {
        private final String robotStateString;
        private final PresentationStateMessage message;
        private final InitializeRobotPresenter.UserAction onAction;
        private final Set<InitializeRobotPresenter.UserAction> enabledActions;
        private final boolean initialized;
        private final InitializationMode initializationMode;

        public PresentationState(PresentationStateMessage message, InitializeRobotPresenter.UserAction onAction, boolean isActionEnabled, boolean initialized) {
            this("", message, onAction, isActionEnabled ? Collections.singleton(onAction) : Collections.emptySet(), initialized, InitializationMode.NONE);
        }

        public PresentationState(String robotStateString, PresentationStateMessage message, InitializeRobotPresenter.UserAction onAction, Set<InitializeRobotPresenter.UserAction> enabledActions, boolean initialized, InitializationMode initializationMode) {
            this.robotStateString = robotStateString;
            this.message = message;
            this.onAction = onAction;
            this.enabledActions = Collections.unmodifiableSet(enabledActions);
            this.initialized = initialized;
            this.initializationMode = initializationMode;
        }

        public String getRobotStateString() {
            return this.robotStateString;
        }

        public PresentationStateMessage getMessage() {
            return this.message;
        }

        public InitializeRobotPresenter.UserAction getOnAction() {
            return this.onAction;
        }

        public boolean isEnabled(InitializeRobotPresenter.UserAction action) {
            return this.enabledActions.contains((Object)action);
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public InitializationMode getInitializationMode() {
            return this.initializationMode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public String toString() {
            String result = "";
            result = result + "state: '" + this.robotStateString + "', ";
            result = result + "message: " + this.message.name() + ", ";
            result = result + "onAction: " + this.onAction.name() + " (" + (this.isEnabled(this.onAction) ? "enabled" : "disabled") + "), ";
            result = result + "enabled: " + Arrays.toString(this.enabledActions.toArray()) + ", ";
            result = result + "initialized: " + this.initialized + ", ";
            result = result + "initializationMode: " + this.initializationMode;
            return result;
        }
    }

    public static enum PresentationStateMessage {
        NONE,
        RELEASE_BRAKES_WARNING,
        MOUNTING_ERROR;

    }
}

