/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.initializerobot.impl.i18n.TextResource;
import com.ur.polyscope.initializerobot.impl.internal.footercontribution.InitializeRobotAction;
import com.ur.polyscope.program.monitor.ProgramInfo;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.extensible.AddLayer;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Layer;
import com.ur.swing.extensible.MenuExtension;
import com.ur.view.constants.dev.JointMode;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

@Extension(value="Footer")
@ExtensionPoint(value="InitializeRobotLabel")
@Singleton
public class RobotStatusLabel
extends JPanel
implements MenuExtension,
AddLayer {
    private static final Dimension MINIMUM_PANEL_SIZE = new Dimension(100, 65);
    private static final Dimension MAXIMUM_PANEL_SIZE = new Dimension(850, 65);
    private final ViewContext viewContext;
    private RobotMode robotMode = RobotMode.NO_CONTROLLER;
    private SafetyMode safetyMode = SafetyMode.NORMAL;
    private ControlMode controlMode = null;
    private ProgramState programState = null;
    private JointMode[] jointModes = new JointMode[]{JointMode.POWER_OFF, JointMode.POWER_OFF, JointMode.POWER_OFF, JointMode.POWER_OFF, JointMode.POWER_OFF, JointMode.POWER_OFF};
    private JLabel statusLabel;
    private InitializeRobotAction initializeRobotAction;
    private Set<Object> vetoes = new HashSet<Object>();

    @Inject
    public RobotStatusLabel(InitializeRobotAction initializeRobotAction, @Source(value=Arm.class) Recipe<Arm> armRecipe, @Source(value=com.ur.monitor.model.RobotMode.class) Recipe<com.ur.monitor.model.RobotMode> robotModeRecipe, @Source(value=ProgramInfo.class) Recipe<ProgramInfo> programInfoRecipe, ViewContext viewContext) {
        this.initializeRobotAction = initializeRobotAction;
        this.viewContext = viewContext;
        this.initComponents();
        armRecipe.executeOnUIThread().subscribe((Consumer)new Consumer<Arm>(){

            public void accept(Arm arm) {
                for (int i = 0; i < arm.getJoints().size(); ++i) {
                    ((RobotStatusLabel)RobotStatusLabel.this).jointModes[i] = arm.getJoint(JointType.fromJointNumber((int)i)).getMode();
                }
                RobotStatusLabel.this.updateLabel();
            }
        });
        robotModeRecipe.executeOnUIThread().subscribe((Consumer)new Consumer<com.ur.monitor.model.RobotMode>(){

            public void accept(com.ur.monitor.model.RobotMode newValue) {
                RobotMode newRobotMode = newValue.getRobotMode() == null ? RobotMode.NO_CONTROLLER : newValue.getRobotMode();
                SafetyMode newSafetyMode = newValue.getSafetyMode() == null ? SafetyMode.NORMAL : newValue.getSafetyMode();
                ControlMode newControlMode = newValue.getControlMode();
                if (newRobotMode != RobotStatusLabel.this.robotMode || newSafetyMode != RobotStatusLabel.this.safetyMode || newControlMode != RobotStatusLabel.this.controlMode) {
                    RobotStatusLabel.this.robotMode = newRobotMode;
                    RobotStatusLabel.this.safetyMode = newSafetyMode;
                    RobotStatusLabel.this.controlMode = newControlMode;
                    RobotStatusLabel.this.updateLabel();
                }
            }
        });
        programInfoRecipe.executeOnUIThread().subscribe((Consumer)new Consumer<ProgramInfo>(){

            public void accept(ProgramInfo programInfo) {
                ProgramState newProgramState = programInfo.programState;
                if (RobotStatusLabel.this.programState != newProgramState) {
                    RobotStatusLabel.this.programState = newProgramState;
                    RobotStatusLabel.this.updateLabel();
                }
            }
        });
    }

    private void initComponents() {
        this.statusLabel = new JLabel();
        this.statusLabel.putClientProperty("vetoes", this.vetoes);
        this.statusLabel.setForeground(UIManager.getColor("Footer.foreground"));
        this.statusLabel.setFont(this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.SMALL));
        this.statusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (RobotStatusLabel.this.vetoes.isEmpty()) {
                    RobotStatusLabel.this.initializeRobotAction.actionPerformed(new ActionEvent(this, e.getID(), "click"));
                }
            }
        });
        this.setLayout(new GridLayout(1, 1));
        this.makeLabelExpandOrCompressWithFreeSpaceInFooter();
        this.add(this.statusLabel);
    }

    private void makeLabelExpandOrCompressWithFreeSpaceInFooter() {
        this.setMinimumSize(MINIMUM_PANEL_SIZE);
        this.setPreferredSize(MAXIMUM_PANEL_SIZE);
        this.setMaximumSize(MAXIMUM_PANEL_SIZE);
    }

    private String getProgramStateText(ProgramState programState) {
        switch (programState) {
            case PLAYING: {
                return ((TextResource)this.viewContext.getTextResource(TextResource.class)).running();
            }
            case PAUSED: {
                return ((TextResource)this.viewContext.getTextResource(TextResource.class)).paused();
            }
        }
        return "";
    }

    private int[] convertJointModes() {
        int[] iJointModes = new int[this.jointModes.length];
        for (int i = 0; i < iJointModes.length; ++i) {
            iJointModes[i] = this.jointModes[i].getId();
        }
        return iJointModes;
    }

    private void updateLabel() {
        if (this.vetoes.isEmpty()) {
            if (this.controlMode == ControlMode.TEACH) {
                this.statusLabel.setText(((TextResource)this.viewContext.getTextResource(TextResource.class)).freedrive());
            } else if (this.programState == ProgramState.PLAYING && this.safetyMode == SafetyMode.REDUCED) {
                this.statusLabel.setText(this.getProgramStateText(this.programState) + " (" + RobotModes.getRobotStateString((RobotMode)this.robotMode, (SafetyMode)this.safetyMode, (int[])this.convertJointModes()) + ")");
            } else if (this.programState == ProgramState.PLAYING || this.programState == ProgramState.PAUSED && this.safetyMode == SafetyMode.NORMAL) {
                this.statusLabel.setText(this.getProgramStateText(this.programState));
            } else {
                this.statusLabel.setText(RobotModes.getRobotStateString((RobotMode)this.robotMode, (SafetyMode)this.safetyMode, (int[])this.convertJointModes()));
            }
        }
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateMiddle((MenuExtension.MenuContribution)new MenuExtension.ComponentMenuContribution((JComponent)this, "LEFT", MenuExtension.MenuContribution.Restrictions.NO_RESTRICTION));
    }

    public void addLayer(Layer layer) {
        this.statusLabel = (JLabel)layer.decorate((JComponent)this.statusLabel);
    }
}

