/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.polyscope.initializerobot.impl.internal.LedIcon;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import javax.swing.Icon;

public class RobotStatusLedHelper {
    private LedIcon ledIcon;

    public RobotStatusLedHelper(LedIcon ledIcon) {
        this.ledIcon = ledIcon;
    }

    public Icon getIndicatorType(SafetyMode safetyMode, ControlMode controlMode) {
        if (controlMode == ControlMode.TEACH) {
            return this.ledIcon.getIndicatorFreedrive();
        }
        return this.getIndicatorType(safetyMode);
    }

    private Icon getIndicatorType(SafetyMode mode) {
        switch (SafetyModes.getSafetyModeCategory((SafetyMode)mode)) {
            case NORMAL: 
            case REDUCED: 
            case UNDEFINED_SAFETY_MODE: {
                return this.ledIcon.getIndicatorOK();
            }
            case SAFEGUARD_STOP: 
            case THREE_POSITION_ENABLING_STOP: 
            case PROTECTIVE_STOP: 
            case RECOVERY: 
            case VALIDATE_JOINT_ID: 
            case WAITING_FOR_PARAMETERS: {
                return this.ledIcon.getIndicatorWarning();
            }
            case FAULT: 
            case VIOLATION: 
            case EMERGENCY_STOP: 
            case BRAKE_FAILURE: {
                return this.ledIcon.getIndicatorError();
            }
        }
        throw new IllegalArgumentException("Unknown safety mode");
    }
}

