/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.ur.log.logentry.robotmessage.InitializationMode;
import com.ur.polyscope.initializerobot.impl.i18n.TextResource;
import com.ur.polyscope.initializerobot.impl.internal.RobotInitializationPresenter;
import com.ur.polyscope.initializerobot.impl.internal.RobotStatusPanelWithState;
import com.ur.polyscope.initializerobot.impl.internal.VisualInitializationPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.card.EnterExitCard;
import java.awt.CardLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RobotStatusPanel
extends JPanel
implements EnterExitCard {
    private final ViewContext viewContext;
    private final TextResource textResource;
    private final RobotStatusButton robotStatusButton;
    private VisualInitializationPanel initializationFlowPanel;
    private VisualInitializationPanel brakePinInitializationFlowPanel;
    private JLabel messageDisplay;
    private JLabel brakePinMessageDisplay;
    private RobotStatusPanelWithState normalStatePanel;
    private RobotStatusPanelWithState brakeFailureStatePanel;

    public RobotStatusPanel(ViewContext viewContext, RobotStatusButton robotStatusButton) {
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.robotStatusButton = robotStatusButton;
        this.initializeComponents();
    }

    public JLabel getMessageDisplay() {
        return this.messageDisplay;
    }

    public JLabel getBrakePinMessageDisplay() {
        return this.brakePinMessageDisplay;
    }

    public void updateState(RobotInitializationPresenter.PresentationState state) {
        this.initializationFlowPanel.update(state);
        this.brakePinInitializationFlowPanel.update(state);
        this.updateInitializationMode(state.getInitializationMode());
    }

    private void updateInitializationMode(InitializationMode initializationMode) {
        if (initializationMode.equals((Object)InitializationMode.BRAKE_FAILURE)) {
            this.brakeFailureStatePanel.flipToState();
            return;
        }
        this.normalStatePanel.flipToState();
    }

    private void initializeComponents() {
        this.setLayout(new CardLayout());
        this.initializeInitializationFlowPanels();
        this.initializeRobotStatusPanelState();
    }

    private void initializeInitializationFlowPanels() {
        this.initializationFlowPanel = new VisualInitializationPanel(this.textResource, this.viewContext.getFontFactory());
        this.brakePinInitializationFlowPanel = new VisualInitializationPanel(this.textResource, this.viewContext.getFontFactory());
    }

    private void initializeRobotStatusPanelState() {
        this.initializeNormalPanelState();
        this.normalStatePanel.addToPanel(this);
        this.initializeBrakeFailurePanelState();
        this.brakeFailureStatePanel.addToPanel(this);
    }

    private void initializeNormalPanelState() {
        this.normalStatePanel = new RobotStatusPanelWithState("normal"){

            @Override
            public JPanel createStatusPanel() {
                return RobotStatusPanel.this.createInitializePanel(RobotStatusPanel.this.initializationFlowPanel, RobotStatusPanel.this.robotStatusButton.getOnButton(), RobotStatusPanel.this.robotStatusButton.getOffButton(), RobotStatusPanel.this.getMessageDisplay(RobotStatusPanel.this.viewContext.getFontFactory()));
            }
        };
    }

    private void initializeBrakeFailurePanelState() {
        this.brakeFailureStatePanel = new RobotStatusPanelWithState("brake_failure"){

            @Override
            public JPanel createStatusPanel() {
                return RobotStatusPanel.this.createInitializePanel(RobotStatusPanel.this.brakePinInitializationFlowPanel, RobotStatusPanel.this.robotStatusButton.getBrakeFailureInfoButton(), RobotStatusPanel.this.robotStatusButton.getBrakeFailureOffButton(), RobotStatusPanel.this.getBrakePinMessageDisplay(RobotStatusPanel.this.viewContext.getFontFactory()));
            }
        };
    }

    private JPanel createInitializePanel(JPanel initializationFlowPanel, JButton primaryButton, JButton secondaryButton, JLabel messageLabel) {
        return this.viewContext.createFormBuilder().spacer().component((JComponent)initializationFlowPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS}).spacer().end(3).end().end().spacer().component((JComponent)primaryButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.BUTTON_ROW}).component((JComponent)secondaryButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).end().component((JComponent)messageLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getCardPanel(this.textResource.robotStatus());
    }

    private JLabel getMessageDisplay(URFontFactory fontFactory) {
        if (this.messageDisplay == null) {
            this.messageDisplay = this.createMessageDisplay(fontFactory);
        }
        return this.messageDisplay;
    }

    private JLabel getBrakePinMessageDisplay(URFontFactory fontFactory) {
        if (this.brakePinMessageDisplay == null) {
            this.brakePinMessageDisplay = this.createMessageDisplay(fontFactory);
        }
        return this.brakePinMessageDisplay;
    }

    private JLabel createMessageDisplay(URFontFactory fontFactory) {
        JLabel messageLabel = new JLabel();
        messageLabel.setFont(fontFactory.getRelativeFont(URFontFactory.Size.SMALL));
        messageLabel.setHorizontalAlignment(0);
        messageLabel.setVerticalAlignment(0);
        return messageLabel;
    }

    public void enter(Object o) {
        this.initializationFlowPanel.enter();
        this.brakePinInitializationFlowPanel.enter();
    }

    public Object exit() {
        this.initializationFlowPanel.exit();
        this.brakePinInitializationFlowPanel.exit();
        return null;
    }

    public static interface RobotStatusButton {
        public JButton getOnButton();

        public JButton getOffButton();

        public JButton getBrakeFailureOffButton();

        public JButton getBrakeFailureInfoButton();
    }
}

