/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal;

import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.polyscope.initializerobot.impl.InitializeRobotPresenter;
import com.ur.polyscope.initializerobot.impl.i18n.TextResource;
import com.ur.polyscope.initializerobot.impl.images.ImageResource;
import com.ur.polyscope.initializerobot.impl.internal.AnimatedImagePanel;
import com.ur.polyscope.initializerobot.impl.internal.RobotInitializationPresenter;
import com.ur.swing.URFontFactory;
import com.ur.swing.card.CardLayoutUtil;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VisualInitializationPanel
extends JPanel {
    private static final String GREEN_LABEL_NAME = "VisualInitializationPanel.greenLabel";
    private static final String RED_LABEL_NAME = "VisualInitializationPanel.redLabel";
    private static final String INITIALIZE_FLOW_NAME = "VisualInitializationPanel.initializeFlow";
    private static final List<SafetyMode> SAFETY_STOP_MODE_LIST = Arrays.asList(SafetyMode.SAFEGUARD_STOP, SafetyMode.AUTOMATIC_MODE_SAFEGUARD_STOP, SafetyMode.IMMI_SAFEGUARD_STOP, SafetyMode.SYSTEM_THREE_POSITION_ENABLING_STOP, SafetyMode.TP_THREE_POSITION_ENABLING_STOP, SafetyMode.PROFISAFE_AUTOMATIC_MODE_SAFEGUARD_STOP, SafetyMode.PROFISAFE_SAFEGUARD_STOP);
    private final RedLabel badLabel;
    private final GreenLabel goodLabel;
    private final InitializationFlowPanel initializationFlowPanel;

    VisualInitializationPanel(TextResource resource, URFontFactory fontFactory) {
        this.setLayout(new CardLayout());
        this.badLabel = new RedLabel(resource.jointsVerification(), fontFactory);
        this.badLabel.setName(RED_LABEL_NAME);
        this.goodLabel = new GreenLabel(RobotModes.getString((RobotMode)RobotMode.BACKDRIVE), fontFactory);
        this.goodLabel.setName(GREEN_LABEL_NAME);
        this.initializationFlowPanel = new InitializationFlowPanel(fontFactory, resource);
        this.add((Component)this.initializationFlowPanel, InitializationState.INIT.name());
        this.add((Component)new JPanel(new BorderLayout()){
            {
                this.add((Component)VisualInitializationPanel.this.goodLabel, "Center");
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 5));
            }
        }, InitializationState.GOOD.name());
        this.add((Component)new JPanel(new BorderLayout()){
            {
                this.add((Component)VisualInitializationPanel.this.badLabel, "Center");
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 5));
            }
        }, InitializationState.BAD.name());
    }

    public static String evenlySplitInto2Rows(String text) {
        int i = text.length() / 2;
        for (int j = text.length() / 2; i > 0 && j < text.length(); --i, ++j) {
            if (text.charAt(i) == ' ') {
                return text.substring(0, i) + "<br/>" + text.substring(i + 1);
            }
            if (text.charAt(j) != ' ') continue;
            return text.substring(0, j) + "<br/>" + text.substring(j + 1);
        }
        return text;
    }

    public void enter() {
        this.initializationFlowPanel.start();
    }

    public void exit() {
        this.initializationFlowPanel.stop();
    }

    public void update(RobotInitializationPresenter.PresentationState state) {
        switch (state.getInitializationMode()) {
            case BACKDRIVE: 
            case RECOVERY: 
            case SAFE_GUARD_STOP: 
            case CONFIRM_SAFETY: {
                this.goodLabel.setText(state.getRobotStateString().toUpperCase());
                CardLayoutUtil.flipToCard((JPanel)this, (String)InitializationState.GOOD.name());
                break;
            }
            case SAFETY_VIOLATION: 
            case NO_CONTROLLER: 
            case DISCONNECTED: 
            case UPDATING: 
            case JOINT_VERIFICATION: 
            case WAITING_FOR_PARAMETERS: 
            case BRAKE_FAILURE: {
                this.badLabel.setText(state.getRobotStateString().toUpperCase());
                CardLayoutUtil.flipToCard((JPanel)this, (String)InitializationState.BAD.name());
                break;
            }
            case BRAKE_RELEASING: 
            case NONE: {
                CardLayoutUtil.flipToCard((JPanel)this, (String)InitializationState.INIT.name());
                this.initializationFlowPanel.update(state);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + state.getInitializationMode());
            }
        }
    }

    private static class GreenLabel
    extends RedLabel {
        public GreenLabel(String string, URFontFactory fontFactory) {
            super(string, fontFactory);
            this.setBackground(new Color(251, 238, 198));
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(240, 213, 152)));
        }
    }

    private static class RedLabel
    extends JLabel {
        public RedLabel(String string, URFontFactory fontFactory) {
            this.setText(string);
            this.setFont(fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE));
            this.setForeground(Color.BLACK);
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setBackground(new Color(237, 206, 206));
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, G5LookAndFeel.ERROR_BORDER_COLOR));
        }
    }

    private static class InitializationStepPanel
    extends JPanel {
        private final Dimension STATE_ICON_PREFERRED_SIZE = new Dimension(45, 45);
        private final Dimension STATE_TEXT_PREFERRED_SIZE = new Dimension(120, 120);
        private final JPanel statePanel;
        private final AnimatedImagePanel processingImage;
        private final JLabel stateTextLabel;
        private final JLabel okStateLabel;
        private final String offStateText;
        private final String idleStateText;
        private final String onStateText;

        public InitializationStepPanel(URFontFactory fontFactory, String offStateText, String idleStateText, String onStateText) {
            this.offStateText = offStateText;
            this.idleStateText = idleStateText;
            this.onStateText = onStateText;
            this.processingImage = new AnimatedImagePanel(ImageResource.loadingSprite(), this.STATE_ICON_PREFERRED_SIZE.width, this.STATE_ICON_PREFERRED_SIZE.height);
            this.processingImage.setBorder(BorderFactory.createEmptyBorder());
            this.statePanel = new JPanel();
            this.statePanel.setLayout(new CardLayout());
            this.statePanel.setPreferredSize(this.STATE_ICON_PREFERRED_SIZE);
            this.statePanel.setMinimumSize(this.STATE_ICON_PREFERRED_SIZE);
            this.statePanel.setMaximumSize(this.STATE_ICON_PREFERRED_SIZE);
            this.statePanel.setAlignmentX(0.5f);
            this.statePanel.add((Component)new JLabel(ImageResource.checkPending()), LabelStates.PENDING.name());
            this.statePanel.add((Component)new JLabel(ImageResource.checkOff()), LabelStates.OFF.name());
            this.statePanel.add((Component)new JLabel(ImageResource.checkIdle()), LabelStates.IDLE.name());
            this.okStateLabel = new JLabel(ImageResource.checkOk());
            this.statePanel.add((Component)this.okStateLabel, LabelStates.ON.name());
            this.statePanel.add((Component)this.processingImage, LabelStates.SPIN.name());
            this.stateTextLabel = new JLabel(offStateText);
            this.stateTextLabel.setFont(fontFactory.getRelativeFont(URFontFactory.Size.VERY_SMALL));
            this.stateTextLabel.setHorizontalAlignment(0);
            this.stateTextLabel.setVerticalAlignment(1);
            this.stateTextLabel.setAlignmentX(0.5f);
            this.stateTextLabel.setPreferredSize(this.STATE_TEXT_PREFERRED_SIZE);
            this.stateTextLabel.setMinimumSize(this.STATE_TEXT_PREFERRED_SIZE);
            this.stateTextLabel.setMaximumSize(this.STATE_TEXT_PREFERRED_SIZE);
            this.stateTextLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.statePanel);
            this.add(this.stateTextLabel);
            this.add(Box.createGlue());
            this.enableTransparentBackgroundForGrayLine();
        }

        private void enableTransparentBackgroundForGrayLine() {
            this.setOpaque(false);
            this.statePanel.setOpaque(false);
            this.processingImage.setOpaque(false);
        }

        @Override
        public void setName(String name) {
            this.okStateLabel.setName(name);
        }

        public void start() {
            this.processingImage.start();
        }

        public void stop() {
            this.processingImage.stop();
        }

        public void pending() {
            CardLayoutUtil.flipToCard((JPanel)this.statePanel, (String)LabelStates.PENDING.name());
            this.stateTextLabel.setText(this.offStateText);
        }

        public void off() {
            CardLayoutUtil.flipToCard((JPanel)this.statePanel, (String)LabelStates.OFF.name());
            this.stateTextLabel.setText(this.offStateText);
        }

        public void idle() {
            CardLayoutUtil.flipToCard((JPanel)this.statePanel, (String)LabelStates.IDLE.name());
            this.stateTextLabel.setText(this.onStateText);
        }

        public void idle(String message) {
            CardLayoutUtil.flipToCard((JPanel)this.statePanel, (String)LabelStates.IDLE.name());
            this.stateTextLabel.setText(message);
        }

        public void on() {
            CardLayoutUtil.flipToCard((JPanel)this.statePanel, (String)LabelStates.ON.name());
            this.stateTextLabel.setText(this.onStateText);
        }

        public void on(String message) {
            CardLayoutUtil.flipToCard((JPanel)this.statePanel, (String)LabelStates.ON.name());
            this.stateTextLabel.setText(message);
        }

        public void spin() {
            CardLayoutUtil.flipToCard((JPanel)this.statePanel, (String)LabelStates.SPIN.name());
            this.stateTextLabel.setText(this.idleStateText);
        }
    }

    private static class InitializationFlowPanel
    extends JPanel {
        private final RobotInitializationPresenter.PresentationState POWERED_OFF = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.NONE, InitializeRobotPresenter.UserAction.ACTION_POWER_ON, true, false);
        private final RobotInitializationPresenter.PresentationState MOUNTING_ERROR = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.MOUNTING_ERROR, InitializeRobotPresenter.UserAction.ACTION_START, false, false);
        private final RobotInitializationPresenter.PresentationState POWER_ON = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.NONE, InitializeRobotPresenter.UserAction.ACTION_START, false, false);
        private final RobotInitializationPresenter.PresentationState BOOTING = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.NONE, InitializeRobotPresenter.UserAction.ACTION_POWER_ON, false, false);
        private final RobotInitializationPresenter.PresentationState IDLE = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.RELEASE_BRAKES_WARNING, InitializeRobotPresenter.UserAction.ACTION_START, true, false);
        private final RobotInitializationPresenter.PresentationState BRAKE_RELEASING = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.RELEASE_BRAKES_WARNING, InitializeRobotPresenter.UserAction.ACTION_START, false, false);
        private final RobotInitializationPresenter.PresentationState RECOVERY = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.NONE, InitializeRobotPresenter.UserAction.ACTION_JUMP_TO_RECOVERY_TAB, true, false);
        private final RobotInitializationPresenter.PresentationState NORMAL = new RobotInitializationPresenter.PresentationState(RobotInitializationPresenter.PresentationStateMessage.NONE, InitializeRobotPresenter.UserAction.ACTION_START, false, true);
        private final InitializationStepPanel powerStep;
        private final InitializationStepPanel bootingStep;
        private final InitializationStepPanel idleStep;
        private final InitializationStepPanel brakeReleaseStep;
        private final InitializationStepPanel operationalStep;
        private final TextResource text;

        InitializationFlowPanel(URFontFactory fontFactory, TextResource textResource) {
            this.text = textResource;
            this.setName(VisualInitializationPanel.INITIALIZE_FLOW_NAME);
            this.powerStep = this.createInitializationStatePanel(fontFactory, textResource.powerOff(), "", textResource.powerOn());
            this.bootingStep = this.createInitializationStatePanel(fontFactory, textResource.booting(), textResource.bootingUp(), textResource.bootingComplete());
            this.idleStep = this.createInitializationStatePanel(fontFactory, textResource.robotIdle(), textResource.robotActive(), textResource.robotActive());
            this.brakeReleaseStep = this.createInitializationStatePanel(fontFactory, textResource.brakeRelease(), textResource.releasingBrakes(), textResource.brakesReleased());
            this.operationalStep = this.createInitializationStatePanel(fontFactory, textResource.robotOperational(), textResource.robotOperational(), textResource.robotOperational());
            this.operationalStep.setName("OK.RobotInitializationPanel");
            this.setLayout(new GridLayout(1, 5));
            this.add(this.powerStep);
            this.add(this.bootingStep);
            this.add(this.idleStep);
            this.add(this.brakeReleaseStep);
            this.add(this.operationalStep);
        }

        private InitializationStepPanel createInitializationStatePanel(URFontFactory fontFactory, String offText, String idleText, String onText) {
            return new InitializationStepPanel(fontFactory, this.html(offText), this.html(idleText), this.html(onText));
        }

        private String html(String text) {
            if (text == null) {
                return text;
            }
            text = VisualInitializationPanel.evenlySplitInto2Rows(text);
            return HTML.html((String)HTML.center((String)text));
        }

        public void update(RobotInitializationPresenter.PresentationState state) {
            if (this.isState(this.POWERED_OFF, state)) {
                this.powerStep.off();
                this.bootingStep.pending();
                this.idleStep.pending();
                this.brakeReleaseStep.pending();
                this.operationalStep.pending();
            } else if (this.isState(this.BOOTING, state) || this.isState(this.POWER_ON, state)) {
                if (this.isSafetyStop(state)) {
                    this.powerStep.on();
                    this.bootingStep.on();
                    this.idleStep.on();
                    this.brakeReleaseStep.on();
                    this.operationalStep.idle(this.html(this.text.robotInXSafetyMode(state.getRobotStateString())));
                } else {
                    this.powerStep.on();
                    this.bootingStep.spin();
                    this.idleStep.pending();
                    this.brakeReleaseStep.pending();
                    this.operationalStep.pending();
                }
            } else if (this.isState(this.IDLE, state) || this.isState(this.MOUNTING_ERROR, state)) {
                this.powerStep.on();
                this.bootingStep.on();
                this.idleStep.idle();
                this.brakeReleaseStep.pending();
                this.operationalStep.pending();
            } else if (this.isState(this.BRAKE_RELEASING, state)) {
                this.powerStep.on();
                this.bootingStep.on();
                this.idleStep.on();
                this.brakeReleaseStep.spin();
                this.operationalStep.pending();
            } else if (this.isState(this.RECOVERY, state)) {
                this.powerStep.on();
                this.bootingStep.on();
                this.idleStep.on();
                this.brakeReleaseStep.on();
                this.operationalStep.idle();
            } else if (this.isState(this.NORMAL, state)) {
                this.powerStep.on();
                this.bootingStep.on();
                this.idleStep.on();
                this.brakeReleaseStep.on();
                this.operationalStep.on(this.html(this.text.robotInXMode(state.getRobotStateString())));
            }
        }

        private boolean isSafetyStop(RobotInitializationPresenter.PresentationState state) {
            for (SafetyMode safetyMode : SAFETY_STOP_MODE_LIST) {
                String safetyStop = RobotModes.getRobotStateString((RobotMode)RobotMode.IDLE, (SafetyMode)safetyMode, (int[])new int[0]);
                if (!state.getRobotStateString().equalsIgnoreCase(safetyStop)) continue;
                return true;
            }
            return false;
        }

        private boolean isState(RobotInitializationPresenter.PresentationState desired, RobotInitializationPresenter.PresentationState actual) {
            return desired.getMessage() == actual.getMessage() && desired.getOnAction() == actual.getOnAction() && desired.isEnabled(desired.getOnAction()) == actual.isEnabled(actual.getOnAction()) && desired.isInitialized() == actual.isInitialized();
        }

        @Override
        protected void paintChildren(Graphics g) {
            this.drawHorizontalLineThroughStateCircles(g);
            super.paintChildren(g);
        }

        private void drawHorizontalLineThroughStateCircles(Graphics g) {
            int horizontalLineY = 23;
            int startX = 60;
            int endX = this.getWidth() - startX;
            g.setColor(new Color(219, 219, 219));
            g.drawLine(startX, horizontalLineY, endX, horizontalLineY);
        }

        public void start() {
            this.bootingStep.start();
            this.brakeReleaseStep.start();
        }

        public void stop() {
            this.bootingStep.stop();
            this.brakeReleaseStep.stop();
        }
    }

    private static enum LabelStates {
        PENDING,
        OFF,
        IDLE,
        ON,
        SPIN;

    }

    private static enum InitializationState {
        INIT,
        GOOD,
        BAD;

    }
}

