/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.controller;

import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.initializerobot.impl.internal.controller.ControllerRPC;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HMC
implements ControllerRPC {
    private HMCInterface hmcInterface;

    @Inject
    public HMC(HMCInterface hmcInterface) {
        this.hmcInterface = hmcInterface;
    }

    /*
     * Loose catch block
     */
    @Override
    public double getPayloadMass() {
        block16: {
            double d;
            Throwable throwable;
            DataInputStream dis;
            block14: {
                block15: {
                    HMCResponse hmcResponseMessage = this.hmcInterface.sendHMCMessageAndWait("get_payload_mass()");
                    if (hmcResponseMessage == null) break block16;
                    ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                    dis = new DataInputStream(bais);
                    throwable = null;
                    d = dis.readDouble();
                    if (dis == null) break block14;
                    if (throwable == null) break block15;
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block14;
                }
                dis.close();
            }
            return d;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (dis != null) {
                            if (throwable != null) {
                                try {
                                    dis.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                dis.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    Log.error((String)("Parse error (or similar): " + e));
                }
            }
        }
        return -1.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRobotMountingCorrect() {
        HMCResponse hmcResponseMessage = this.hmcInterface.sendHMCMessageAndWait("is_robot_mounting_correct()");
        if (hmcResponseMessage != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
            try (DataInputStream dis = new DataInputStream(bais);){
                int res;
                if (hmcResponseMessage.getResponseData() == null) {
                    Log.error((String)"HMC Message buffer is null!?");
                }
                boolean bl = (res = dis.readInt()) == 1;
                return bl;
            }
            catch (Exception e) {
                Log.error((String)("HMC.isRobotMountingCorrect: Parse error (or similar) " + e));
            }
        }
        Log.warning((String)"HMC.isRobotMountingCorrect: HMC call failed on timeout");
        return false;
    }
}

