/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.controller;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.ControllerServiceManager;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SystemControl {
    private static final int HMC_RESPONSE = 2;
    private final ControllerServiceManager controllerServiceManager;
    private ControllerInterface controllerInterface;

    @Inject
    public SystemControl(ControllerServiceManager controllerServiceManager, ControllerInterface controllerInterface) {
        this.controllerServiceManager = controllerServiceManager;
        this.controllerInterface = controllerInterface;
    }

    public void restartSCB() {
        if (this.controllerInterface.isConnected()) {
            this.controllerInterface.runScript("restart scb\n");
        }
    }

    public void powerOnController() {
        this.controllerServiceManager.startService();
    }

    public void powerOnArm() {
        this.controllerInterface.runScript("power on");
    }

    public void powerOffArm() {
        this.controllerInterface.runScript("power off");
    }

    public void releaseBrakes() {
        this.controllerInterface.runScript("set robotmode run");
    }

    public void powerOffArmBrakePin() {
        this.controllerInterface.runScript("power off brake failure");
    }

    public void sendUnlockProtectiveStop() {
        this.controllerInterface.runScript("set unlock protective stop\n");
    }

    public void cancelArmSimulation() {
        if (this.controllerInterface.isConnected()) {
            try {
                this.controllerInterface.runScript("set real\n");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to activate real robot ", e);
            }
            if (!Waiting.until(() -> RobotState.getLatestRobotState().real, (int)2, (TimeUnit)TimeUnit.SECONDS)) {
                EventNotificationService.notify(ControllerConnectionListener.class, controllerConnectionListener -> controllerConnectionListener.failedToSendMessage("set real"));
            }
        }
    }
}

