/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.dashboardserver;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.lang.StringUtils;
import com.ur.polyscope.initializerobot.impl.internal.controller.ControllerRPC;
import com.ur.polyscope.initializerobot.impl.internal.controller.SystemControl;
import com.ur.polyscope.initializerobot.impl.internal.dashboardserver.BrakePinEngagementDetector;
import javax.inject.Inject;

public class RobotModeAction
implements DashBoardAction {
    private static final int MOUNTING_CHECK_RETRIES = 3;
    private static final int DEFAULT_DELAY_IN_MS = 500;
    private final SystemControl systemControl;
    private final BrakePinEngagementDetector brakePinEngagementDetector;
    private final ControllerRPC controllerRPC;

    @Inject
    public RobotModeAction(SystemControl systemControl, BrakePinEngagementDetector brakePinEngagementDetector, ControllerRPC controllerRPC) {
        this.systemControl = systemControl;
        this.brakePinEngagementDetector = brakePinEngagementDetector;
        this.controllerRPC = controllerRPC;
    }

    public boolean canHandleMessage(String input) {
        return StringUtils.equalsAnyIgnoreCase((String)input, (String[])new String[]{"power on", "power off", "brake release"});
    }

    public String execute(String inputLine) {
        if ("power on".equalsIgnoreCase(inputLine)) {
            this.systemControl.powerOnArm();
            return "Powering on";
        }
        if ("power off".equalsIgnoreCase(inputLine)) {
            this.systemControl.powerOffArm();
            this.brakePinEngagementDetector.waitUntilParked();
            return "Powering off";
        }
        if ("brake release".equalsIgnoreCase(inputLine)) {
            if (!this.checkMounting()) {
                return "Unable to brake release, robot mounting is not correct";
            }
            this.systemControl.releaseBrakes();
            return "Brake releasing";
        }
        return "Could not understand RobotModeAction " + inputLine;
    }

    private boolean checkMounting() {
        for (int i = 0; i < 3; ++i) {
            if (this.controllerRPC.isRobotMountingCorrect()) {
                return true;
            }
            if (i >= 2) continue;
            this.delayRetry();
        }
        return false;
    }

    private synchronized void delayRetry() {
        long startTime = System.currentTimeMillis();
        do {
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (System.currentTimeMillis() - startTime <= 500L);
    }
}

