/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.footercontribution;

import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.initializerobot.impl.RobotInitializationPanel;
import com.ur.polyscope.initializerobot.impl.images.ImageResource;
import com.ur.polyscope.initializerobot.impl.internal.footercontribution.RobotAndSafetyMode;
import com.ur.polyscope.initializerobot.impl.internal.footercontribution.RobotStateLampIndicator;
import com.ur.polyscope.initializerobot.impl.internal.footercontribution.TooltipDisplay;
import com.ur.swing.ActionDefinition;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.ViewContext;
import com.ur.swing.card.SetFlipManager;
import com.ur.swing.extensible.AddLayer;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Layer;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.swing.LayeredIcon;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

@Extension(value="Footer")
@ExtensionPoint(value="InitializeRobot")
@Singleton
public class InitializeRobotAction
extends ShowScreenActionImpl
implements MenuExtension,
SetFlipManager,
RobotInitializationService,
AddLayer {
    private static final Dimension PANEL_SIZE = new Dimension(60, 60);
    private final ViewContext context;
    private final TooltipDisplay tooltipDisplay;
    private final RobotAndSafetyMode robotAndSafetyMode;
    private JComponent button;

    @Inject
    InitializeRobotAction(ViewContext context, TooltipDisplay tooltipDisplay, RobotAndSafetyMode robotAndSafetyMode) {
        super(RobotInitializationPanel.class, null, true);
        this.context = context;
        this.tooltipDisplay = tooltipDisplay;
        this.robotAndSafetyMode = robotAndSafetyMode;
        this.putValue("HelpId", "gui:initialization_screen_led");
        this.putValue("SmallIcon", new LayeredIcon(ImageResource.initGray(), new Icon[]{ImageResource.initStateRed()}));
        this.putValue("Function", ActionDefinition.Function.APPLICATION_FOOTER);
        this.putValue("InternalName", "initRobotScreen.HeaderMenu");
        RobotStateLampIndicator indicator = new RobotStateLampIndicator(this);
        robotAndSafetyMode.subscribe(indicator);
        this.button = this.context.createWidgetFactory().createButton((Action)((Object)this));
        this.button.setOpaque(false);
        this.button.setMinimumSize(PANEL_SIZE);
        this.button.setPreferredSize(PANEL_SIZE);
        this.button.setMaximumSize(PANEL_SIZE);
    }

    public void setFlipManager(FlipManager flipManager) {
        if (flipManager == null) {
            return;
        }
        super.setFlipManager(flipManager);
        flipManager.addCardChangedListener(aClass -> this.setEnabled(flipManager.getSwitchSupport().isCardStackEmpty()));
    }

    public void initializeRobot() {
        this.initializeRobot(false);
    }

    public void initializeRobot(boolean allowSafeguardStop) {
        if (allowSafeguardStop && this.robotAndSafetyMode.isRobotPoweredOn() || this.isRobotRunning()) {
            this.tooltipDisplay.removeRegistration(this.button);
        } else {
            this.tooltipDisplay.showRegularInitializationDialog(this.button, this.robotAndSafetyMode.isRobotPoweredOff(), this.robotAndSafetyMode.currentSafetyCategory());
        }
    }

    public boolean isRobotRunning() {
        return this.robotAndSafetyMode.isRobotRunning();
    }

    public void forceInitializeRobotNow() {
        this.actionPerformed(null);
    }

    public MenuExtension.MenuContribution create() {
        return new MenuExtension.ComponentMenuContribution(this.button, "LEFT", MenuExtension.MenuContribution.Restrictions.NO_RESTRICTION);
    }

    public void addLayer(Layer layer) {
        this.button = layer.decorate(this.button);
    }
}

