/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.footercontribution;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.Source;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
class RobotAndSafetyMode {
    private static final List<SafetyModeCategory> RUNNING_SAFETY_MODE_CATEGORIES = Arrays.asList(SafetyModeCategory.NORMAL, SafetyModeCategory.REDUCED);
    private static final List<SafetyModeCategory> POWERED_ON_SAFETY_MODE_CATEGORIES = Arrays.asList(SafetyModeCategory.NORMAL, SafetyModeCategory.REDUCED, SafetyModeCategory.SAFEGUARD_STOP, SafetyModeCategory.THREE_POSITION_ENABLING_STOP);
    private final Provider<com.ur.monitor.model.RobotMode> lastRobotMode;
    private final Recipe<com.ur.monitor.model.RobotMode> robotModeRecipe;

    @Inject
    RobotAndSafetyMode(@Source(value=com.ur.monitor.model.RobotMode.class) Recipe<com.ur.monitor.model.RobotMode> robotModeRecipe) {
        this.lastRobotMode = robotModeRecipe.lastProvider();
        this.robotModeRecipe = robotModeRecipe;
    }

    void subscribe(Consumer<com.ur.monitor.model.RobotMode> consumer) {
        this.robotModeRecipe.executeOnUIThread().subscribe(consumer);
    }

    boolean isRobotPoweredOff() {
        return this.isRobotMode(RobotMode.POWER_OFF);
    }

    boolean isRobotRunning() {
        return this.isRobotMode(RobotMode.RUNNING) && RUNNING_SAFETY_MODE_CATEGORIES.contains(this.currentSafetyCategory());
    }

    boolean isRobotPoweredOn() {
        return this.isRobotMode(RobotMode.RUNNING) && POWERED_ON_SAFETY_MODE_CATEGORIES.contains(this.currentSafetyCategory());
    }

    SafetyModeCategory currentSafetyCategory() {
        com.ur.monitor.model.RobotMode robotMode = (com.ur.monitor.model.RobotMode)this.lastRobotMode.get();
        return SafetyModes.getSafetyModeCategory((SafetyMode)robotMode.getSafetyMode());
    }

    private boolean isRobotMode(RobotMode robotMode) {
        return ((com.ur.monitor.model.RobotMode)this.lastRobotMode.get()).getRobotMode() == robotMode;
    }
}

