/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.footercontribution;

import com.ur.lang.EqualsUtil;
import com.ur.lang.react.Consumer;
import com.ur.polyscope.initializerobot.impl.images.ImageResource;
import com.ur.polyscope.initializerobot.impl.internal.LedIcon;
import com.ur.polyscope.initializerobot.impl.internal.RobotStatusLedHelper;
import com.ur.polyscope.initializerobot.impl.internal.footercontribution.InitializeRobotAction;
import com.ur.polyscope.initializerobot.impl.internal.footercontribution.RobotStateLedIcon;
import com.ur.util.swing.LayeredIcon;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import java.lang.ref.WeakReference;
import javax.swing.Icon;

public class RobotStateLampIndicator
implements Consumer<com.ur.monitor.model.RobotMode> {
    private final RobotStatusLedHelper robotStatusLedHelper;
    private final LedIcon ledIcon;
    private RobotMode robotMode = RobotMode.NO_CONTROLLER;
    private SafetyMode safetyMode = SafetyMode.NORMAL;
    private ControlMode controlMode = null;
    private WeakReference<InitializeRobotAction> initializeRobotActionWeakReference;

    public RobotStateLampIndicator(InitializeRobotAction initializeRobotAction) {
        this.initializeRobotActionWeakReference = new WeakReference<InitializeRobotAction>(initializeRobotAction);
        this.ledIcon = new RobotStateLedIcon();
        this.robotStatusLedHelper = new RobotStatusLedHelper(this.ledIcon);
    }

    private boolean hasValidReference() {
        return this.initializeRobotActionWeakReference.get() != null;
    }

    private InitializeRobotAction get() {
        return (InitializeRobotAction)((Object)this.initializeRobotActionWeakReference.get());
    }

    public void accept(com.ur.monitor.model.RobotMode robotMode) {
        this.controlModeChanged(robotMode.getControlMode());
        this.safetyModeChanged(robotMode.getSafetyMode());
        this.robotModeChanged(robotMode.getRobotMode());
        this.updateIndicator();
    }

    private void controlModeChanged(ControlMode newControlMode) {
        if (newControlMode == this.controlMode) {
            return;
        }
        this.controlMode = newControlMode;
    }

    private void robotModeChanged(RobotMode newRobotMode) {
        if (newRobotMode == this.robotMode) {
            return;
        }
        this.robotMode = newRobotMode == null ? RobotMode.NO_CONTROLLER : newRobotMode;
    }

    private void safetyModeChanged(SafetyMode newSafetyMode) {
        if (newSafetyMode == this.safetyMode) {
            return;
        }
        this.safetyMode = newSafetyMode == null ? SafetyMode.NORMAL : newSafetyMode;
    }

    private void updateIndicator() {
        if (!this.hasValidReference()) {
            return;
        }
        Icon stateIcon = this.getStateIcon();
        LayeredIcon layeredIcon = this.getLayeredIcon(this.get().isEnabled(), stateIcon);
        this.get().putValue("SmallIcon", layeredIcon);
    }

    private Icon getStateIcon() {
        Icon candidateRobotMode = this.updateRobotModeIcon(this.robotMode, this.controlMode);
        Icon candidateSafetyMode = this.updateSafetyIcon(this.safetyMode, this.controlMode);
        return this.getIconToOneOf(candidateRobotMode, candidateSafetyMode);
    }

    private LayeredIcon getLayeredIcon(boolean enabled, Icon stateIcon) {
        if (enabled) {
            return new LayeredIcon(ImageResource.initWhite(), new Icon[]{stateIcon});
        }
        return new LayeredIcon(ImageResource.initGray(), new Icon[]{stateIcon});
    }

    private Icon getIconToOneOf(Icon candidateRobotMode, Icon candidateSafetyMode) {
        if (EqualsUtil.equalsOneOf((Object)this.ledIcon.getIndicatorError(), (Object[])new Icon[]{candidateRobotMode, candidateSafetyMode})) {
            return this.ledIcon.getIndicatorError();
        }
        if (EqualsUtil.equalsOneOf((Object)this.ledIcon.getIndicatorWarning(), (Object[])new Icon[]{candidateRobotMode, candidateSafetyMode})) {
            return this.ledIcon.getIndicatorWarning();
        }
        if (EqualsUtil.equalsOneOf((Object)this.ledIcon.getIndicatorFreedrive(), (Object[])new Icon[]{candidateRobotMode, candidateSafetyMode})) {
            return this.ledIcon.getIndicatorFreedrive();
        }
        return this.ledIcon.getIndicatorOK();
    }

    private Icon getRobotModeIcon(RobotMode robotMode, ControlMode controlMode) {
        if (controlMode == ControlMode.TEACH) {
            return this.ledIcon.getIndicatorFreedrive();
        }
        switch (robotMode) {
            case NO_CONTROLLER: 
            case DISCONNECTED: 
            case BOOTING: 
            case POWER_OFF: 
            case CONFIRM_SAFETY: {
                return this.ledIcon.getIndicatorError();
            }
            case POWER_ON: 
            case UPDATING: 
            case IDLE: 
            case BACKDRIVE: {
                return this.ledIcon.getIndicatorWarning();
            }
            case RUNNING: {
                return this.ledIcon.getIndicatorOK();
            }
        }
        return null;
    }

    private Icon updateRobotModeIcon(RobotMode mode, ControlMode controlMode) {
        if (!this.hasValidReference()) {
            return null;
        }
        Icon result = this.getRobotModeIcon(mode, controlMode);
        if (result == null) {
            return this.ledIcon.getIndicatorOK();
        }
        return result;
    }

    private Icon updateSafetyIcon(SafetyMode mode, ControlMode controlMode) {
        return this.robotStatusLedHelper.getIndicatorType(mode, controlMode);
    }
}

