/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.footercontribution;

import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.polyscope.initializerobot.impl.i18n.TextResource;
import com.ur.polyscope.initializerobot.impl.images.ImageResource;
import com.ur.swing.BindingRegistrationWasClosed;
import com.ur.swing.DisplayMessageFactory;
import com.ur.util.swing.HTML;
import java.util.EnumMap;
import javax.inject.Inject;
import javax.swing.JComponent;

public class TooltipDisplay {
    private static final DefaultSafetyMessage DEFAULT_SAFETY_MESSAGE = new DefaultSafetyMessage();
    private static final EnumMap<SafetyModeCategory, SafetyMessage> safetyMessages = new EnumMap(SafetyModeCategory.class);
    private final String infoIconPath;
    private final TextResource textResource;
    private BindingRegistrationWasClosed tooltipRegistration;

    @Inject
    public TooltipDisplay(TextResource textResource) {
        this.textResource = textResource;
        this.infoIconPath = ImageResource.asResource(ImageResource.informationIcon()).toString();
        safetyMessages.put(SafetyModeCategory.NORMAL, DEFAULT_SAFETY_MESSAGE);
        safetyMessages.put(SafetyModeCategory.REDUCED, DEFAULT_SAFETY_MESSAGE);
        safetyMessages.put(SafetyModeCategory.RECOVERY, DEFAULT_SAFETY_MESSAGE);
        safetyMessages.put(SafetyModeCategory.PROTECTIVE_STOP, DEFAULT_SAFETY_MESSAGE);
        safetyMessages.put(SafetyModeCategory.WAITING_FOR_PARAMETERS, DEFAULT_SAFETY_MESSAGE);
        safetyMessages.put(SafetyModeCategory.VALIDATE_JOINT_ID, DEFAULT_SAFETY_MESSAGE);
        safetyMessages.put(SafetyModeCategory.EMERGENCY_STOP, new EmergencyStopSafetyMessage());
        safetyMessages.put(SafetyModeCategory.SAFEGUARD_STOP, new SafeguardStopSafetyMessage());
        safetyMessages.put(SafetyModeCategory.VIOLATION, new ViolationSafetyMessage());
        safetyMessages.put(SafetyModeCategory.FAULT, new FaultSafetyMessage());
        safetyMessages.put(SafetyModeCategory.BRAKE_FAILURE, new BrakeFailureSafetyMessage());
        safetyMessages.put(SafetyModeCategory.UNDEFINED_SAFETY_MODE, new DefaultSafetyMessage());
        safetyMessages.put(SafetyModeCategory.THREE_POSITION_ENABLING_STOP, new ThreePositionEnablingStopSafetyMessage());
    }

    public void removeRegistration(JComponent button) {
        DisplayMessageFactory.removeRegistration((JComponent)button);
    }

    public void showRegularInitializationDialog(JComponent button, boolean isRobotPowered, SafetyModeCategory safetyModeCategory) {
        if (this.tooltipRegistration != null) {
            this.tooltipRegistration.removeRegistration();
        }
        this.tooltipRegistration = DisplayMessageFactory.attentionWithoutTimeout((JComponent)button, (String)this.getMessage(isRobotPowered, safetyModeCategory));
    }

    private String getMessage(boolean isRobotPoweredOff, SafetyModeCategory safetyModeCategory) {
        SafetyMessage messageFactory = safetyMessages.get(safetyModeCategory);
        String message = messageFactory.powerOffOrOtherMessage(isRobotPoweredOff, this.textResource, this.infoIconPath);
        return HTML.html((String)message);
    }

    static class BrakeFailureSafetyMessage
    implements SafetyMessage {
        BrakeFailureSafetyMessage() {
        }

        @Override
        public String powerOffOrOtherMessage(boolean powerOffMode, TextResource textResource, String infoIconPath) {
            if (powerOffMode) {
                return textResource.safeBrakeFailureCannotPowerOn(infoIconPath);
            }
            return textResource.requiresSafeBrakeFailurePowerOff(infoIconPath);
        }
    }

    static class FaultSafetyMessage
    implements SafetyMessage {
        FaultSafetyMessage() {
        }

        @Override
        public String powerOffOrOtherMessage(boolean isPowerOffMode, TextResource textResource, String infoIconPath) {
            return textResource.requiresRestartOfSafety(infoIconPath);
        }
    }

    static class ThreePositionEnablingStopSafetyMessage
    implements SafetyMessage {
        ThreePositionEnablingStopSafetyMessage() {
        }

        @Override
        public String powerOffOrOtherMessage(boolean isPowerOffMode, TextResource textResource, String infoIconPath) {
            if (isPowerOffMode) {
                return textResource.requiresRobotInitialization(infoIconPath);
            }
            return textResource.requiresThreePositionDeviceToBeHeld(infoIconPath);
        }
    }

    static class ViolationSafetyMessage
    implements SafetyMessage {
        ViolationSafetyMessage() {
        }

        @Override
        public String powerOffOrOtherMessage(boolean isPowerOffMode, TextResource textResource, String infoIconPath) {
            if (isPowerOffMode) {
                return textResource.requiresReleaseOfEstop(infoIconPath);
            }
            return textResource.requiresRestartOfSafety(infoIconPath);
        }
    }

    static class EmergencyStopSafetyMessage
    implements SafetyMessage {
        EmergencyStopSafetyMessage() {
        }

        @Override
        public String powerOffOrOtherMessage(boolean isPowerOffMode, TextResource textResource, String infoIconPath) {
            return textResource.requiresReleaseOfEstop(infoIconPath);
        }
    }

    static class SafeguardStopSafetyMessage
    implements SafetyMessage {
        SafeguardStopSafetyMessage() {
        }

        @Override
        public String powerOffOrOtherMessage(boolean isPowerOffMode, TextResource textResource, String infoIconPath) {
            if (isPowerOffMode) {
                return textResource.requiresRobotInitialization(infoIconPath);
            }
            return textResource.requiresResetOfSafeguard(infoIconPath);
        }
    }

    static class DefaultSafetyMessage
    implements SafetyMessage {
        DefaultSafetyMessage() {
        }

        @Override
        public String powerOffOrOtherMessage(boolean isPowerOffMode, TextResource textResource, String infoIconPath) {
            return textResource.requiresRobotInitialization(infoIconPath);
        }
    }

    static interface SafetyMessage {
        public String powerOffOrOtherMessage(boolean var1, TextResource var2, String var3);
    }
}

