/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.robotview;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.initializerobot.impl.i18n.TextResource;
import com.ur.polyscope.initializerobot.impl.internal.robotview.RobotPresenter;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotInstallationInit;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.panel.RobotView3DPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.card.CardLayoutUtil;
import com.ur.swing.card.EnterExitCard;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.FooterExtension;
import com.ur.swing.g5.CardBorder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

@Extension(value="InitializeRobot")
@Singleton
public class RobotDisplayPanel
extends JPanel
implements FooterExtension,
EnterExitCard {
    private static final String ROBOT_VIEW = "3d graphics";
    private static final String EXPLANATION = "power_on";
    private final RobotPresenter presenter;
    private RobotView3DPanel view3DPanel;
    private RobotInstallationInit robotInstallationInit;
    private FeaturesLookup featuresLookup;

    @Inject
    public RobotDisplayPanel(ViewContext context, RobotPresenter presenter, RobotView3DPanel view3DPanel, RobotConfigurationProvider robot, FeaturesLookup featuresLookup) {
        this.view3DPanel = view3DPanel;
        this.presenter = presenter;
        this.robotInstallationInit = robot.getRobotInstallationInit();
        this.featuresLookup = featuresLookup;
        presenter.setView(this);
        this.setLayout(new CardLayout());
        this.setBorder((Border)new CardBorder(((TextResource)context.getTextResource(TextResource.class)).Robot()));
        this.add((Component)this.getPowerOnMessage(context), EXPLANATION);
        this.add((Component)this.getView3DPanel(view3DPanel), ROBOT_VIEW);
    }

    public JComponent createFooter() {
        this.putClientProperty("placement", 1);
        return this;
    }

    public void enter(Object object) {
        this.presenter.enter();
        this.view3DPanel.getRobotCanvas3D().enter();
    }

    public Object exit() {
        this.presenter.exit();
        this.view3DPanel.getRobotCanvas3D().clearAlwaysRun();
        this.view3DPanel.getRobotCanvas3D().exit();
        return null;
    }

    public void set3DViewVisible(boolean isVisible) {
        this.view3DPanel.setActive(isVisible);
        CardLayoutUtil.flipToCard((JPanel)this, (String)(isVisible ? ROBOT_VIEW : EXPLANATION));
        this.view3DPanel.getRobotCanvas3D().alwaysRun(new Runnable(){

            @Override
            public void run() {
                ViewableGeomFeature feature = RobotDisplayPanel.this.view3DPanel.getRobotCanvas3D().getViewableGeomFeature();
                Double desiredY = RobotDisplayPanel.this.robotInstallationInit.getYFactor();
                Double desiredZoomfactor = RobotDisplayPanel.this.robotInstallationInit.getDesiredZoomFactor();
                double actualZoomFactor = feature.getView()[0];
                if (!EqualsUtil.equals((Object)actualZoomFactor, (Object)desiredZoomfactor)) {
                    ViewableGeomFeature cloneOfFeature = feature = (ViewableGeomFeature)feature.clone();
                    RobotDisplayPanel.this.view3DPanel.getRobotCanvas3D().setViewableGeomFeature(cloneOfFeature);
                    feature.moveView(desiredZoomfactor - actualZoomFactor, 0.0, desiredY.doubleValue());
                }
            }
        });
    }

    private JPanel getPowerOnMessage(ViewContext context) {
        JPanel result = new JPanel(new BorderLayout());
        JLabel explanation = new JLabel(((TextResource)context.getTextResource(TextResource.class)).powerOnFirst());
        explanation.setFont(context.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE));
        explanation.setHorizontalAlignment(0);
        explanation.setVerticalAlignment(0);
        explanation.setForeground(new Color(179, 179, 179));
        result.add((Component)explanation, "Center");
        return result;
    }

    private RobotView3DPanel getView3DPanel(RobotView3DPanel view3DPanel) {
        view3DPanel.setDebugName("Initialize Robot 3D Canvas");
        view3DPanel.setBorder(BorderFactory.createEmptyBorder());
        view3DPanel.getRobotCanvas3D().alwaysRun((Runnable)new UpdateZoomInCanvas((ViewBehaviorHolder)new ViewBehaviorWrapper(this.featuresLookup)));
        view3DPanel.getRobotCanvas3D().showStaticElements(Arrays.asList(VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP));
        return view3DPanel;
    }
}

