/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.internal.robotview;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.initializerobot.impl.internal.robotview.RobotDisplayPanel;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.view.constants.dev.RobotMode;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RobotPresenter {
    private final EventManager eventManager;
    private RobotDisplayPanel view;
    private Subscription subscription = Subscription.NULL;

    @Inject
    RobotPresenter(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setView(RobotDisplayPanel view) {
        this.view = view;
    }

    public void enter() {
        this.subscription = this.eventManager.addStrongListener(RobotStateListener.class, (Object)new RobotStateListener(){
            boolean showRobot = false;

            public void updateRobotState(RobotState robotState) {
                boolean currentShowRobot;
                boolean breakRelease = RobotModes.isInBreakRelease((int[])robotState.jointMode);
                boolean bl = currentShowRobot = EqualsUtil.equalsOneOf((Object)robotState.robotMode, (Object[])new RobotMode[]{RobotMode.IDLE, RobotMode.RUNNING}) || breakRelease;
                if (currentShowRobot == this.showRobot) {
                    return;
                }
                this.showRobot = currentShowRobot;
                RobotPresenter.this.view.set3DViewVisible(this.showRobot);
            }
        });
        this.view.set3DViewVisible(false);
    }

    public void exit() {
        this.subscription.dispose();
        this.subscription = Subscription.NULL;
        this.view.set3DViewVisible(false);
    }
}

