/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.safebrake;

import com.ur.lang.react.Consumer;
import com.ur.polyscope.initializerobot.impl.i18n.TextResource;
import com.ur.polyscope.initializerobot.impl.images.ImageResource;
import com.ur.polyscope.initializerobot.impl.safebrake.MonitorBrakePinFailure;
import com.ur.polyscope.initializerobot.impl.safebrake.WebPageLink;
import com.ur.polyscope.security.KickToScreen;
import com.ur.swing.JFrameUtils;
import com.ur.swing.LongPressListener;
import com.ur.util.Optional;
import com.ur.util.event.Subscription;
import com.ur.util.swing.HTML;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Singleton
public class BrakePinFailureScreen
extends JPanel {
    private static final String FONT = "Inter";
    private static final int TEXT_ALIGN_WITH_WARNING = 375;
    private static final int GENERAL_FONT_SIZE = 16;
    private static final int CENTERED_TEXT_X = 200;
    private static JFrame frame = new JFrame();
    private static JFrame polyScopeMainFrame;
    private final TextResource textResource;
    private final KickToScreen kickToInitScreen;
    private final Icon icon;
    private final Subscription subscribe;

    @Inject
    BrakePinFailureScreen(TextResource textResource, KickToScreen kickToInitScreen, MonitorBrakePinFailure monitorBrakePinFailure) {
        super(null);
        this.textResource = textResource;
        this.kickToInitScreen = kickToInitScreen;
        this.icon = ImageResource.brakePinFailure();
        this.initComponents();
        this.subscribe = monitorBrakePinFailure.subscribe((Consumer<Boolean>)((Consumer)this::showSplash));
    }

    public void showSplash(boolean brakePinHasFailed) {
        if (!brakePinHasFailed) {
            return;
        }
        this.subscribe.dispose();
        BrakePinFailureScreen.hidePolyScope();
        frame.setVisible(true);
    }

    private static void hidePolyScope() {
        Optional mainFrame = JFrameUtils.getApplicationMainFrame();
        if (mainFrame.isPresent()) {
            polyScopeMainFrame = (JFrame)mainFrame.get();
            polyScopeMainFrame.setVisible(false);
        }
    }

    private void initComponents() {
        this.setFrameDimensions();
        this.createHiddenButton();
        this.createTitleAndMessage();
        this.createQrCodeAndLink();
        this.bindToFrame();
    }

    private void setFrameDimensions() {
        Dimension size = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
    }

    private void createHiddenButton() {
        JButton hiddenLongPress = new JButton();
        hiddenLongPress.setBorder(BorderFactory.createEmptyBorder());
        hiddenLongPress.setOpaque(false);
        hiddenLongPress.setContentAreaFilled(false);
        hiddenLongPress.addMouseListener((MouseListener)((Object)new NavigateToInitializationScreen(this.kickToInitScreen, () -> polyScopeMainFrame.setVisible(true))));
        this.addComponentAt(hiddenLongPress, new Point(201, 204), new Dimension(135, 125));
    }

    private void createTitleAndMessage() {
        JLabel criticalBrakeSystemError = this.createLabel(this.textResource.criticalBrakeSystemError(), 46, 0);
        JLabel brakeSystemTitle = this.createLabel(this.textResource.brakeSystemTitle(), 24, 1);
        JLabel brakeSystemMessage = this.createLabel(this.textResource.brakeSystemMessage(), 16, 0);
        this.addComponentAt(criticalBrakeSystemError, new Point(375, 198), new Dimension(700, 58));
        this.addComponentAt(brakeSystemTitle, new Point(375, 271), new Dimension(700, 30));
        this.addComponentAt(brakeSystemMessage, new Point(375, 310), new Dimension(700, 60));
    }

    private void createQrCodeAndLink() {
        JLabel brakeSystemSuggestion = this.createCenteredLabel(this.textResource.brakeSystemSuggestion(), 16, 1);
        JLabel qrCodeIcon = new JLabel(new ImageIcon(WebPageLink.QR_CODE));
        String webPageLink = HTML.fontBold((String)this.textResource.link()) + " " + "https://www.universal-robots.com/articles/ur/safety/safe-brake-system";
        JLabel linkToSite = this.createCenteredLabel(webPageLink, 16, 0);
        JLabel scanQRCode = this.createCenteredLabel(this.textResource.scanQrCode(), 16, 1);
        this.addComponentAt(brakeSystemSuggestion, new Point(200, 370), new Dimension(900, 30));
        this.addComponentAt(qrCodeIcon, new Point(this.icon.getIconWidth() / 2 - 100, 420), new Dimension(200, 200));
        this.addComponentAt(linkToSite, new Point(200, 620), new Dimension(900, 20));
        this.addComponentAt(scanQRCode, new Point(200, 643), new Dimension(900, 20));
    }

    private void bindToFrame() {
        frame.setName("BRAKE_PIN_FAILURE_SCREEN");
        frame.setTitle("BRAKE_PIN_FAILURE_SCREEN");
        frame.setDefaultCloseOperation(3);
        frame.add(this);
        frame.setResizable(false);
        frame.setUndecorated(true);
        frame.pack();
        frame.setLocationRelativeTo(null);
    }

    private void addComponentAt(JComponent brakeSystemSuggestion, Point point, Dimension dimension) {
        brakeSystemSuggestion.setBounds(new Rectangle(point, dimension));
        this.add(brakeSystemSuggestion);
    }

    private JLabel createLabel(String text, int fontSize, int fontStyle) {
        JLabel result = new JLabel(HTML.html((String)text));
        result.setFont(new Font(FONT, fontStyle, fontSize));
        result.setForeground(Color.BLACK);
        result.setBackground(Color.WHITE);
        result.setVerticalTextPosition(1);
        return result;
    }

    private JLabel createCenteredLabel(String text, int fontSize, int fontStyle) {
        JLabel result = new JLabel(HTML.html((String)text));
        result.setFont(new Font(FONT, fontStyle, fontSize));
        result.setForeground(Color.BLACK);
        result.setBackground(Color.WHITE);
        result.setHorizontalAlignment(0);
        result.setVerticalTextPosition(1);
        return result;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.icon.paintIcon(this, g, 0, 0);
    }

    private static class NavigateToInitializationScreen
    extends LongPressListener {
        private final KickToScreen kickToScreen;
        private final Runnable showPolyScope;

        public NavigateToInitializationScreen(KickToScreen kickToScreen, Runnable showPolyScope) {
            super(2000);
            this.kickToScreen = kickToScreen;
            this.showPolyScope = showPolyScope;
        }

        public void onShortPress() {
        }

        public void onLongPress() {
            frame.setVisible(false);
            this.showPolyScope.run();
            this.kickToScreen.kickToInitScreen();
        }
    }
}

