/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.safebrake;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.util.event.Subscription;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class MonitorBrakePinFailure {
    private final Provider<com.ur.monitor.model.RobotMode> lastRobotMode;
    private final Recipe<Boolean> brakePinRecipe;

    @Inject
    MonitorBrakePinFailure(@Source(value=com.ur.monitor.model.RobotMode.class) Recipe<com.ur.monitor.model.RobotMode> robotModeRecipe) {
        this.lastRobotMode = robotModeRecipe.lastProvider();
        this.brakePinRecipe = robotModeRecipe.executeOnIOThread().map(com.ur.monitor.model.RobotMode::getSafetyMode).map(safetyMode -> safetyMode == SafetyMode.BRAKE_PIN_FAILURE);
    }

    Subscription subscribe(Consumer<Boolean> consumer) {
        return this.brakePinRecipe.subscribe(consumer);
    }

    boolean isRobotPoweredOff() {
        return this.isRobotMode(RobotMode.POWER_OFF);
    }

    private boolean isRobotMode(RobotMode robotMode) {
        return ((com.ur.monitor.model.RobotMode)this.lastRobotMode.get()).getRobotMode() == robotMode;
    }
}

