/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.impl.safebrake;

import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.dashboardserver.processors.ConditionalInputProcessor;
import com.ur.lang.react.Consumer;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.initializerobot.impl.safebrake.CriticalWarningBannerResponse;
import com.ur.polyscope.initializerobot.impl.safebrake.MonitorBrakePinFailure;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class SafeBrakePowerOffAction
implements ConditionalInputProcessor {
    private static final String POWER_OFF_COMMAND = "power off brake failure";
    private static final String POWERING_OFF_ARM_RESPONSE = "POWERING OFF ARM - STAND CLEAR";
    private static final ScriptActionDefinitionParser PARSER = new ScriptActionDefinitionParser("power off brake failure");
    private final ControllerInterface controllerInterface;
    private final MonitorBrakePinFailure monitorBrakePinFailure;
    private final CriticalWarningBannerResponse banner;
    private final AtomicBoolean blockForSafeBrakePin;

    @Inject
    public SafeBrakePowerOffAction(ControllerInterface controllerInterface, MonitorBrakePinFailure monitorBrakePinFailure) {
        this.controllerInterface = controllerInterface;
        this.monitorBrakePinFailure = monitorBrakePinFailure;
        this.blockForSafeBrakePin = new AtomicBoolean(false);
        this.banner = new CriticalWarningBannerResponse();
        monitorBrakePinFailure.subscribe((Consumer<Boolean>)((Consumer)this.blockForSafeBrakePin::set));
    }

    public boolean isActive() {
        return this.blockForSafeBrakePin.get();
    }

    public String process(String input) {
        if (PARSER.isMatch(input)) {
            this.controllerInterface.runScript(POWER_OFF_COMMAND);
            return POWERING_OFF_ARM_RESPONSE;
        }
        return this.createBanner();
    }

    private String createBanner() {
        if (this.monitorBrakePinFailure.isRobotPoweredOff()) {
            return this.banner.createPoweredOffBanner();
        }
        return this.banner.createBanner();
    }
}

