/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io;

import com.ur.lang.DecimalFormatFactory;
import com.ur.util.logging.Log;
import java.text.DecimalFormat;

public enum AnalogDomain {
    CURRENT(0){
        final DecimalFormat af = DecimalFormatFactory.createHalfEvenDecimalFormat((String)" 0.00;-0.00");

        @Override
        public double toValue(double rawValue) {
            return (rawValue - 0.004) / 0.016;
        }

        @Override
        public String toString(double value) {
            return this.af.format(value * 1000.0) + " mA";
        }
    }
    ,
    VOLTAGE(1){
        final DecimalFormat f = DecimalFormatFactory.createHalfEvenDecimalFormat((String)" 0.00;-0.00");

        @Override
        public double toValue(double rawValue) {
            return rawValue / 10.0;
        }

        @Override
        public String toString(double value) {
            return this.f.format(value) + " V";
        }
    };

    private int id;

    private AnalogDomain(int id) {
        this.id = id;
    }

    public abstract double toValue(double var1);

    public abstract String toString(double var1);

    public int asId() {
        return this.id;
    }

    public static AnalogDomain byId(int analogDomainAsId) {
        if (analogDomainAsId == 0 || analogDomainAsId == 1) {
            return analogDomainAsId == 0 ? CURRENT : VOLTAGE;
        }
        Log.warning((String)("Unknown AnalogDomain id: " + analogDomainAsId + ", Expected 0 or 1"));
        return CURRENT;
    }
}

