/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.tool;

import com.ur.polyscope.io.AnalogDomain;
import com.ur.view.constants.toolcomm.BaudRate;
import com.ur.view.constants.toolcomm.Parity;
import com.ur.view.constants.toolcomm.StopBits;

public class ToolAnalogInputViewModel {
    public static final boolean DEFAULT_ENABLED = false;
    public static final BaudRate DEFAULT_BAUD_RATE = BaudRate.BAUD_115200;
    public static final Parity DEFAULT_PARITY = Parity.NONE;
    public static final StopBits DEFAULT_STOP_BITS = StopBits.ONE;
    public static final float DEFAULT_RX_IDLE_CHARS = 1.5f;
    public static final float DEFAULT_TX_IDLE_CHARS = 3.5f;
    public final String pin0Name;
    public final String pin1Name;
    public final AnalogDomain pin0Domain;
    public final AnalogDomain pin1Domain;
    public final boolean enabled;
    public final BaudRate baudRate;
    public final Parity parity;
    public final StopBits stopBits;
    public final float rxIdleChars;
    public final float txIdleChars;

    public ToolAnalogInputViewModel() {
        this("analog_in[2]", "analog_in[3]", AnalogDomain.CURRENT, AnalogDomain.CURRENT, false, DEFAULT_BAUD_RATE, DEFAULT_PARITY, DEFAULT_STOP_BITS, 1.5f, 3.5f);
    }

    public ToolAnalogInputViewModel(String pin0Name, String pin1Name, AnalogDomain pin0, AnalogDomain pin1, boolean enabled, BaudRate baudRate, Parity parity, StopBits stopBits, float rxIdleChars, float txIdleChars) {
        this.pin0Name = pin0Name;
        this.pin1Name = pin1Name;
        this.pin0Domain = pin0;
        this.pin1Domain = pin1;
        this.enabled = enabled;
        this.baudRate = baudRate;
        this.parity = parity;
        this.stopBits = stopBits;
        this.rxIdleChars = rxIdleChars;
        this.txIdleChars = txIdleChars;
    }

    public String toString() {
        return "ToolAnalogInputViewModel {Pin 0 Name: " + this.pin0Name + ", Pin 1 Name: " + this.pin1Name + ", Pin 0 Domain: " + (Object)((Object)this.pin0Domain) + ", Pin 1 Domain: " + (Object)((Object)this.pin1Domain) + ", Communication Interface: " + this.enabled + ", Baud Rate: " + this.baudRate.name().replace("BAUD_", "") + ", Parity: " + this.parity + ", StopBits: " + this.stopBits + ", RX Idle Chars: " + this.rxIdleChars + ", TX Idle Chars: " + this.txIdleChars + "}";
    }
}

