/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.tool;

import com.ur.lang.HashCodeBuilder;
import com.ur.monitor.StreamedModel;
import com.ur.view.constants.toolcomm.BaudRate;
import com.ur.view.constants.toolcomm.Parity;
import com.ur.view.constants.toolcomm.StopBits;

public class ToolCommInfo
implements StreamedModel {
    public static final float ACCEPTED_TOLERANCE = 0.01f;
    private final boolean enabled;
    private final BaudRate baudRate;
    private final Parity parity;
    private final StopBits stopBits;
    private final float rxIdleChars;
    private final float txIdleChars;

    public ToolCommInfo(boolean enabled, BaudRate baudRate, Parity parity, StopBits stopBits, float rxIdleChars, float txIdleChars) {
        this.enabled = enabled;
        this.baudRate = baudRate;
        this.parity = parity;
        this.stopBits = stopBits;
        this.rxIdleChars = rxIdleChars;
        this.txIdleChars = txIdleChars;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BaudRate getBaudRate() {
        return this.baudRate;
    }

    public Parity getParity() {
        return this.parity;
    }

    public StopBits getStopBits() {
        return this.stopBits;
    }

    public float getRxIdleChars() {
        return this.rxIdleChars;
    }

    public float getTxIdleChars() {
        return this.txIdleChars;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ToolCommInfo) {
            ToolCommInfo other = (ToolCommInfo)obj;
            return this.enabled == other.enabled && this.baudRate == other.baudRate && this.parity == other.parity && this.stopBits == other.stopBits && Math.abs(this.rxIdleChars - other.rxIdleChars) < 0.01f && Math.abs(this.txIdleChars - other.txIdleChars) < 0.01f;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(2).append(this.enabled).append((Object)this.baudRate).append((Object)this.parity).append((Object)this.stopBits).append(this.rxIdleChars).append(this.txIdleChars).toHashCode();
    }

    public String toString() {
        return "ToolCommInfo {Enabled: " + this.enabled + ", Baud Rate: " + this.baudRate.name().replace("BAUD_", "") + ", Parity: " + this.parity + ", StopBits: " + this.stopBits + ", RX Idle Chars: " + this.rxIdleChars + ", TX Idle Chars: " + this.txIdleChars + "}";
    }
}

