/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.tool;

import com.ur.polyscope.io.AnalogDomain;
import com.ur.view.constants.dev.ToolOutputMode;

public class ToolIOStateViewModel {
    public final DigitalOutputModel digitalOutputModel;
    public final boolean analogCommEnabled;
    public final AnalogCommModel analogCommModel;
    public final AnalogInputModel analogInputModel;

    public ToolIOStateViewModel(DigitalOutputModel digitalOutputModel, boolean enableAnalogComm, AnalogCommModel analogCommModel, AnalogInputModel analogInputModel) {
        this.digitalOutputModel = digitalOutputModel;
        this.analogCommEnabled = enableAnalogComm;
        this.analogCommModel = analogCommModel;
        this.analogInputModel = analogInputModel;
    }

    public String toString() {
        return "ToolIOState{ " + this.digitalOutputModel + ", analogCommEnabled: " + this.analogCommEnabled + ", " + this.analogCommModel + ", " + this.analogInputModel + "}";
    }

    public static class AnalogCommModel {
        public final String baudRate;
        public final String parity;
        public final String stopBits;
        public final String rxIdleChars;
        public final String txIdleChars;

        public AnalogCommModel() {
            this("5600", "ODD", "ONE", "3.5", "1.0");
        }

        public AnalogCommModel(String baudRate, String parity, String stopBits, String rxIdleChars, String txIdleChars) {
            this.baudRate = baudRate;
            this.parity = parity;
            this.stopBits = stopBits;
            this.rxIdleChars = rxIdleChars;
            this.txIdleChars = txIdleChars;
        }

        public String toString() {
            return "AnalogComm{ baudRate: " + this.baudRate + ", parity: " + this.parity + ", stopBits: " + this.stopBits + ", rxIdle: " + this.rxIdleChars + ", txIdle: " + this.txIdleChars + "}";
        }
    }

    public static class AnalogInputModel {
        public final AnalogDomain domainPin0;
        public final AnalogDomain domainPin1;

        public AnalogInputModel() {
            this(AnalogDomain.CURRENT, AnalogDomain.VOLTAGE);
        }

        public AnalogInputModel(AnalogDomain domainPin0, AnalogDomain domainPin1) {
            this.domainPin0 = domainPin0;
            this.domainPin1 = domainPin1;
        }

        public String toString() {
            return "AnalogInput{ domainPin0: " + (Object)((Object)this.domainPin0) + ", domainPin1: " + (Object)((Object)this.domainPin1) + "}";
        }
    }

    public static class DigitalOutputModel {
        public final boolean pin0Enabled;
        public final boolean pin1Enabled;
        public final ToolOutputMode toolOutputMode;
        public final int maximumCurrent;

        public DigitalOutputModel() {
            this(true, true, ToolOutputMode.OUTPUT, 600);
        }

        public DigitalOutputModel(boolean digitalOutEnabledOnPin0, boolean digitalOutEnabledOnPin1, ToolOutputMode toolOutputMode, int maximumCurrent) {
            this.pin0Enabled = digitalOutEnabledOnPin0;
            this.pin1Enabled = digitalOutEnabledOnPin1;
            this.toolOutputMode = toolOutputMode;
            this.maximumCurrent = maximumCurrent;
        }

        public String toString() {
            return "DigitalOutput{ pin0Enabled: " + this.pin0Enabled + ", pin1Enabled: " + this.pin1Enabled + ", toolOutputMode: " + this.toolOutputMode + "}";
        }
    }
}

