/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.tool;

import java.util.HashMap;
import java.util.Map;

public enum Voltage {
    ZERO(0),
    TWELVE(12),
    TWENTY_FOUR(24);

    private final int voltageValue;
    private static Map<Integer, Voltage> map;

    private Voltage(int voltageValue) {
        this.voltageValue = voltageValue;
    }

    public static Voltage enumValueOf(int v) {
        Voltage voltage = map.get(v);
        if (voltage == null) {
            throw new IllegalArgumentException("The provided value should be one of those :" + Voltage.values());
        }
        return voltage;
    }

    public int getVoltageValue() {
        return this.voltageValue;
    }

    public String toString() {
        return Integer.toString(this.voltageValue);
    }

    static {
        map = new HashMap<Integer, Voltage>();
        for (Voltage v : Voltage.values()) {
            map.put(v.getVoltageValue(), v);
        }
    }
}

