/*
 * Decompiled with CFR 0.152.
 */
package com.ur.dashboardserver;

import com.ur.lang.Defense;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptActionDefinitionParser {
    private static final Pattern TOKENIZE_STRING = Pattern.compile("([^\"']\\S*|[\"'].+?[\"'])\\s*");
    private final String[] actionDefinition;
    private final Token tokenChain;

    public ScriptActionDefinitionParser(String actionDefinition) {
        this.actionDefinition = this.tokenize(actionDefinition);
        this.tokenChain = this.createTokenChain(this.actionDefinition);
    }

    public boolean isMatch(String lineToCheck) {
        return this.tokenChain.isMatch(0, this.tokenize(lineToCheck));
    }

    public String getArgument(int argument, String fromLine) {
        Defense.isCondition((argument >= 0 ? 1 : 0) != 0, (String)"Must be a positive argument");
        String[] lineToCheckProcessed = this.tokenize(fromLine);
        return this.tokenChain.getArgument(argument, 0, lineToCheckProcessed);
    }

    public boolean hasOption(String option, String input) {
        return this.tokenChain.hasOption(option, input);
    }

    private Token createTokenChain(String[] tokenAsString) {
        StartToken result;
        Token currentToken = result = new StartToken();
        for (String each : tokenAsString) {
            Token nextToken = this.createToken(each);
            currentToken.setNextToken(nextToken);
            currentToken = nextToken;
        }
        currentToken.setNextToken(new EndToken());
        return result;
    }

    private Token createToken(String tokenAsString) {
        if ("<arg>".equalsIgnoreCase(tokenAsString)) {
            return new ArgToken();
        }
        if ("<rest>".equalsIgnoreCase(tokenAsString)) {
            return new RestToken();
        }
        if (tokenAsString.startsWith("[") && tokenAsString.endsWith("]")) {
            String option = tokenAsString.substring(1, tokenAsString.lastIndexOf(93));
            return new OptionToken(option);
        }
        return new CommandToken(tokenAsString);
    }

    private String[] tokenize(String lineToCheck) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = TOKENIZE_STRING.matcher(lineToCheck.trim());
        while (m.find()) {
            result.add(m.group(1));
        }
        return result.toArray(new String[0]);
    }

    public static class InvalidArgumentIndex
    extends RuntimeException {
        public InvalidArgumentIndex() {
            super("There are not that many arguments.");
        }
    }

    public static class ParseError
    extends RuntimeException {
        public ParseError(String s) {
            super(s);
        }
    }

    private static class RestToken
    extends Token {
        private RestToken() {
        }

        @Override
        public boolean isMatch(int index, String[] segment) {
            if (index >= segment.length) {
                return false;
            }
            return super.isMatch(segment.length, segment);
        }

        @Override
        public void setNextToken(Token nextToken) {
            if (!(nextToken instanceof EndToken)) {
                throw new ParseError("Cannot have <rest> token in middle of action");
            }
            super.setNextToken(nextToken);
        }

        @Override
        String getArgument(int argument, int index, String[] segments) {
            Defense.isCondition((argument == 0 ? 1 : 0) != 0, (String)"Invalid argument index");
            StringBuilder result = new StringBuilder();
            for (int i = index; i < segments.length; ++i) {
                result.append(segments[i]).append(" ");
            }
            return result.toString().trim();
        }
    }

    private static class ArgToken
    extends Token {
        private ArgToken() {
        }

        @Override
        public boolean isMatch(int index, String[] segments) {
            return super.isMatch(++index, segments);
        }

        @Override
        String getArgument(int argument, int index, String[] segments) {
            if (argument == 0) {
                String toStrip;
                String result = toStrip = segments[index];
                if (toStrip.startsWith("\"") || toStrip.startsWith("'")) {
                    result = result.substring(1);
                }
                if (toStrip.endsWith("\"") || toStrip.endsWith("'")) {
                    result = result.substring(0, result.length() - 1);
                }
                return result;
            }
            return super.getArgument(--argument, ++index, segments);
        }
    }

    private static class OptionToken
    extends Token {
        private String segment;

        public OptionToken(String segment) {
            this.segment = segment;
        }

        @Override
        public boolean isMatch(int index, String[] segments) {
            if (index >= segments.length) {
                return super.isMatch(index, segments);
            }
            if (segments[index].equals(this.segment)) {
                return super.isMatch(++index, segments);
            }
            return super.isMatch(index, segments);
        }

        @Override
        String getArgument(int argument, int index, String[] segments) {
            if (segments[index].equals(this.segment)) {
                return super.getArgument(argument, ++index, segments);
            }
            return super.getArgument(argument, index, segments);
        }

        @Override
        public boolean hasOption(String option, String input) {
            return input.contains(option);
        }
    }

    private static class CommandToken
    extends Token {
        private String segment;

        public CommandToken(String segment) {
            this.segment = segment;
        }

        @Override
        public boolean isMatch(int index, String[] segments) {
            if (index >= segments.length) {
                return false;
            }
            if (this.segment.equalsIgnoreCase(segments[index])) {
                return super.isMatch(++index, segments);
            }
            return false;
        }

        @Override
        String getArgument(int argument, int index, String[] segments) {
            return super.getArgument(argument, ++index, segments);
        }
    }

    private static class EndToken
    extends Token {
        private EndToken() {
        }

        @Override
        public boolean isMatch(int index, String[] segments) {
            return index == segments.length;
        }

        @Override
        void setNextToken(Token nextToken) {
            throw new ParseError("Parser already compiled, cannot modify");
        }

        @Override
        String getArgument(int argument, int index, String[] segments) {
            throw new InvalidArgumentIndex();
        }

        @Override
        public boolean hasOption(String option, String input) {
            return false;
        }
    }

    private static class StartToken
    extends Token {
        private StartToken() {
        }
    }

    private static class Token {
        private Token nextToken;

        private Token() {
        }

        public boolean isMatch(int index, String[] segment) {
            if (index > segment.length) {
                return false;
            }
            return this.nextToken.isMatch(index, segment);
        }

        void setNextToken(Token nextToken) {
            this.nextToken = nextToken;
        }

        String getArgument(int argument, int index, String[] segments) {
            return this.nextToken.getArgument(argument, index, segments);
        }

        public boolean hasOption(String option, String input) {
            return this.nextToken.hasOption(option, input);
        }
    }
}

