/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.comm;

import java.util.HashMap;
import java.util.Map;

public enum CalibrationVerificationType {
    NORMAL(1),
    THREE_POINT(2);

    private static final Map<Integer, CalibrationVerificationType> idCache;
    private int id;

    private CalibrationVerificationType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static CalibrationVerificationType byId(int id) {
        if (idCache.isEmpty()) {
            CalibrationVerificationType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No CalibrationVerificationType with id " + id + " supported!");
        return CalibrationVerificationType.values()[0];
    }

    private static void buildCache() {
        for (CalibrationVerificationType each : CalibrationVerificationType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, CalibrationVerificationType>();
    }
}

