/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.comm;

import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    DISCONNECT(-1),
    ROBOT_STATE(16),
    ROBOT_MESSAGE(20),
    HMC_MESSAGE(22),
    MODBUS_INFO_MESSAGE(5),
    SAFETY_SETUP_BROADCAST_MESSAGE(23),
    SAFETY_COMPLIANCE_TOLERANCES_MESSAGE(24),
    PROGRAM_STATE_MESSAGE(25);

    private static final Map<Integer, MessageType> idCache;
    private int id;

    private MessageType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static MessageType byId(int id) {
        if (idCache.isEmpty()) {
            MessageType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No MessageType with id " + id + " supported!");
        return MessageType.values()[0];
    }

    private static void buildCache() {
        for (MessageType each : MessageType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, MessageType>();
    }
}

